/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.internal.tracer;

import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.monitor.internal.event.ApolloClientMonitorEventFactory;
import com.ctrip.framework.apollo.monitor.internal.event.ApolloClientMonitorEventPublisher;
import com.ctrip.framework.apollo.monitor.internal.tracer.ApolloClientMessageProducerComposite;
import com.ctrip.framework.apollo.tracer.spi.MessageProducer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.ctrip.framework.apollo.util.date.DateUtil;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ApolloClientMonitorMessageProducer
implements MessageProducer {
    public static final List<String> TAGS = Collections.unmodifiableList(Arrays.asList("Apollo.Client.ConfigChanges", "ApolloConfigException", "Apollo.MetaService", "Apollo.Config.Services", "Apollo.Client.Version", "Apollo.ConfigService", "Apollo.Client.ConfigMeta", "Apollo.Client.NamespaceTimeout", "Apollo.Client.NamespaceUsage", "Apollo.Client.NamespaceNotFound"));

    public void logError(Throwable cause) {
        this.publishErrorEvent(cause);
    }

    public void logError(String message, Throwable cause) {
        this.publishErrorEvent(cause);
    }

    public void logEvent(String type, String name) {
        if (TAGS.contains(type)) {
            this.handleTaggedEvent(type, name);
        } else if (type.startsWith("Apollo.Client.Configs.")) {
            this.handleClientConfigEvent(type, name);
        } else if (type.startsWith("Apollo.Client.NamespaceFirstLoadSpendTime")) {
            this.handleFirstLoadTimeEvent(type, name);
        }
    }

    private void handleTaggedEvent(String type, String name) {
        switch (type) {
            case "Apollo.ConfigService": {
                name = name.substring("periodicRefresh: ".length());
            }
            case "Apollo.Client.ConfigChanges": {
                this.publishConfigChangeEvent(name);
                break;
            }
            case "ApolloConfigException": {
                this.logError(new ApolloConfigException(name));
                break;
            }
            case "Apollo.MetaService": {
                this.publishMetaServiceEvent();
                break;
            }
            case "Apollo.Config.Services": {
                this.publishConfigServiceEvent(name);
                break;
            }
            case "Apollo.Client.Version": {
                this.publishClientVersionEvent(name);
                break;
            }
            case "Apollo.Client.NamespaceTimeout": {
                this.publishNamespaceTimeoutEvent(name);
                break;
            }
            case "Apollo.Client.NamespaceNotFound": {
                this.publishNamespaceNotFoundEvent(name);
                break;
            }
            case "Apollo.Client.ConfigMeta": {
                break;
            }
        }
    }

    private void publishErrorEvent(Throwable cause) {
        ApolloClientMonitorEventPublisher.publish(ApolloClientMonitorEventFactory.getInstance().createEvent("ErrorMonitor").withTag("ErrorMonitor").putAttachment("throwable", cause));
    }

    private void publishConfigChangeEvent(String name) {
        ApolloClientMonitorEventPublisher.publish(ApolloClientMonitorEventFactory.getInstance().createEvent("apollo_client_namespace_latest_update_time").putAttachment("namespace", name).withTag("NamespaceMonitor"));
    }

    private void publishMetaServiceEvent() {
        ApolloClientMonitorEventPublisher.publish(ApolloClientMonitorEventFactory.getInstance().createEvent("metaFreshTime").withTag("BootstrapMonitor").putAttachment("metaFreshTime", DateUtil.formatLocalDateTime(LocalDateTime.now()).orElse("")));
    }

    private void publishConfigServiceEvent(String name) {
        ApolloClientMonitorEventPublisher.publish(ApolloClientMonitorEventFactory.getInstance().createEvent("configServiceUrl").withTag("BootstrapMonitor").putAttachment("configServiceUrl", name));
    }

    private void publishClientVersionEvent(String name) {
        ApolloClientMonitorEventPublisher.publish(ApolloClientMonitorEventFactory.getInstance().createEvent("version").withTag("BootstrapMonitor").putAttachment("version", name));
    }

    private void publishNamespaceTimeoutEvent(String name) {
        ApolloClientMonitorEventPublisher.publish(ApolloClientMonitorEventFactory.getInstance().createEvent("Apollo.Client.NamespaceTimeout").putAttachment("namespace", name).withTag("NamespaceMonitor"));
    }

    private void publishNamespaceNotFoundEvent(String name) {
        ApolloClientMonitorEventPublisher.publish(ApolloClientMonitorEventFactory.getInstance().createEvent("Apollo.Client.NamespaceNotFound").withTag("NamespaceMonitor").putAttachment("namespace", name));
    }

    private void handleClientConfigEvent(String type, String name) {
        String namespace = type.substring("Apollo.Client.Configs.".length());
        ApolloClientMonitorEventPublisher.publish(ApolloClientMonitorEventFactory.getInstance().createEvent("releaseKey").withTag("NamespaceMonitor").putAttachment("releaseKey", name).putAttachment("namespace", namespace));
    }

    private void handleFirstLoadTimeEvent(String type, String name) {
        String[] split = type.split(":");
        String namespace = split[1];
        long firstLoadTime = Long.parseLong(name);
        ApolloClientMonitorEventPublisher.publish(ApolloClientMonitorEventFactory.getInstance().createEvent("Apollo.Client.NamespaceFirstLoadSpendTime").putAttachment("namespace", namespace).putAttachment("timestamp", firstLoadTime).withTag("NamespaceMonitor"));
    }

    public void logEvent(String type, String name, String status, String nameValuePairs) {
    }

    public void logMetricsForCount(String name) {
        String[] split = name.split(":");
        if (split.length == 2 && "Apollo.Client.NamespaceUsage".equals(split[0])) {
            ApolloClientMonitorEventPublisher.publish(ApolloClientMonitorEventFactory.getInstance().createEvent("Apollo.Client.NamespaceUsage").putAttachment("namespace", split[1]).withTag("NamespaceMonitor"));
        }
    }

    public Transaction newTransaction(String type, String name) {
        return ApolloClientMessageProducerComposite.NULL_TRANSACTION;
    }
}

