/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.internal.exporter.impl;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.utils.DeferredLoggerFactory;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.monitor.internal.exporter.ApolloClientMetricsExporter;
import com.ctrip.framework.apollo.monitor.internal.exporter.ApolloClientMetricsExporterFactory;
import com.ctrip.framework.apollo.monitor.internal.listener.ApolloClientMonitorEventListener;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.ctrip.framework.foundation.internals.ServiceBootstrap;
import java.util.List;
import org.slf4j.Logger;

public class DefaultApolloClientMetricsExporterFactory
implements ApolloClientMetricsExporterFactory {
    private static final Logger logger = DeferredLoggerFactory.getLogger(DefaultApolloClientMetricsExporterFactory.class);
    private final ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);

    @Override
    public ApolloClientMetricsExporter getMetricsReporter(List<ApolloClientMonitorEventListener> listeners) {
        String externalSystemType = this.configUtil.getMonitorExternalType();
        return this.findAndInitializeExporter(listeners, externalSystemType);
    }

    private ApolloClientMetricsExporter findAndInitializeExporter(List<ApolloClientMonitorEventListener> listeners, String externalSystemType) {
        List exporters = ServiceBootstrap.loadAllOrdered(ApolloClientMetricsExporter.class);
        if (StringUtils.isEmpty((String)externalSystemType)) {
            return null;
        }
        ApolloClientMetricsExporter reporter = exporters.stream().filter(metricsExporter -> metricsExporter.isSupport(externalSystemType)).findFirst().orElse(null);
        if (reporter != null) {
            reporter.init(listeners, this.configUtil.getMonitorExternalExportPeriod());
        } else {
            String errorMessage = "No matching exporter found with monitor-external-type " + externalSystemType;
            ApolloConfigException exception = new ApolloConfigException(errorMessage);
            logger.error("Error initializing exporter for external-type: {}. Please check if external-type is misspelled or the correct dependency is not introduced, such as apollo-plugin-client-prometheus", (Object)externalSystemType, (Object)exception);
            Tracer.logError((Throwable)exception);
        }
        return reporter;
    }
}

