/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.internal.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ApolloClientMonitorEvent {
    private final String name;
    private final Map<String, Object> attachments;
    private String tag;

    public ApolloClientMonitorEvent(String name, String tag, Map<String, Object> attachments) {
        this.name = name;
        this.tag = tag;
        this.attachments = attachments != null ? new HashMap<String, Object>(attachments) : Collections.emptyMap();
    }

    public ApolloClientMonitorEvent withTag(String tag) {
        this.tag = tag;
        return this;
    }

    public String getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public ApolloClientMonitorEvent putAttachment(String key, Object value) {
        this.attachments.put(key, value);
        return this;
    }

    public <T> T getAttachmentValue(String key) {
        Object value = this.attachments.get(key);
        if (value == null) {
            return null;
        }
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value for key " + key + " is not of expected type", e);
        }
    }
}

