/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.internals.ConfigManager;
import com.ctrip.framework.apollo.internals.ConfigMonitorInitializer;
import com.ctrip.framework.apollo.monitor.api.ConfigMonitor;
import com.ctrip.framework.apollo.spi.ConfigFactory;
import com.ctrip.framework.apollo.spi.ConfigRegistry;
import com.ctrip.framework.apollo.util.ConfigUtil;

public class ConfigService {
    private static final ConfigService s_instance = new ConfigService();
    private volatile ConfigMonitor m_configMonitor;
    private volatile ConfigManager m_configManager;
    private volatile ConfigRegistry m_configRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigMonitor getMonitor() {
        this.getManager();
        if (this.m_configMonitor == null) {
            ConfigService configService = this;
            synchronized (configService) {
                if (this.m_configMonitor == null) {
                    this.m_configMonitor = ApolloInjector.getInstance(ConfigMonitor.class);
                }
            }
        }
        return this.m_configMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigManager getManager() {
        if (this.m_configManager == null) {
            ConfigService configService = this;
            synchronized (configService) {
                if (this.m_configManager == null) {
                    this.m_configManager = ApolloInjector.getInstance(ConfigManager.class);
                    ConfigMonitorInitializer.initialize();
                }
            }
        }
        return this.m_configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigRegistry getRegistry() {
        if (this.m_configRegistry == null) {
            ConfigService configService = this;
            synchronized (configService) {
                if (this.m_configRegistry == null) {
                    this.m_configRegistry = ApolloInjector.getInstance(ConfigRegistry.class);
                }
            }
        }
        return this.m_configRegistry;
    }

    public static Config getAppConfig() {
        return ConfigService.getConfig("application");
    }

    public static Config getConfig(String namespace) {
        return s_instance.getManager().getConfig(namespace);
    }

    public static Config getConfig(String appId, String namespace) {
        return s_instance.getManager().getConfig(appId, namespace);
    }

    public static ConfigFile getConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        return s_instance.getManager().getConfigFile(namespace, configFileFormat);
    }

    public static ConfigMonitor getConfigMonitor() {
        return s_instance.getMonitor();
    }

    static void setConfig(Config config) {
        ConfigService.setConfig("application", config);
    }

    static void setConfig(String namespace, final Config config) {
        s_instance.getRegistry().register(namespace, new ConfigFactory(){
            private final ConfigUtil m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);

            @Override
            public Config create(String namespace) {
                return config;
            }

            @Override
            public Config create(String appId, String namespace) {
                if (!StringUtils.equals((String)appId, (String)this.m_configUtil.getAppId())) {
                    throw new IllegalArgumentException("Provided appId '" + appId + "' does not match the default appId '" + this.m_configUtil.getAppId() + "'");
                }
                return config;
            }

            @Override
            public ConfigFile createConfigFile(String namespace, ConfigFileFormat configFileFormat) {
                return null;
            }

            @Override
            public ConfigFile createConfigFile(String appId, String namespace, ConfigFileFormat configFileFormat) {
                return null;
            }
        });
    }

    static void setConfigFactory(ConfigFactory factory) {
        ConfigService.setConfigFactory("application", factory);
    }

    static void setConfigFactory(String namespace, ConfigFactory factory) {
        s_instance.getRegistry().register(namespace, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        ConfigService configService = s_instance;
        synchronized (configService) {
            ConfigService.s_instance.m_configManager = null;
            ConfigService.s_instance.m_configRegistry = null;
        }
    }
}

