/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.misc;

import com.corundumstudio.socketio.misc.CompositeIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompositeIterable<T>
implements Iterable<T> {
    private List<Iterable<T>> iterablesList;
    private Iterable<T>[] iterables;

    public CompositeIterable(List<Iterable<T>> iterables) {
        this.iterablesList = iterables;
    }

    public CompositeIterable(Iterable<T> ... iterables) {
        this.iterables = iterables;
    }

    public CompositeIterable(CompositeIterable<T> iterable) {
        this.iterables = iterable.iterables;
        this.iterablesList = iterable.iterablesList;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
        if (this.iterables != null) {
            for (Iterable<T> iterable : this.iterables) {
                iterators.add(iterable.iterator());
            }
        } else {
            for (Iterable<T> iterable : this.iterablesList) {
                iterators.add(iterable.iterator());
            }
        }
        return new CompositeIterator(iterators.iterator());
    }
}

