/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.messages.HttpErrorMessage;
import com.corundumstudio.socketio.messages.HttpMessage;
import com.corundumstudio.socketio.messages.OutPacketMessage;
import com.corundumstudio.socketio.messages.XHROptionsMessage;
import com.corundumstudio.socketio.messages.XHRPostMessage;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class EncoderHandler
extends ChannelOutboundHandlerAdapter {
    private static final byte[] OK = "ok".getBytes(CharsetUtil.UTF_8);
    public static final AttributeKey<String> ORIGIN = AttributeKey.valueOf((String)"origin");
    public static final AttributeKey<String> USER_AGENT = AttributeKey.valueOf((String)"userAgent");
    public static final AttributeKey<Boolean> B64 = AttributeKey.valueOf((String)"b64");
    public static final AttributeKey<Integer> JSONP_INDEX = AttributeKey.valueOf((String)"jsonpIndex");
    public static final AttributeKey<Boolean> WRITE_ONCE = AttributeKey.valueOf((String)"writeOnce");
    private static final Logger log = LoggerFactory.getLogger(EncoderHandler.class);
    private final PacketEncoder encoder;
    private String version;
    private Configuration configuration;

    public EncoderHandler(Configuration configuration, PacketEncoder encoder) throws IOException {
        this.encoder = encoder;
        this.configuration = configuration;
        if (configuration.isAddVersionHeader()) {
            this.readVersion();
        }
    }

    private void readVersion() throws IOException {
        Enumeration<URL> resources = ((Object)((Object)this)).getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            try {
                String name;
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes attrs = manifest.getMainAttributes();
                if (attrs == null || (name = attrs.getValue("Bundle-Name")) == null || !name.equals("netty-socketio")) continue;
                this.version = name + "/" + attrs.getValue("Bundle-Version");
                break;
            }
            catch (IOException iOException) {
            }
        }
    }

    private void write(XHROptionsMessage msg, ChannelHandlerContext ctx, ChannelPromise promise) {
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)("io=" + msg.getSessionId())).add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE).add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, (Object)HttpHeaderNames.CONTENT_TYPE);
        String origin = (String)ctx.channel().attr(ORIGIN).get();
        this.addOriginHeaders(origin, (HttpResponse)res);
        ByteBuf out = this.encoder.allocateBuffer(ctx.alloc());
        this.sendMessage(msg, ctx.channel(), out, (HttpResponse)res, promise);
    }

    private void write(XHRPostMessage msg, ChannelHandlerContext ctx, ChannelPromise promise) {
        ByteBuf out = this.encoder.allocateBuffer(ctx.alloc());
        out.writeBytes(OK);
        this.sendMessage(msg, ctx.channel(), out, "text/html", promise, HttpResponseStatus.OK);
    }

    private void sendMessage(HttpMessage msg, Channel channel, ByteBuf out, String type, ChannelPromise promise, HttpResponseStatus status) {
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        res.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)type).add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        if (msg.getSessionId() != null) {
            res.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)("io=" + msg.getSessionId()));
        }
        String origin = (String)channel.attr(ORIGIN).get();
        this.addOriginHeaders(origin, (HttpResponse)res);
        HttpUtil.setContentLength((io.netty.handler.codec.http.HttpMessage)res, (long)out.readableBytes());
        String userAgent = (String)channel.attr(USER_AGENT).get();
        if (userAgent != null && (userAgent.contains(";MSIE") || userAgent.contains("Trident/"))) {
            res.headers().add("X-XSS-Protection", (Object)"0");
        }
        this.sendMessage(msg, channel, out, (HttpResponse)res, promise);
    }

    private void sendMessage(HttpMessage msg, Channel channel, ByteBuf out, HttpResponse res, ChannelPromise promise) {
        channel.write((Object)res);
        if (log.isTraceEnabled()) {
            if (msg.getSessionId() != null) {
                log.trace("Out message: {} - sessionId: {}", (Object)out.toString(CharsetUtil.UTF_8), (Object)msg.getSessionId());
            } else {
                log.trace("Out message: {}", (Object)out.toString(CharsetUtil.UTF_8));
            }
        }
        if (out.isReadable()) {
            channel.write((Object)new DefaultHttpContent(out));
        } else {
            out.release();
        }
        channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, promise).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void sendError(HttpErrorMessage errorMsg, ChannelHandlerContext ctx, ChannelPromise promise) throws IOException {
        ByteBuf encBuf = this.encoder.allocateBuffer(ctx.alloc());
        ByteBufOutputStream out = new ByteBufOutputStream(encBuf);
        this.encoder.getJsonSupport().writeValue(out, errorMsg.getData());
        this.sendMessage(errorMsg, ctx.channel(), encBuf, "application/json", promise, HttpResponseStatus.BAD_REQUEST);
    }

    private void addOriginHeaders(String origin, HttpResponse res) {
        if (this.version != null) {
            res.headers().add((CharSequence)HttpHeaderNames.SERVER, (Object)this.version);
        }
        if (this.configuration.getOrigin() != null) {
            res.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)this.configuration.getOrigin());
            res.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)Boolean.TRUE);
        } else if (origin != null) {
            res.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
            res.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)Boolean.TRUE);
        } else {
            res.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof HttpMessage)) {
            super.write(ctx, msg, promise);
            return;
        }
        if (msg instanceof OutPacketMessage) {
            OutPacketMessage m = (OutPacketMessage)msg;
            if (m.getTransport() == Transport.WEBSOCKET) {
                this.handleWebsocket((OutPacketMessage)msg, ctx, promise);
            }
            if (m.getTransport() == Transport.POLLING) {
                this.handleHTTP((OutPacketMessage)msg, ctx, promise);
            }
        } else if (msg instanceof XHROptionsMessage) {
            this.write((XHROptionsMessage)msg, ctx, promise);
        } else if (msg instanceof XHRPostMessage) {
            this.write((XHRPostMessage)msg, ctx, promise);
        } else if (msg instanceof HttpErrorMessage) {
            this.sendError((HttpErrorMessage)msg, ctx, promise);
        }
    }

    private void handleWebsocket(OutPacketMessage msg, ChannelHandlerContext ctx, ChannelPromise promise) throws IOException {
        ChannelFutureList writeFutureList = new ChannelFutureList();
        block0: while (true) {
            Queue<Packet> queue;
            Packet packet;
            if ((packet = (queue = msg.getClientHead().getPacketsQueue(msg.getTransport())).poll()) == null) {
                writeFutureList.setChannelPromise(promise);
                break;
            }
            ByteBuf out = this.encoder.allocateBuffer(ctx.alloc());
            this.encoder.encodePacket(packet, out, ctx.alloc(), true);
            TextWebSocketFrame res = new TextWebSocketFrame(out);
            if (log.isTraceEnabled()) {
                log.trace("Out message: {} sessionId: {}", (Object)out.toString(CharsetUtil.UTF_8), (Object)msg.getSessionId());
            }
            if (out.isReadable()) {
                writeFutureList.add(ctx.channel().writeAndFlush((Object)res));
            } else {
                out.release();
            }
            Iterator<ByteBuf> i$ = packet.getAttachments().iterator();
            while (true) {
                if (!i$.hasNext()) continue block0;
                ByteBuf buf = i$.next();
                ByteBuf outBuf = this.encoder.allocateBuffer(ctx.alloc());
                outBuf.writeByte(4);
                outBuf.writeBytes(buf);
                if (log.isTraceEnabled()) {
                    log.trace("Out attachment: {} sessionId: {}", (Object)ByteBufUtil.hexDump((ByteBuf)outBuf), (Object)msg.getSessionId());
                }
                writeFutureList.add(ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(outBuf)));
            }
            break;
        }
    }

    private void handleHTTP(OutPacketMessage msg, ChannelHandlerContext ctx, ChannelPromise promise) throws IOException {
        Channel channel = ctx.channel();
        Attribute attr = channel.attr(WRITE_ONCE);
        Queue<Packet> queue = msg.getClientHead().getPacketsQueue(msg.getTransport());
        if (!channel.isActive() || queue.isEmpty() || !attr.compareAndSet(null, (Object)true)) {
            promise.trySuccess();
            return;
        }
        ByteBuf out = this.encoder.allocateBuffer(ctx.alloc());
        Boolean b64 = (Boolean)ctx.channel().attr(B64).get();
        if (b64 != null && b64.booleanValue()) {
            Integer jsonpIndex = (Integer)ctx.channel().attr(JSONP_INDEX).get();
            this.encoder.encodeJsonP(jsonpIndex, queue, out, ctx.alloc(), 50);
            String type = "application/javascript";
            if (jsonpIndex == null) {
                type = "text/plain";
            }
            this.sendMessage(msg, channel, out, type, promise, HttpResponseStatus.OK);
        } else {
            this.encoder.encodePackets(queue, out, ctx.alloc(), 50);
            this.sendMessage(msg, channel, out, "application/octet-stream", promise, HttpResponseStatus.OK);
        }
    }

    private class ChannelFutureList
    implements GenericFutureListener<Future<Void>> {
        private List<ChannelFuture> futureList = new ArrayList<ChannelFuture>();
        private ChannelPromise promise = null;

        private ChannelFutureList() {
        }

        private void cleanup() {
            this.promise = null;
            for (ChannelFuture f : this.futureList) {
                f.removeListener((GenericFutureListener)this);
            }
        }

        private void validate() {
            boolean allSuccess = true;
            for (ChannelFuture f : this.futureList) {
                if (f.isDone()) {
                    if (f.isSuccess()) continue;
                    this.promise.tryFailure(f.cause());
                    this.cleanup();
                    return;
                }
                allSuccess = false;
            }
            if (allSuccess) {
                this.promise.trySuccess();
                this.cleanup();
            }
        }

        public void add(ChannelFuture f) {
            this.futureList.add(f);
            f.addListener((GenericFutureListener)this);
        }

        public void setChannelPromise(ChannelPromise p) {
            this.promise = p;
            this.validate();
        }

        public void operationComplete(Future<Void> voidFuture) throws Exception {
            if (this.promise != null) {
                this.validate();
            }
        }
    }
}

