/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.protocol;

import java.io.IOException;
import ytx.org.apache.http.HttpException;
import ytx.org.apache.http.HttpRequest;
import ytx.org.apache.http.HttpRequestInterceptor;
import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.protocol.HttpContext;

@Immutable
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

