/*
 * Decompiled with CFR 0.152.
 */
package com.cloopen.rest.sdk;

import com.cloopen.rest.sdk.utils.CcopHttpClient;
import com.cloopen.rest.sdk.utils.DateUtil;
import com.cloopen.rest.sdk.utils.EncryptUtil;
import com.cloopen.rest.sdk.utils.LoggerUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import ytx.org.apache.http.HttpEntity;
import ytx.org.apache.http.HttpResponse;
import ytx.org.apache.http.client.methods.HttpGet;
import ytx.org.apache.http.client.methods.HttpPost;
import ytx.org.apache.http.client.methods.HttpRequestBase;
import ytx.org.apache.http.entity.BasicHttpEntity;
import ytx.org.apache.http.impl.client.DefaultHttpClient;
import ytx.org.apache.http.message.AbstractHttpMessage;
import ytx.org.apache.http.util.EntityUtils;

public class CCPRestSDK {
    private static final int Request_Get = 0;
    private static final int Request_Post = 1;
    private static final String Account_Info = "AccountInfo";
    private static final String Create_SubAccount = "SubAccounts";
    private static final String Get_SubAccounts = "GetSubAccounts";
    private static final String Query_SubAccountByName = "QuerySubAccountByName";
    private static final String SMSMessages = "SMS/Messages";
    private static final String TemplateSMS = "SMS/TemplateSMS";
    private static final String Call_back = "Calls/Callback";
    private static final String LandingCalls = "Calls/LandingCalls";
    private static final String VoiceVerify = "Calls/VoiceVerify";
    private static final String IvrDial = "ivr/dial";
    private static final String BillRecords = "BillRecords";
    private String SERVER_IP;
    private String SERVER_PORT;
    private String ACCOUNT_SID;
    private String ACCOUNT_TOKEN;
    private String SUBACCOUNT_SID;
    private String SUBACCOUNT_Token;
    private String VOIP_ACCOUNT;
    private String VOIP_TOKEN;
    public String App_ID;
    private BodyType BODY_TYPE = BodyType.Type_JSON;

    public void init(String serverIP, String serverPort) {
        if (this.isEmpty(serverIP) || this.isEmpty(serverPort)) {
            LoggerUtil.fatal("\u521d\u59cb\u5316\u5f02\u5e38:serverIP\u6216serverPort\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(serverIP) ? " \u670d\u52a1\u5668\u5730\u5740 " : "") + (this.isEmpty(serverPort) ? " \u670d\u52a1\u5668\u7aef\u53e3 " : "") + "\u4e3a\u7a7a");
        }
        this.SERVER_IP = serverIP;
        this.SERVER_PORT = serverPort;
    }

    public void setAccount(String accountSid, String accountToken) {
        if (this.isEmpty(accountSid) || this.isEmpty(accountToken)) {
            LoggerUtil.fatal("\u521d\u59cb\u5316\u5f02\u5e38:accountSid\u6216accountToken\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(accountSid) ? " \u4e3b\u5e10\u53f7\u540d\u79f0" : "") + (this.isEmpty(accountToken) ? " \u4e3b\u5e10\u53f7\u4ee4\u724c " : "") + "\u4e3a\u7a7a");
        }
        this.ACCOUNT_SID = accountSid;
        this.ACCOUNT_TOKEN = accountToken;
    }

    public void setSubAccount(String subAccountSid, String subAccountToken) {
        if (this.isEmpty(subAccountSid) || this.isEmpty(subAccountToken)) {
            LoggerUtil.fatal("\u521d\u59cb\u5316\u5f02\u5e38:subAccountSid\u6216subAccountToken\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(subAccountSid) ? " \u5b50\u5e10\u53f7\u540d\u79f0" : "") + (this.isEmpty(subAccountToken) ? " \u5b50\u5e10\u53f7\u4ee4\u724c " : "") + "\u4e3a\u7a7a");
        }
        this.SUBACCOUNT_SID = subAccountSid;
        this.SUBACCOUNT_Token = subAccountToken;
    }

    public void setAppId(String appId) {
        if (this.isEmpty(appId)) {
            LoggerUtil.fatal("\u521d\u59cb\u5316\u5f02\u5e38:appId\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: \u5e94\u7528Id \u4e3a\u7a7a");
        }
        this.App_ID = appId;
    }

    public void setVoIPAccount(String voIPAccount, String voIPPassWord) {
        if (this.isEmpty(voIPAccount) || this.isEmpty(voIPPassWord)) {
            LoggerUtil.fatal("\u521d\u59cb\u5316\u5f02\u5e38:voIPAccount\u6216voIPPassWord\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(voIPAccount) ? " VoIP\u5e10\u53f7" : "") + (this.isEmpty(voIPPassWord) ? " VoIP\u5bc6\u7801 " : "") + "\u4e3a\u7a7a");
        }
        this.VOIP_ACCOUNT = voIPAccount;
        this.VOIP_TOKEN = voIPPassWord;
    }

    public HashMap<String, Object> billRecords(String date, String keywords) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(date)) {
            LoggerUtil.fatal("\u5fc5\u9009\u53c2\u6570: \u65e5\u671f  \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: \u65e5\u671f  \u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            LoggerUtil.error(e1.getMessage());
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            try {
                HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, BillRecords);
                String requsetbody = "";
                if (this.BODY_TYPE == BodyType.Type_JSON) {
                    JsonObject json = new JsonObject();
                    json.addProperty("appId", this.App_ID);
                    json.addProperty("date", date);
                    if (!this.isEmpty(keywords)) {
                        json.addProperty("keywords", keywords);
                    }
                    requsetbody = json.toString();
                } else {
                    StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><BillRecords>");
                    sb.append("<appId>").append(this.App_ID).append("</appId>").append("<date>").append(date).append("</date>");
                    if (!this.isEmpty(keywords)) {
                        sb.append("<keywords>").append(keywords).append("</keywords>");
                    }
                    sb.append("</BillRecords>").toString();
                    requsetbody = sb.toString();
                }
                LoggerUtil.info("BillRecords Request body = : " + requsetbody);
                BasicHttpEntity requestBody = new BasicHttpEntity();
                requestBody.setContent(new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
                requestBody.setContentLength(requsetbody.getBytes("UTF-8").length);
                httppost.setEntity(requestBody);
                HttpResponse response = httpclient.execute(httppost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString(entity, "UTF-8");
                }
                EntityUtils.consume(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        LoggerUtil.info("billRecords response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    public HashMap<String, Object> ivrDial(String number, String userdata, boolean record) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(number)) {
            LoggerUtil.fatal("\u5fc5\u9009\u53c2\u6570: \u5f85\u547c\u53eb\u53f7\u7801   \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: \u5f85\u547c\u53eb\u53f7\u7801   \u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            try {
                HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, IvrDial);
                String requsetbody = "";
                StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><Request>");
                sb.append("<Appid>").append(this.App_ID).append("</Appid>").append("<Dial number=").append("\"").append(number).append("\"");
                if (record) {
                    sb.append(" record=").append("\"").append(record).append("\"");
                }
                if (userdata != null) {
                    sb.append(" userdata=").append("\"").append(userdata).append("\"");
                }
                sb.append("></Dial></Request>").toString();
                requsetbody = sb.toString();
                LoggerUtil.info("ivrDial Request body = : " + requsetbody);
                BasicHttpEntity requestBody = new BasicHttpEntity();
                requestBody.setContent(new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
                requestBody.setContentLength(requsetbody.getBytes("UTF-8").length);
                httppost.setEntity(requestBody);
                HttpResponse response = httpclient.execute(httppost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString(entity, "UTF-8");
                }
                EntityUtils.consume(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        LoggerUtil.info("ivrDial response body = " + result);
        try {
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    public HashMap<String, Object> voiceVerify(String verifyCode, String to, String displayNum, String playTimes, String respUrl) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(verifyCode) || this.isEmpty(to)) {
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(verifyCode) ? " \u9a8c\u8bc1\u7801\u5185\u5bb9 " : "") + (this.isEmpty(to) ? " \u63a5\u6536\u53f7\u7801 " : "") + "\u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            try {
                HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, VoiceVerify);
                String requsetbody = "";
                if (this.BODY_TYPE == BodyType.Type_JSON) {
                    JsonObject json = new JsonObject();
                    json.addProperty("appId", this.App_ID);
                    json.addProperty("verifyCode", verifyCode);
                    json.addProperty("to", to);
                    if (!this.isEmpty(displayNum)) {
                        json.addProperty("displayNum", displayNum);
                    }
                    if (!this.isEmpty(playTimes)) {
                        json.addProperty("playTimes", playTimes);
                    }
                    if (!this.isEmpty(respUrl)) {
                        json.addProperty("respUrl", respUrl);
                    }
                    requsetbody = json.toString();
                } else {
                    StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><VoiceVerify>");
                    sb.append("<appId>").append(this.App_ID).append("</appId>").append("<verifyCode>").append(verifyCode).append("</verifyCode>").append("<to>").append(to).append("</to>");
                    if (!this.isEmpty(displayNum)) {
                        sb.append("<displayNum>").append(displayNum).append("</displayNum>");
                    }
                    if (!this.isEmpty(playTimes)) {
                        sb.append("<playTimes>").append(playTimes).append("</playTimes>");
                    }
                    if (!this.isEmpty(respUrl)) {
                        sb.append("<respUrl>").append(respUrl).append("</respUrl>");
                    }
                    sb.append("</VoiceVerify>").toString();
                    requsetbody = sb.toString();
                }
                LoggerUtil.info("voiceVerify Request body = : " + requsetbody);
                BasicHttpEntity requestBody = new BasicHttpEntity();
                requestBody.setContent(new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
                requestBody.setContentLength(requsetbody.getBytes("UTF-8").length);
                httppost.setEntity(requestBody);
                HttpResponse response = httpclient.execute(httppost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString(entity, "UTF-8");
                }
                EntityUtils.consume(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        LoggerUtil.info("voiceVerify response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    public HashMap<String, Object> landingCall(String to, String mediaName, String mediaTxt, String displayNum, String playTimes, int type, String respUrl) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(to)) {
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(to) ? " \u88ab\u53eb\u53f7\u7801 " : "") + "\u4e3a\u7a7a");
        }
        if (this.isEmpty(mediaName) && this.isEmpty(mediaTxt)) {
            throw new IllegalArgumentException("\u53c2\u6570\u8bed\u97f3\u6587\u4ef6\u540d\u79f0\u548c\u53c2\u6570\u8bed\u97f3\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            try {
                HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, LandingCalls);
                String requsetbody = "";
                if (this.BODY_TYPE == BodyType.Type_JSON) {
                    JsonObject json = new JsonObject();
                    json.addProperty("appId", this.App_ID);
                    json.addProperty("to", to);
                    if (!this.isEmpty(mediaName)) {
                        json.addProperty("mediaName", mediaName);
                    }
                    if (type == 1) {
                        json.addProperty("mediaNameType", "1");
                    }
                    if (!this.isEmpty(mediaTxt)) {
                        json.addProperty("mediaTxt", mediaTxt);
                    }
                    if (!this.isEmpty(displayNum)) {
                        json.addProperty("displayNum", displayNum);
                    }
                    if (!this.isEmpty(playTimes)) {
                        json.addProperty("playTimes", playTimes);
                    }
                    if (!this.isEmpty(respUrl)) {
                        json.addProperty("respUrl", respUrl);
                    }
                    requsetbody = json.toString();
                } else {
                    StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><LandingCall>");
                    sb.append("<appId>").append(this.App_ID).append("</appId>").append("<to>").append(to).append("</to>");
                    if (!this.isEmpty(mediaName) && type == 1) {
                        sb.append("<mediaName type=\"1\">").append(mediaName).append("</mediaName>");
                    } else if (!this.isEmpty(mediaName)) {
                        sb.append("<mediaName>").append(mediaName).append("</mediaName>");
                    }
                    if (!this.isEmpty(mediaTxt)) {
                        sb.append("<mediaTxt>").append(mediaTxt).append("</mediaTxt>");
                    }
                    if (!this.isEmpty(displayNum)) {
                        sb.append("<displayNum>").append(displayNum).append("</displayNum>");
                    }
                    if (!this.isEmpty(playTimes)) {
                        sb.append("<playTimes>").append(playTimes).append("</playTimes>");
                    }
                    if (!this.isEmpty(respUrl)) {
                        sb.append("<respUrl>").append(respUrl).append("</respUrl>");
                    }
                    sb.append("</LandingCall>").toString();
                    requsetbody = sb.toString();
                }
                LoggerUtil.info("landingCalls Request body = : " + requsetbody);
                BasicHttpEntity requestBody = new BasicHttpEntity();
                requestBody.setContent(new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
                requestBody.setContentLength(requsetbody.getBytes("UTF-8").length);
                httppost.setEntity(requestBody);
                HttpResponse response = httpclient.execute(httppost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString(entity, "UTF-8");
                }
                EntityUtils.consume(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        LoggerUtil.info("landingCall response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    public HashMap<String, Object> callback(String from, String to, String customerSerNum, String fromSerNum, String promptTone, String userData, String maxCallTime, String hangupCdrUrl) {
        HashMap<String, Object> subAccountValidate = this.subAccountValidate();
        if (subAccountValidate != null) {
            return subAccountValidate;
        }
        if (this.isEmpty(from) || this.isEmpty(to)) {
            LoggerUtil.fatal("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(from) ? " \u4e3b\u53eb\u53f7\u7801 " : "") + (this.isEmpty(to) ? " \u88ab\u53eb\u53f7\u7801 " : "") + "\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(from) ? " \u4e3b\u53eb\u53f7\u7801 " : "") + (this.isEmpty(to) ? " \u88ab\u53eb\u53f7\u7801 " : "") + "\u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            try {
                HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, Call_back, AccountType.SubAccounts);
                String requsetbody = "";
                if (this.BODY_TYPE == BodyType.Type_JSON) {
                    JsonObject json = new JsonObject();
                    json.addProperty("from", from);
                    json.addProperty("to", to);
                    if (!this.isEmpty(customerSerNum)) {
                        json.addProperty("customerSerNum", customerSerNum);
                    }
                    if (!this.isEmpty(fromSerNum)) {
                        json.addProperty("fromSerNum", fromSerNum);
                    }
                    if (!this.isEmpty(promptTone)) {
                        json.addProperty("promptTone", promptTone);
                    }
                    if (!this.isEmpty(userData)) {
                        json.addProperty("userData", userData);
                    }
                    if (!this.isEmpty(maxCallTime)) {
                        json.addProperty("maxCallTime", maxCallTime);
                    }
                    if (!this.isEmpty(hangupCdrUrl)) {
                        json.addProperty("hangupCdrUrl", hangupCdrUrl);
                    }
                    requsetbody = json.toString();
                } else {
                    StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><CallBack>");
                    sb.append("<from>").append(from).append("</from>").append("<to>").append(to).append("</to>");
                    if (!this.isEmpty(customerSerNum)) {
                        sb.append("<customerSerNum>").append(customerSerNum).append("</customerSerNum>");
                    }
                    if (!this.isEmpty(fromSerNum)) {
                        sb.append("<fromSerNum>").append(fromSerNum).append("</fromSerNum>");
                    }
                    if (!this.isEmpty(promptTone)) {
                        sb.append("<promptTone>").append(promptTone).append("</promptTone>");
                    }
                    if (!this.isEmpty(userData)) {
                        sb.append("<userData>").append(userData).append("</userData>");
                    }
                    if (!this.isEmpty(maxCallTime)) {
                        sb.append("<maxCallTime>").append(maxCallTime).append("</maxCallTime>");
                    }
                    if (!this.isEmpty(hangupCdrUrl)) {
                        sb.append("<hangupCdrUrl>").append(hangupCdrUrl).append("</hangupCdrUrl>");
                    }
                    sb.append("</CallBack>").toString();
                    requsetbody = sb.toString();
                }
                LoggerUtil.info("Callback Request body =  " + requsetbody);
                BasicHttpEntity requestBody = new BasicHttpEntity();
                requestBody.setContent(new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
                requestBody.setContentLength(requsetbody.getBytes("UTF-8").length);
                httppost.setEntity(requestBody);
                HttpResponse response = httpclient.execute(httppost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString(entity, "UTF-8");
                }
                EntityUtils.consume(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        LoggerUtil.info("callback response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    public HashMap<String, Object> sendTemplateSMS(String to, String templateId, String[] datas) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(to) || this.isEmpty(this.App_ID) || this.isEmpty(templateId)) {
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(to) ? " \u624b\u673a\u53f7\u7801 " : "") + (this.isEmpty(templateId) ? " \u6a21\u677fId " : "") + "\u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            try {
                HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, TemplateSMS);
                String requsetbody = "";
                if (this.BODY_TYPE == BodyType.Type_JSON) {
                    JsonObject json = new JsonObject();
                    json.addProperty("appId", this.App_ID);
                    json.addProperty("to", to);
                    json.addProperty("templateId", templateId);
                    if (datas != null) {
                        StringBuilder sb = new StringBuilder("[");
                        String[] stringArray = datas;
                        int n = datas.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            sb.append("\"" + s + "\"" + ",");
                            ++n2;
                        }
                        sb.replace(sb.length() - 1, sb.length(), "]");
                        JsonParser parser = new JsonParser();
                        JsonArray Jarray = parser.parse(sb.toString()).getAsJsonArray();
                        json.add("datas", Jarray);
                    }
                    requsetbody = json.toString();
                } else {
                    StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><TemplateSMS>");
                    sb.append("<appId>").append(this.App_ID).append("</appId>").append("<to>").append(to).append("</to>").append("<templateId>").append(templateId).append("</templateId>");
                    if (datas != null) {
                        sb.append("<datas>");
                        String[] stringArray = datas;
                        int n = datas.length;
                        int parser = 0;
                        while (parser < n) {
                            String s = stringArray[parser];
                            sb.append("<data>").append(s).append("</data>");
                            ++parser;
                        }
                        sb.append("</datas>");
                    }
                    sb.append("</TemplateSMS>").toString();
                    requsetbody = sb.toString();
                }
                LoggerUtil.info("sendTemplateSMS Request body =  " + requsetbody);
                BasicHttpEntity requestBody = new BasicHttpEntity();
                requestBody.setContent(new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
                requestBody.setContentLength(requsetbody.getBytes("UTF-8").length);
                httppost.setEntity(requestBody);
                HttpResponse response = httpclient.execute(httppost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString(entity, "UTF-8");
                }
                EntityUtils.consume(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        LoggerUtil.info("sendTemplateSMS response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    public HashMap<String, Object> sendSMS(String to, String body) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(to) || this.isEmpty(body)) {
            LoggerUtil.fatal("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(to) ? " \u624b\u673a\u53f7\u7801 " : "") + (this.isEmpty(body) ? " \u77ed\u4fe1\u6b63\u6587 " : "") + "\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(to) ? " \u624b\u673a\u53f7\u7801 " : "") + (this.isEmpty(body) ? " \u77ed\u4fe1\u6b63\u6587 " : "") + "\u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            try {
                HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, SMSMessages);
                String requsetbody = "";
                if (this.BODY_TYPE == BodyType.Type_JSON) {
                    JsonObject json = new JsonObject();
                    json.addProperty("appId", this.App_ID);
                    json.addProperty("to", to);
                    json.addProperty("body", body);
                    requsetbody = json.toString();
                } else {
                    requsetbody = "<?xml version='1.0' encoding='utf-8'?><SMSMessage><appId>" + this.App_ID + "</appId>" + "<to>" + to + "</to>" + "<body>" + body + "</body>" + "</SMSMessage>";
                }
                LoggerUtil.info("sendSMS Request body =  " + requsetbody);
                BasicHttpEntity requestBody = new BasicHttpEntity();
                requestBody.setContent(new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
                requestBody.setContentLength(requsetbody.getBytes("UTF-8").length);
                httppost.setEntity(requestBody);
                HttpResponse response = httpclient.execute(httppost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString(entity, "UTF-8");
                }
                EntityUtils.consume(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        LoggerUtil.info("sendSMS response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    public HashMap<String, Object> querySubAccount(String friendlyName) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(friendlyName)) {
            LoggerUtil.fatal("\u5fc5\u9009\u53c2\u6570: \u5b50\u5e10\u53f7\u540d\u79f0 \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: \u5b50\u5e10\u53f7\u540d\u79f0 \u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            try {
                HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, Query_SubAccountByName);
                String requsetbody = "";
                if (this.BODY_TYPE == BodyType.Type_JSON) {
                    JsonObject json = new JsonObject();
                    json.addProperty("appId", this.App_ID);
                    json.addProperty("friendlyName", friendlyName);
                    requsetbody = json.toString();
                } else {
                    requsetbody = "<?xml version='1.0' encoding='utf-8'?><SubAccount><appId>" + this.App_ID + "</appId>" + "<friendlyName>" + friendlyName + "</friendlyName>" + "</SubAccount>";
                }
                LoggerUtil.info("querySubAccountByName Request body =  " + requsetbody);
                BasicHttpEntity requestBody = new BasicHttpEntity();
                requestBody.setContent(new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
                requestBody.setContentLength(requsetbody.getBytes("UTF-8").length);
                httppost.setEntity(requestBody);
                HttpResponse response = httpclient.execute(httppost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString(entity, "UTF-8");
                }
                EntityUtils.consume(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        LoggerUtil.info("querySubAccount result " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    public HashMap<String, Object> getSubAccounts(String startNo, String offset) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            try {
                HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, Get_SubAccounts);
                String requsetbody = "";
                if (this.BODY_TYPE == BodyType.Type_JSON) {
                    JsonObject json = new JsonObject();
                    json.addProperty("appId", this.App_ID);
                    if (!this.isEmpty(startNo)) {
                        json.addProperty("startNo", startNo);
                    }
                    if (!this.isEmpty(offset)) {
                        json.addProperty("offset", offset);
                    }
                    requsetbody = json.toString();
                } else {
                    StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><SubAccount>");
                    sb.append("<appId>").append(this.App_ID).append("</appId>");
                    if (!this.isEmpty(startNo)) {
                        sb.append("<startNo>").append(startNo).append("</startNo>");
                    }
                    if (!this.isEmpty(offset)) {
                        sb.append("<offset>").append(offset).append("</offset>");
                    }
                    sb.append("</SubAccount>").toString();
                    requsetbody = sb.toString();
                }
                LoggerUtil.info("GetSubAccounts Request body =  " + requsetbody);
                BasicHttpEntity requestBody = new BasicHttpEntity();
                requestBody.setContent(new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
                requestBody.setContentLength(requsetbody.getBytes("UTF-8").length);
                httppost.setEntity(requestBody);
                HttpResponse response = httpclient.execute(httppost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString(entity, "UTF-8");
                }
                EntityUtils.consume(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        LoggerUtil.info("getSubAccounts result " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    public HashMap<String, Object> queryAccountInfo() {
        if (this.isEmpty(this.SERVER_IP)) {
            return this.getMyError("172004", "IP\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.SERVER_PORT)) {
            return this.getMyError("172005", "\u7aef\u53e3\u9519\u8bef");
        }
        if (this.isEmpty(this.ACCOUNT_SID)) {
            return this.getMyError("172006", "\u4e3b\u5e10\u53f7\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.ACCOUNT_TOKEN)) {
            return this.getMyError("172007", "\u4e3b\u5e10\u53f7\u4ee4\u724c\u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            LoggerUtil.fatal(e1.getMessage());
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            try {
                HttpGet httpGet = (HttpGet)this.getHttpRequestBase(0, Account_Info);
                HttpResponse response = httpclient.execute(httpGet);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString(entity, "UTF-8");
                }
                EntityUtils.consume(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        LoggerUtil.info("queryAccountInfo response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    public HashMap<String, Object> createSubAccount(String friendlyName) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(friendlyName)) {
            LoggerUtil.fatal("\u5fc5\u9009\u53c2\u6570: \u5b50\u5e10\u53f7\u540d\u79f0 \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: \u5b50\u5e10\u53f7\u540d\u79f0 \u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            LoggerUtil.error(e1.getMessage());
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            try {
                HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, Create_SubAccount);
                String requsetbody = "";
                if (this.BODY_TYPE == BodyType.Type_JSON) {
                    JsonObject json = new JsonObject();
                    json.addProperty("appId", this.App_ID);
                    json.addProperty("friendlyName", friendlyName);
                    requsetbody = json.toString();
                } else {
                    requsetbody = "<?xml version='1.0' encoding='utf-8'?><SubAccount><appId>" + this.App_ID + "</appId>" + "<friendlyName>" + friendlyName + "</friendlyName>" + "</SubAccount>";
                }
                LoggerUtil.info("CreateSubAccount Request body =  " + requsetbody);
                BasicHttpEntity requestBody = new BasicHttpEntity();
                requestBody.setContent(new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
                requestBody.setContentLength(requsetbody.getBytes("UTF-8").length);
                httppost.setEntity(requestBody);
                HttpResponse response = httpclient.execute(httppost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString(entity, "UTF-8");
                }
                EntityUtils.consume(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        LoggerUtil.info("createSubAccount response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * Unable to fully structure code
     */
    private HashMap<String, Object> jsonToMap(String result) {
        hashMap = new HashMap<String, Object>();
        parser = new JsonParser();
        asJsonObject = parser.parse(result).getAsJsonObject();
        entrySet = asJsonObject.entrySet();
        hashMap2 = new HashMap<String, Object>();
        for (Map.Entry<String, JsonElement> m : entrySet) {
            if ("statusCode".equals(m.getKey()) || "statusMsg".equals(m.getKey())) {
                hashMap.put(m.getKey(), m.getValue().getAsString());
                continue;
            }
            if ("SubAccount".equals(m.getKey()) || "totalCount".equals(m.getKey()) || "token".equals(m.getKey()) || "downUrl".equals(m.getKey())) {
                block15: {
                    if (!"SubAccount".equals(m.getKey())) {
                        hashMap2.put(m.getKey(), m.getValue().getAsString());
                    } else {
                        try {
                            if (m.getValue().toString().trim().length() <= 2 && !m.getValue().toString().contains("[")) {
                                hashMap2.put(m.getKey(), m.getValue().getAsString());
                                hashMap.put("data", hashMap2);
                                break;
                            }
                            if (m.getValue().toString().contains("[]")) {
                                hashMap2.put(m.getKey(), new JsonArray());
                                hashMap.put("data", hashMap2);
                                continue;
                            }
                            asJsonArray = parser.parse(m.getValue().toString()).getAsJsonArray();
                            arrayList = new ArrayList<HashMap<K, V>>();
                            for (JsonElement j : asJsonArray) {
                                entrySet2 = j.getAsJsonObject().entrySet();
                                hashMap3 = new HashMap<String, String>();
                                for (Map.Entry<String, JsonElement> m2 : entrySet2) {
                                    hashMap3.put(m2.getKey(), m2.getValue().getAsString());
                                }
                                arrayList.add(hashMap3);
                            }
                            hashMap2.put("SubAccount", arrayList);
                            break block15;
                        }
                        catch (Exception e) {
                            asJsonObject2 = parser.parse(m.getValue().toString()).getAsJsonObject();
                            entrySet2 = asJsonObject2.entrySet();
                            hashMap3 = new HashMap<String, String>();
                            ** for (m2 : entrySet2)
                        }
lbl-1000:
                        // 1 sources

                        {
                            hashMap3.put(m2.getKey(), m2.getValue().getAsString());
                            continue;
                        }
lbl52:
                        // 1 sources

                        hashMap2.put(m.getKey(), hashMap3);
                        hashMap.put("data", hashMap2);
                    }
                }
                hashMap.put("data", hashMap2);
                continue;
            }
            asJsonObject2 = parser.parse(m.getValue().toString()).getAsJsonObject();
            entrySet2 = asJsonObject2.entrySet();
            hashMap3 = new HashMap<String, String>();
            for (Map.Entry<String, JsonElement> m2 : entrySet2) {
                hashMap3.put(m2.getKey(), m2.getValue().getAsString());
            }
            if (hashMap3.size() != 0) {
                hashMap2.put(m.getKey(), hashMap3);
            } else {
                hashMap2.put(m.getKey(), m.getValue().getAsString());
            }
            hashMap.put("data", hashMap2);
        }
        return hashMap;
    }

    private HashMap<String, Object> xmlToMap(String xml) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Document doc = null;
        try {
            doc = DocumentHelper.parseText(xml);
            Element rootElt = doc.getRootElement();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            Iterator i = rootElt.elementIterator();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                if ("statusCode".equals(e.getName()) || "statusMsg".equals(e.getName())) {
                    map.put(e.getName(), e.getText());
                    continue;
                }
                if ("SubAccount".equals(e.getName()) || "totalCount".equals(e.getName()) || "token".equals(e.getName()) || "downUrl".equals(e.getName())) {
                    if (!"SubAccount".equals(e.getName())) {
                        hashMap2.put(e.getName(), e.getText());
                    } else {
                        ArrayList arrayList = new ArrayList();
                        HashMap<String, String> hashMap3 = new HashMap<String, String>();
                        Iterator i2 = e.elementIterator();
                        while (i2.hasNext()) {
                            Element e2 = (Element)i2.next();
                            hashMap3.put(e2.getName(), e2.getText());
                            arrayList.add(hashMap3);
                        }
                        hashMap2.put("SubAccount", arrayList);
                    }
                    map.put("data", hashMap2);
                    continue;
                }
                HashMap<String, String> hashMap3 = new HashMap<String, String>();
                Iterator i2 = e.elementIterator();
                while (i2.hasNext()) {
                    Element e2 = (Element)i2.next();
                    hashMap3.put(e2.getName(), e2.getText());
                }
                if (hashMap3.size() != 0) {
                    hashMap2.put(e.getName(), hashMap3);
                } else {
                    hashMap2.put(e.getName(), e.getText());
                }
                map.put("data", hashMap2);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
            LoggerUtil.error(e.getMessage());
        }
        catch (Exception e) {
            LoggerUtil.error(e.getMessage());
            e.printStackTrace();
        }
        return map;
    }

    private HttpRequestBase getHttpRequestBase(int get, String action) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return this.getHttpRequestBase(get, action, AccountType.Accounts);
    }

    private HttpRequestBase getHttpRequestBase(int get, String action, AccountType mAccountType) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String timestamp = DateUtil.dateToStr(new Date(), 5);
        EncryptUtil eu = new EncryptUtil();
        String sig = "";
        String acountName = "";
        String acountType = "";
        if (mAccountType == AccountType.Accounts) {
            acountName = this.ACCOUNT_SID;
            sig = String.valueOf(this.ACCOUNT_SID) + this.ACCOUNT_TOKEN + timestamp;
            acountType = "Accounts";
        } else {
            acountName = this.SUBACCOUNT_SID;
            sig = String.valueOf(this.SUBACCOUNT_SID) + this.SUBACCOUNT_Token + timestamp;
            acountType = Create_SubAccount;
        }
        String signature = eu.md5Digest(sig);
        String url = this.getBaseUrl().append("/" + acountType + "/").append(acountName).append("/" + action + "?sig=").append(signature).toString();
        LoggerUtil.info(String.valueOf(this.getmethodName(action)) + " url = " + url);
        HttpRequestBase mHttpRequestBase = null;
        if (get == 0) {
            mHttpRequestBase = new HttpGet(url);
        } else if (get == 1) {
            mHttpRequestBase = new HttpPost(url);
        }
        if (IvrDial.equals(action)) {
            this.setHttpHeaderXML(mHttpRequestBase);
        } else {
            this.setHttpHeader(mHttpRequestBase);
        }
        String src = String.valueOf(acountName) + ":" + timestamp;
        String auth = eu.base64Encoder(src);
        mHttpRequestBase.setHeader("Authorization", auth);
        return mHttpRequestBase;
    }

    private String getmethodName(String action) {
        if (action.equals(Account_Info)) {
            return "queryAccountInfo";
        }
        if (action.equals(Create_SubAccount)) {
            return "createSubAccount";
        }
        if (action.equals(Get_SubAccounts)) {
            return "getSubAccounts";
        }
        if (action.equals(Query_SubAccountByName)) {
            return "querySubAccount";
        }
        if (action.equals(SMSMessages)) {
            return "sendSMS";
        }
        if (action.equals(TemplateSMS)) {
            return "sendTemplateSMS";
        }
        if (action.equals(Call_back)) {
            return "callback";
        }
        if (action.equals(LandingCalls)) {
            return "landingCalls";
        }
        if (action.equals(VoiceVerify)) {
            return "voiceVerify";
        }
        if (action.equals(IvrDial)) {
            return "ivrDial";
        }
        if (action.equals(BillRecords)) {
            return "billRecords";
        }
        return "";
    }

    private void setHttpHeaderXML(AbstractHttpMessage httpMessage) {
        httpMessage.setHeader("Accept", "application/xml");
        httpMessage.setHeader("Content-Type", "application/xml;charset=utf-8");
    }

    private void setHttpHeader(AbstractHttpMessage httpMessage) {
        if (this.BODY_TYPE == BodyType.Type_JSON) {
            httpMessage.setHeader("Accept", "application/json");
            httpMessage.setHeader("Content-Type", "application/json;charset=utf-8");
        } else {
            httpMessage.setHeader("Accept", "application/xml");
            httpMessage.setHeader("Content-Type", "application/xml;charset=utf-8");
        }
    }

    private StringBuffer getBaseUrl() {
        StringBuffer sb = new StringBuffer("https://");
        sb.append(this.SERVER_IP).append(":").append(this.SERVER_PORT);
        sb.append("/2013-12-26");
        return sb;
    }

    private boolean isEmpty(String str) {
        return "".equals(str) || str == null;
    }

    private HashMap<String, Object> getMyError(String code, String msg) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("statusCode", code);
        hashMap.put("statusMsg", msg);
        return hashMap;
    }

    private HashMap<String, Object> subAccountValidate() {
        if (this.isEmpty(this.SERVER_IP)) {
            return this.getMyError("172004", "IP\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.SERVER_PORT)) {
            return this.getMyError("172005", "\u7aef\u53e3\u9519\u8bef");
        }
        if (this.isEmpty(this.SUBACCOUNT_SID)) {
            return this.getMyError("172008", "\u5b50\u5e10\u53f7\u7a7a");
        }
        if (this.isEmpty(this.SUBACCOUNT_Token)) {
            return this.getMyError("172009", "\u5b50\u5e10\u53f7\u4ee4\u724c\u7a7a");
        }
        return null;
    }

    private HashMap<String, Object> accountValidate() {
        if (this.isEmpty(this.SERVER_IP)) {
            return this.getMyError("172004", "IP\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.SERVER_PORT)) {
            return this.getMyError("172005", "\u7aef\u53e3\u9519\u8bef");
        }
        if (this.isEmpty(this.ACCOUNT_SID)) {
            return this.getMyError("172006", "\u4e3b\u5e10\u53f7\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.ACCOUNT_TOKEN)) {
            return this.getMyError("172007", "\u4e3b\u5e10\u53f7\u4ee4\u724c\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.App_ID)) {
            return this.getMyError("172012", "\u5e94\u7528ID\u4e3a\u7a7a");
        }
        return null;
    }

    private void setBodyType(BodyType bodyType) {
        this.BODY_TYPE = bodyType;
    }

    public static enum AccountType {
        Accounts,
        SubAccounts;

    }

    public static enum BodyType {
        Type_XML,
        Type_JSON;

    }
}

