/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import ytx.org.apache.http.HttpClientConnection;
import ytx.org.apache.http.HttpHost;
import ytx.org.apache.http.annotation.ThreadSafe;
import ytx.org.apache.http.impl.pool.BasicConnFactory;
import ytx.org.apache.http.impl.pool.BasicPoolEntry;
import ytx.org.apache.http.params.HttpParams;
import ytx.org.apache.http.pool.AbstractConnPool;
import ytx.org.apache.http.pool.ConnFactory;

@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }
}

