/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.client.methods;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import ytx.org.apache.http.Header;
import ytx.org.apache.http.HeaderElement;
import ytx.org.apache.http.HeaderIterator;
import ytx.org.apache.http.HttpResponse;
import ytx.org.apache.http.annotation.NotThreadSafe;
import ytx.org.apache.http.client.methods.HttpRequestBase;

@NotThreadSafe
public class HttpOptions
extends HttpRequestBase {
    public static final String METHOD_NAME = "OPTIONS";

    public HttpOptions() {
    }

    public HttpOptions(URI uri) {
        this.setURI(uri);
    }

    public HttpOptions(String uri) {
        this.setURI(URI.create(uri));
    }

    @Override
    public String getMethod() {
        return METHOD_NAME;
    }

    public Set<String> getAllowedMethods(HttpResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        HeaderIterator it = response.headerIterator("Allow");
        HashSet<String> methods = new HashSet<String>();
        while (it.hasNext()) {
            HeaderElement[] elements;
            Header header = it.nextHeader();
            HeaderElement[] headerElementArray = elements = header.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                HeaderElement element = headerElementArray[n2];
                methods.add(element.getName());
                ++n2;
            }
        }
        return methods;
    }
}

