/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.types;

import com.clickhouse.jdbc.internal.ExceptionUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Array
implements java.sql.Array {
    private static final Logger log = LoggerFactory.getLogger(Array.class);
    Object[] array;
    int type;
    String typeName;

    public Array(List<Object> list, String itemTypeName, int itemType) throws SQLException {
        if (list == null) {
            throw ExceptionUtils.toSqlState(new IllegalArgumentException("List cannot be null"));
        }
        this.array = list.toArray();
        this.type = itemType;
        this.typeName = itemTypeName;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.typeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.type;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.array;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray(Map<String, Class<?>>) is not supported", "0A000");
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        try {
            Object[] smallerArray = new Object[count];
            System.arraycopy(this.array, (int)index, smallerArray, 0, count);
            return smallerArray;
        }
        catch (Exception e) {
            log.error("Failed to get array", (Throwable)e);
            throw new SQLException(e.getMessage(), "HY000", e);
        }
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray(long, int, Map<String, Class<?>>) is not supported", "0A000");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet() is not supported", "0A000");
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet(Map<String, Class<?>>) is not supported", "0A000");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet(long, int) is not supported", "0A000");
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet(long, int, Map<String, Class<?>>) is not supported", "0A000");
    }

    @Override
    public void free() throws SQLException {
        this.array = null;
    }
}

