/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.query.POJOSetter;
import com.clickhouse.data.ClickHouseAggregateFunction;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.format.BinaryStreamUtils;
import com.clickhouse.data.value.ClickHouseBitmap;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SerializerUtils.class);

    public static void serializeData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        switch (column.getDataType()) {
            case Array: {
                SerializerUtils.serializeArrayData(stream, value, column);
                break;
            }
            case Tuple: {
                SerializerUtils.serializeTupleData(stream, value, column);
                break;
            }
            case Map: {
                SerializerUtils.serializeMapData(stream, value, column);
                break;
            }
            case AggregateFunction: {
                SerializerUtils.serializeAggregateFunction(stream, value, column);
                break;
            }
            default: {
                SerializerUtils.serializePrimitiveData(stream, value, column);
            }
        }
    }

    private static void serializeArrayData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        List values = (List)value;
        SerializerUtils.writeVarInt(stream, values.size());
        for (Object val : values) {
            if (column.getArrayBaseColumn().isNullable()) {
                if (val == null) {
                    SerializerUtils.writeNull(stream);
                    continue;
                }
                SerializerUtils.writeNonNull(stream);
            }
            SerializerUtils.serializeData(stream, val, column.getArrayBaseColumn());
        }
    }

    private static void serializeTupleData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        if (value instanceof List) {
            List values = (List)value;
            for (int i = 0; i < values.size(); ++i) {
                SerializerUtils.serializeData(stream, values.get(i), (ClickHouseColumn)column.getNestedColumns().get(i));
            }
        } else if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                SerializerUtils.serializeData(stream, values[i], (ClickHouseColumn)column.getNestedColumns().get(i));
            }
        } else {
            throw new IllegalArgumentException("Cannot serialize " + value + " as a tuple");
        }
    }

    private static void serializeMapData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        Map map = (Map)value;
        SerializerUtils.writeVarInt(stream, map.size());
        map.forEach((key, val) -> {
            try {
                SerializerUtils.serializePrimitiveData(stream, key, Objects.requireNonNull(column.getKeyInfo()));
                SerializerUtils.serializeData(stream, val, Objects.requireNonNull(column.getValueInfo()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void serializePrimitiveData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        switch (column.getDataType()) {
            case Int8: {
                BinaryStreamUtils.writeInt8((OutputStream)stream, (int)SerializerUtils.convertToInteger(value));
                break;
            }
            case Int16: {
                BinaryStreamUtils.writeInt16((OutputStream)stream, (int)SerializerUtils.convertToInteger(value));
                break;
            }
            case Int32: {
                BinaryStreamUtils.writeInt32((OutputStream)stream, (int)SerializerUtils.convertToInteger(value));
                break;
            }
            case Int64: {
                BinaryStreamUtils.writeInt64((OutputStream)stream, (long)SerializerUtils.convertToLong(value));
                break;
            }
            case Int128: {
                BinaryStreamUtils.writeInt128((OutputStream)stream, (BigInteger)SerializerUtils.convertToBigInteger(value));
                break;
            }
            case Int256: {
                BinaryStreamUtils.writeInt256((OutputStream)stream, (BigInteger)SerializerUtils.convertToBigInteger(value));
                break;
            }
            case UInt8: {
                BinaryStreamUtils.writeUnsignedInt8((OutputStream)stream, (int)SerializerUtils.convertToInteger(value));
                break;
            }
            case UInt16: {
                BinaryStreamUtils.writeUnsignedInt16((OutputStream)stream, (int)SerializerUtils.convertToInteger(value));
                break;
            }
            case UInt32: {
                BinaryStreamUtils.writeUnsignedInt32((OutputStream)stream, (long)SerializerUtils.convertToLong(value));
                break;
            }
            case UInt64: {
                BinaryStreamUtils.writeUnsignedInt64((OutputStream)stream, (long)SerializerUtils.convertToLong(value));
                break;
            }
            case UInt128: {
                BinaryStreamUtils.writeUnsignedInt128((OutputStream)stream, (BigInteger)SerializerUtils.convertToBigInteger(value));
                break;
            }
            case UInt256: {
                BinaryStreamUtils.writeUnsignedInt256((OutputStream)stream, (BigInteger)SerializerUtils.convertToBigInteger(value));
                break;
            }
            case Float32: {
                BinaryStreamUtils.writeFloat32((OutputStream)stream, (float)((Float)value).floatValue());
                break;
            }
            case Float64: {
                BinaryStreamUtils.writeFloat64((OutputStream)stream, (double)((Double)value));
                break;
            }
            case Decimal: 
            case Decimal32: 
            case Decimal64: 
            case Decimal128: 
            case Decimal256: {
                BinaryStreamUtils.writeDecimal((OutputStream)stream, (BigDecimal)((BigDecimal)value), (int)column.getPrecision(), (int)column.getScale());
                break;
            }
            case Bool: {
                BinaryStreamUtils.writeBoolean((OutputStream)stream, (boolean)((Boolean)value));
                break;
            }
            case String: {
                BinaryStreamUtils.writeString((OutputStream)stream, (String)SerializerUtils.convertToString(value));
                break;
            }
            case FixedString: {
                BinaryStreamUtils.writeFixedString((OutputStream)stream, (String)SerializerUtils.convertToString(value), (int)column.getPrecision());
                break;
            }
            case Date: {
                SerializerUtils.writeDate(stream, value, ZoneId.of("UTC"));
                break;
            }
            case Date32: {
                SerializerUtils.writeDate32(stream, value, ZoneId.of("UTC"));
                break;
            }
            case DateTime: {
                ZoneId zoneId = column.getTimeZone() == null ? ZoneId.of("UTC") : column.getTimeZone().toZoneId();
                SerializerUtils.writeDateTime(stream, value, zoneId);
                break;
            }
            case DateTime64: {
                ZoneId zoneId = column.getTimeZone() == null ? ZoneId.of("UTC") : column.getTimeZone().toZoneId();
                SerializerUtils.writeDateTime64(stream, value, column.getScale(), zoneId);
                break;
            }
            case UUID: {
                BinaryStreamUtils.writeUuid((OutputStream)stream, (UUID)((UUID)value));
                break;
            }
            case Enum8: {
                BinaryStreamUtils.writeEnum8((OutputStream)stream, (byte)((Byte)value));
                break;
            }
            case Enum16: {
                BinaryStreamUtils.writeEnum16((OutputStream)stream, (int)SerializerUtils.convertToInteger(value));
                break;
            }
            case IPv4: {
                BinaryStreamUtils.writeInet4Address((OutputStream)stream, (Inet4Address)((Inet4Address)value));
                break;
            }
            case IPv6: {
                BinaryStreamUtils.writeInet6Address((OutputStream)stream, (Inet6Address)((Inet6Address)value));
                break;
            }
            case JSON: {
                SerializerUtils.serializeJSON(stream, value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + column.getDataType());
            }
        }
    }

    private static void serializeJSON(OutputStream stream, Object value) throws IOException {
        if (!(value instanceof String)) {
            throw new UnsupportedOperationException("Serialization of Java object to JSON is not supported yet.");
        }
        BinaryStreamUtils.writeString((OutputStream)stream, (String)((String)value));
    }

    private static void serializeAggregateFunction(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        if (column.getAggregateFunction() == ClickHouseAggregateFunction.groupBitmap) {
            if (value == null) {
                throw new IllegalArgumentException("Cannot serialize null value for aggregate function: " + column.getAggregateFunction());
            }
            if (!(value instanceof ClickHouseBitmap)) {
                throw new IllegalArgumentException("Cannot serialize value of type " + value.getClass() + " for aggregate function: " + column.getAggregateFunction());
            }
        } else {
            throw new UnsupportedOperationException("Unsupported aggregate function: " + column.getAggregateFunction());
        }
        stream.write(((ClickHouseBitmap)value).toBytes());
    }

    public static Integer convertToInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to Integer");
    }

    public static Long convertToLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to Long");
    }

    public static BigInteger convertToBigInteger(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            return new BigInteger((String)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to BigInteger");
    }

    public static BigDecimal convertToBigDecimal(Object value) {
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return BigDecimal.valueOf(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to BigDecimal");
    }

    public static String convertToString(Object value) {
        return String.valueOf(value);
    }

    public static <T extends Enum<T>> Set<T> parseEnumList(String value, Class<T> enumType) {
        HashSet<T> values = new HashSet<T>();
        StringTokenizer causes = new StringTokenizer(value, ",");
        while (causes.hasMoreTokens()) {
            values.add(Enum.valueOf(enumType, causes.nextToken()));
        }
        return values;
    }

    public static boolean numberToBoolean(Number value) {
        return value.doubleValue() != 0.0;
    }

    public static boolean convertToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.ZERO) != 0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.ZERO) != 0;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to Boolean");
    }

    public static List<?> convertArrayValueToList(Object value) {
        if (value instanceof BinaryStreamReader.ArrayValue) {
            return ((BinaryStreamReader.ArrayValue)value).asList();
        }
        if (value.getClass().isArray()) {
            return Arrays.stream((Object[])value).collect(Collectors.toList());
        }
        if (value instanceof List) {
            return (List)value;
        }
        throw new IllegalArgumentException("Cannot convert " + value + " ('" + value.getClass() + "') to list");
    }

    public static POJOSetter compilePOJOSetter(Method setterMethod, ClickHouseColumn column) {
        Class<?> dtoClass = setterMethod.getDeclaringClass();
        String pojoSetterClassName = (dtoClass.getName() + setterMethod.getName()).replace('.', '/');
        ClassWriter writer = new ClassWriter(1);
        writer.visit(52, 1, pojoSetterClassName, null, "java/lang/Object", new String[]{POJOSetter.class.getName().replace('.', '/')});
        MethodVisitor mv = writer.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = writer.visitMethod(1, "setValue", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class), Type.getType(BinaryStreamReader.class), Type.getType(ClickHouseColumn.class)}), null, new String[]{"java/io/IOException"});
        Class<List> targetType = setterMethod.getParameterTypes()[0];
        Class targetPrimitiveType = ClickHouseDataType.toPrimitiveType(targetType);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(dtoClass));
        mv.visitVarInsn(25, 2);
        if (targetType.isPrimitive() && BinaryStreamReader.isReadToPrimitive(column.getDataType())) {
            SerializerUtils.binaryReaderMethodForType(mv, targetPrimitiveType, column.getDataType());
        } else if (targetType.isPrimitive() && column.getDataType() == ClickHouseDataType.UInt64) {
            mv.visitTypeInsn(192, Type.getInternalName(BigInteger.class));
            mv.visitMethodInsn(182, Type.getInternalName(BigInteger.class), targetType.getSimpleName() + "Value", "()" + Type.getDescriptor(targetType), false);
        } else {
            mv.visitVarInsn(25, 3);
            mv.visitLdcInsn((Object)Type.getType(targetType));
            mv.visitMethodInsn(182, Type.getInternalName(BinaryStreamReader.class), "readValue", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(ClickHouseColumn.class), Type.getType(Class.class)}), false);
            if (targetType.isAssignableFrom(List.class) && column.getDataType() == ClickHouseDataType.Tuple) {
                mv.visitTypeInsn(192, Type.getInternalName(Object[].class));
                mv.visitMethodInsn(184, Type.getInternalName(Arrays.class), "asList", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[]{Type.getType(Object[].class)}), false);
            } else {
                mv.visitTypeInsn(192, Type.getInternalName(targetType));
            }
        }
        mv.visitMethodInsn(182, Type.getInternalName(dtoClass), setterMethod.getName(), Type.getMethodDescriptor((Method)setterMethod), false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        try {
            DynamicClassLoader loader = new DynamicClassLoader(dtoClass.getClassLoader());
            Class<?> clazz = loader.defineClass(pojoSetterClassName.replace('/', '.'), writer.toByteArray());
            return (POJOSetter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ClientException("Failed to compile setter for " + setterMethod.getName(), e);
        }
    }

    private static void binaryReaderMethodForType(MethodVisitor mv, Class<?> targetType, ClickHouseDataType dataType) {
        String readerMethod = null;
        String readerMethodReturnType = null;
        int convertOpcode = -1;
        switch (dataType) {
            case Int8: {
                readerMethod = "readByte";
                readerMethodReturnType = Type.getDescriptor(Byte.TYPE);
                break;
            }
            case UInt8: {
                readerMethod = "readUnsignedByte";
                readerMethodReturnType = Type.getDescriptor(Short.TYPE);
                break;
            }
            case Int16: {
                readerMethod = "readShortLE";
                readerMethodReturnType = Type.getDescriptor(Short.TYPE);
                break;
            }
            case UInt16: {
                readerMethod = "readUnsignedShortLE";
                readerMethodReturnType = Type.getDescriptor(Integer.TYPE);
                convertOpcode = SerializerUtils.intToOpcode(targetType);
                break;
            }
            case Int32: {
                readerMethod = "readIntLE";
                readerMethodReturnType = Type.getDescriptor(Integer.TYPE);
                convertOpcode = SerializerUtils.intToOpcode(targetType);
                break;
            }
            case UInt32: {
                readerMethod = "readUnsignedIntLE";
                readerMethodReturnType = Type.getDescriptor(Long.TYPE);
                convertOpcode = SerializerUtils.longToOpcode(targetType);
                break;
            }
            case Int64: {
                readerMethod = "readLongLE";
                readerMethodReturnType = Type.getDescriptor(Long.TYPE);
                convertOpcode = SerializerUtils.longToOpcode(targetType);
                break;
            }
            case Float32: {
                readerMethod = "readFloatLE";
                readerMethodReturnType = Type.getDescriptor(Float.TYPE);
                convertOpcode = SerializerUtils.floatToOpcode(targetType);
                break;
            }
            case Float64: {
                readerMethod = "readDoubleLE";
                readerMethodReturnType = Type.getDescriptor(Double.TYPE);
                convertOpcode = SerializerUtils.doubleToOpcode(targetType);
                break;
            }
            case Enum8: {
                readerMethod = "readByte";
                readerMethodReturnType = Type.getDescriptor(Byte.TYPE);
                break;
            }
            case Enum16: {
                readerMethod = "readShortLE";
                readerMethodReturnType = Type.getDescriptor(Short.TYPE);
                break;
            }
            default: {
                throw new ClientException("Column type '" + dataType + "' cannot be set to a primitive type '" + targetType + "'");
            }
        }
        mv.visitMethodInsn(182, Type.getInternalName(BinaryStreamReader.class), readerMethod, "()" + readerMethodReturnType, false);
        if (convertOpcode != -1) {
            mv.visitInsn(convertOpcode);
        }
    }

    private static int intToOpcode(Class<?> targetType) {
        if (targetType == Short.TYPE) {
            return 147;
        }
        if (targetType == Long.TYPE) {
            return 133;
        }
        if (targetType == Byte.TYPE) {
            return 145;
        }
        if (targetType == Character.TYPE) {
            return 146;
        }
        if (targetType == Float.TYPE) {
            return 134;
        }
        if (targetType == Double.TYPE) {
            return 135;
        }
        return -1;
    }

    private static int longToOpcode(Class<?> targetType) {
        if (targetType == Integer.TYPE) {
            return 136;
        }
        if (targetType == Float.TYPE) {
            return 137;
        }
        if (targetType == Double.TYPE) {
            return 138;
        }
        return -1;
    }

    private static int floatToOpcode(Class<?> targetType) {
        if (targetType == Integer.TYPE) {
            return 139;
        }
        if (targetType == Long.TYPE) {
            return 140;
        }
        if (targetType == Double.TYPE) {
            return 141;
        }
        return -1;
    }

    private static int doubleToOpcode(Class<?> targetType) {
        if (targetType == Integer.TYPE) {
            return 142;
        }
        if (targetType == Long.TYPE) {
            return 143;
        }
        if (targetType == Float.TYPE) {
            return 144;
        }
        return -1;
    }

    public static void writeVarInt(OutputStream output, long value) throws IOException {
        for (int i = 0; i < 9; ++i) {
            byte b = (byte)(value & 0x7FL);
            if (value > 127L) {
                b = (byte)(b | 0x80);
            }
            output.write(b);
            if ((value >>= 7) != 0L) continue;
            return;
        }
    }

    public static void writeNull(OutputStream output) throws IOException {
        SerializerUtils.writeBoolean(output, true);
    }

    public static void writeNonNull(OutputStream output) throws IOException {
        SerializerUtils.writeBoolean(output, false);
    }

    public static void writeBoolean(OutputStream output, boolean value) throws IOException {
        output.write(value ? 1 : 0);
    }

    public static void writeDate(OutputStream output, Object value, ZoneId targetTz) throws IOException {
        int epochDays = 0;
        if (value instanceof LocalDate) {
            LocalDate d = (LocalDate)value;
            epochDays = (int)d.atStartOfDay(targetTz).toLocalDate().toEpochDay();
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime dt = (ZonedDateTime)value;
            epochDays = (int)dt.withZoneSameInstant(targetTz).toLocalDate().toEpochDay();
        } else {
            throw new IllegalArgumentException("Cannot convert " + value + " to Long");
        }
        BinaryStreamUtils.writeUnsignedInt16((OutputStream)output, (int)epochDays);
    }

    public static void writeDate32(OutputStream output, Object value, ZoneId targetTz) throws IOException {
        int epochDays = 0;
        if (value instanceof LocalDate) {
            LocalDate d = (LocalDate)value;
            epochDays = (int)d.atStartOfDay(targetTz).toLocalDate().toEpochDay();
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime dt = (ZonedDateTime)value;
            epochDays = (int)dt.withZoneSameInstant(targetTz).toLocalDate().toEpochDay();
        } else {
            throw new IllegalArgumentException("Cannot convert " + value + " to Long");
        }
        BinaryStreamUtils.writeInt32((OutputStream)output, (int)epochDays);
    }

    public static void writeDateTime32(OutputStream output, Object value, ZoneId targetTz) throws IOException {
        SerializerUtils.writeDateTime(output, value, targetTz);
    }

    public static void writeDateTime(OutputStream output, Object value, ZoneId targetTz) throws IOException {
        long ts = 0L;
        if (value instanceof LocalDateTime) {
            LocalDateTime dt = (LocalDateTime)value;
            ts = dt.atZone(targetTz).toEpochSecond();
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime dt = (ZonedDateTime)value;
            ts = dt.withZoneSameInstant(targetTz).toEpochSecond();
        } else if (value instanceof Timestamp) {
            Timestamp t = (Timestamp)value;
            ts = t.toLocalDateTime().atZone(targetTz).toEpochSecond();
        } else {
            throw new IllegalArgumentException("Cannot convert " + value + " to DataTime");
        }
        BinaryStreamUtils.writeUnsignedInt32((OutputStream)output, (long)ts);
    }

    public static void writeDateTime64(OutputStream output, Object value, int scale, ZoneId targetTz) throws IOException {
        if (scale < 0 || scale > 9) {
            throw new IllegalArgumentException("Invalid scale value '" + scale + "'");
        }
        long ts = 0L;
        long nano = 0L;
        if (value instanceof LocalDateTime) {
            ZonedDateTime dt = ((LocalDateTime)value).atZone(targetTz);
            ts = dt.toEpochSecond();
            nano = dt.getNano();
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime dt = ((ZonedDateTime)value).withZoneSameInstant(targetTz);
            ts = dt.toEpochSecond();
            nano = dt.getNano();
        } else if (value instanceof Timestamp) {
            ZonedDateTime dt = ((Timestamp)value).toLocalDateTime().atZone(targetTz);
            ts = dt.toEpochSecond();
            nano = dt.getNano();
        } else {
            throw new IllegalArgumentException("Cannot convert " + value + " to DataTime");
        }
        ts *= (long)BinaryStreamReader.BASES[scale];
        if (nano > 0L) {
            ts += nano / (long)BinaryStreamReader.BASES[9 - scale];
        }
        BinaryStreamUtils.writeInt64((OutputStream)output, (long)ts);
    }

    public static class DynamicClassLoader
    extends ClassLoader {
        public DynamicClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public Class<?> defineClass(String name, byte[] code) throws ClassNotFoundException {
            return super.defineClass(name, code, 0, code.length);
        }
    }
}

