/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseNodes;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Deprecated
public abstract class ClickHouseLoadBalancingPolicy
implements Serializable {
    private static final long serialVersionUID = 1481796695764210324L;
    private static final Map<String, ClickHouseLoadBalancingPolicy> policies = new ConcurrentHashMap<String, ClickHouseLoadBalancingPolicy>();
    static final ClickHouseLoadBalancingPolicy DEFAULT = new DefaultPolicy();
    static final String ERROR_NO_SUITABLE_NODE = "%s does not contain suitable node for %s";
    public static final String QUERY_GET_ALL_NODES = "select cluster, host_address, host_name, replica_num, shard_num, shard_weight from system.clusters where is_local=1";
    public static final String QUERY_GET_CLUSTER_NODES = "select cluster, host_address, host_name, replica_num, shard_num, shard_weight from system.clusters where is_local=1 and cluster=:cluster";
    public static final String QUERY_GET_OTHER_NODES = "select distinct cluster, :host, replica_num, shard_num, shard_weight from system.clusters where is_local=0 and cluster in :cluster order by estimated_recovery_time asc, shard_weight desc, shard_num asc, (errors_count + slowdowns_count) desc";
    public static final String FIRST_ALIVE = "firstAlive";
    public static final String RANDOM = "random";
    public static final String ROUND_ROBIN = "roundRobin";

    static ClickHouseLoadBalancingPolicy create(String name) {
        ClickHouseLoadBalancingPolicy policy;
        if (FIRST_ALIVE.equalsIgnoreCase(name)) {
            policy = new FirstAlivePolicy();
        } else if (RANDOM.equalsIgnoreCase(name)) {
            policy = new RandomPolicy();
        } else if (ROUND_ROBIN.equalsIgnoreCase(name)) {
            policy = new RoundRobinPolicy();
        } else {
            try {
                Class<?> clazz = ClickHouseLoadBalancingPolicy.class.getClassLoader().loadClass(name);
                if (!ClickHouseLoadBalancingPolicy.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException(ClickHouseUtils.format("Unsupported policy: class [%s] must extend [%s]", name, ClickHouseLoadBalancingPolicy.class.getName()));
                }
                policy = (ClickHouseLoadBalancingPolicy)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unknown policy: " + name, e);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to instantiate policy: " + name, e);
            }
        }
        return policy;
    }

    public static ClickHouseLoadBalancingPolicy of(String name) {
        return ClickHouseChecker.isNullOrEmpty(name) ? DEFAULT : policies.computeIfAbsent(name.toLowerCase(Locale.ROOT), k -> ClickHouseLoadBalancingPolicy.create(name));
    }

    protected String getQueryForAllLocalNodes() {
        return QUERY_GET_ALL_NODES;
    }

    protected String getQueryForClusterLocalNodes() {
        return QUERY_GET_CLUSTER_NODES;
    }

    protected String getQueryForNonLocalNodes() {
        return QUERY_GET_OTHER_NODES;
    }

    protected final ClickHouseNode get(ClickHouseNodes manager) {
        return this.get(manager, manager.getNodeSelector());
    }

    protected ClickHouseNode get(ClickHouseNodes manager, ClickHouseNodeSelector t) {
        boolean noSelector = t == null || t == ClickHouseNodeSelector.EMPTY;
        int idx = manager.index.get();
        int i = 0;
        ClickHouseNode node = null;
        for (ClickHouseNode n : manager.nodes) {
            if (noSelector || t.match(n)) {
                node = n;
            }
            if (i++ < idx || node == null) continue;
            break;
        }
        if (node == null) {
            for (ClickHouseNode n : manager.faultyNodes) {
                ClickHouseNode probed = n.probe();
                if (noSelector || t.match(probed)) {
                    node = probed;
                }
                if (i++ < idx || node == null) continue;
                break;
            }
        }
        if (node == null) {
            throw new IllegalArgumentException(ClickHouseUtils.format(ERROR_NO_SUITABLE_NODE, manager, t));
        }
        return node;
    }

    protected ClickHouseNode suggest(ClickHouseNodes manager, ClickHouseNode server, Throwable failure) {
        if (manager == null || server == null || !(failure instanceof ClickHouseException)) {
            return server;
        }
        ClickHouseException exp = (ClickHouseException)failure;
        if (exp.getErrorCode() == 210 || ClickHouseException.isConnectTimedOut(exp.getCause())) {
            ClickHouseNodeSelector selector = manager.getNodeSelector();
            for (ClickHouseNode node : manager.nodes) {
                if (!selector.match(node) || node.isSameEndpoint(server)) continue;
                return node;
            }
        }
        return server;
    }

    protected void update(ClickHouseNodes manager, ClickHouseNode node, ClickHouseNode.Status status) {
        switch (status) {
            case MANAGED: {
                node.setManager(manager);
                if (manager.nodes.contains(node) || manager.faultyNodes.contains(node)) break;
                if (node.getProtocol() == ClickHouseProtocol.ANY) {
                    manager.faultyNodes.add(node);
                    break;
                }
                manager.nodes.add(node);
                break;
            }
            case HEALTHY: {
                manager.faultyNodes.remove(node);
                if (manager.nodes.contains(node)) break;
                manager.nodes.add(node);
                break;
            }
            case FAULTY: {
                manager.nodes.remove(node);
                if (manager.faultyNodes.contains(node)) break;
                manager.faultyNodes.add(node);
                manager.scheduleHealthCheck();
                break;
            }
            case STANDALONE: {
                boolean removed = manager.nodes.remove(node);
                boolean bl = removed = manager.faultyNodes.remove(node) || removed;
                if (!removed) break;
                node.setManager(null);
                break;
            }
        }
    }

    protected ScheduledExecutorService getScheduler() {
        return ClickHouseDataStreamFactory.getInstance().getScheduler();
    }

    protected ScheduledFuture<?> schedule(ScheduledFuture<?> current, Runnable task, long interval) {
        ScheduledExecutorService scheduler = this.getScheduler();
        if (scheduler == null || task == null || current != null && !current.isDone() && !current.isCancelled()) {
            return null;
        }
        return interval < 1L ? scheduler.schedule(task, 0L, TimeUnit.MILLISECONDS) : scheduler.scheduleAtFixedRate(task, 0L, interval, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return new StringBuilder(110).append("ClickHouseLoadBalancingPolicy [name=").append(this.getClass().getSimpleName()).append(", scheduler=").append(this.getScheduler() != null).append("]@").append(this.hashCode()).toString();
    }

    static class FirstAlivePolicy
    extends ClickHouseLoadBalancingPolicy {
        FirstAlivePolicy() {
        }

        @Override
        protected ClickHouseNode get(ClickHouseNodes manager, ClickHouseNodeSelector t) {
            boolean noSelector = t == null || t == ClickHouseNodeSelector.EMPTY;
            ClickHouseNode node = null;
            for (ClickHouseNode n : manager.nodes) {
                if (noSelector || t.match(n)) {
                    node = n;
                }
                if (node == null || manager.faultyNodes.contains(node)) continue;
                break;
            }
            if (node == null) {
                throw new IllegalArgumentException(ClickHouseUtils.format(ClickHouseLoadBalancingPolicy.ERROR_NO_SUITABLE_NODE, manager, t));
            }
            return node;
        }

        @Override
        protected void update(ClickHouseNodes manager, ClickHouseNode node, ClickHouseNode.Status status) {
            if (status != ClickHouseNode.Status.HEALTHY && status != ClickHouseNode.Status.FAULTY) {
                super.update(manager, node, status);
                return;
            }
            if (status == ClickHouseNode.Status.HEALTHY) {
                manager.faultyNodes.remove(node);
            } else if (!manager.faultyNodes.contains(node)) {
                manager.faultyNodes.add(node);
                manager.scheduleHealthCheck();
            }
        }
    }

    static class RandomPolicy
    extends ClickHouseLoadBalancingPolicy {
        private final Random rand = new Random(System.currentTimeMillis());

        protected RandomPolicy() {
        }

        @Override
        protected ClickHouseNode get(ClickHouseNodes manager, ClickHouseNodeSelector t) {
            int size = manager.nodes.size();
            manager.index.set(size < 1 ? 0 : this.rand.nextInt(size));
            return super.get(manager, t);
        }
    }

    static class RoundRobinPolicy
    extends ClickHouseLoadBalancingPolicy {
        RoundRobinPolicy() {
        }

        @Override
        protected ClickHouseNode get(ClickHouseNodes manager, ClickHouseNodeSelector t) {
            boolean noSelector = t == null || t == ClickHouseNodeSelector.EMPTY;
            int idx = manager.index.getAndUpdate(v -> v + 1 >= manager.nodes.size() ? 0 : v + 1);
            int i = 0;
            ClickHouseNode node = null;
            for (ClickHouseNode n : manager.nodes) {
                if (noSelector || t.match(n)) {
                    node = n;
                }
                if (i++ < idx || node == null) continue;
                break;
            }
            if (node == null) {
                throw new IllegalArgumentException(ClickHouseUtils.format(ClickHouseLoadBalancingPolicy.ERROR_NO_SUITABLE_NODE, manager, t));
            }
            return node;
        }
    }

    static class DefaultPolicy
    extends ClickHouseLoadBalancingPolicy {
        DefaultPolicy() {
        }

        @Override
        protected ScheduledExecutorService getScheduler() {
            return null;
        }
    }
}

