package com.clickhouse.jdbc;

import java.io.OutputStream;
import java.sql.SQLException;
import java.sql.Statement;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseRequest.Mutation;

public interface ClickHouseStatement extends Statement {
    @Override
    ClickHouseConnection getConnection() throws SQLException;

    ClickHouseConfig getConfig();

    /**
     * Gets mirrored output stream.
     *
     * @return mirrored output stream, could be null
     */
    OutputStream getMirroredOutput();

    /**
     * Sets mirrored output stream, which will be later used for dumping all
     * {@link java.sql.ResultSet} generated by this statement, via
     * {@link com.clickhouse.data.ClickHouseInputStream#setCopyToTarget(OutputStream)}.
     *
     * @param out mirrored output stream, could be null
     */
    void setMirroredOutput(OutputStream out);

    int getNullAsDefault();

    void setNullAsDefault(int level);

    ClickHouseRequest<?> getRequest();

    default Mutation write() {
        return getRequest().write();
    }
}
