/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.compress;

import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseCompressionAlgorithm;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.stream.WrappedInputStream;
import com.clickhouse.data.stream.WrappedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public final class Bz2Support {
    public static ClickHouseCompressionAlgorithm getInstance() {
        return Factory.instance;
    }

    private Bz2Support() {
    }

    static final class Factory {
        private static final ClickHouseCompressionAlgorithm instance = new DefaultImpl();

        private Factory() {
        }
    }

    public static class DefaultImpl
    implements ClickHouseCompressionAlgorithm {
        protected int normalize(int level) {
            return level < 1 || level > 9 ? 9 : level;
        }

        @Override
        public ClickHouseOutputStream compress(ClickHousePassThruStream stream, OutputStream output, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            return new WrappedOutputStream(stream, (OutputStream)new BZip2CompressorOutputStream(output, this.normalize(level)), bufferSize, postCloseAction);
        }

        @Override
        public ClickHouseInputStream decompress(ClickHousePassThruStream stream, InputStream input, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            return new WrappedInputStream(stream, (InputStream)new BZip2CompressorInputStream(input), bufferSize, postCloseAction);
        }

        @Override
        public ClickHouseCompression getAlgorithm() {
            return ClickHouseCompression.BZ2;
        }
    }
}

