/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseSslMode;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseExternalTable;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class HttpUrlConnectionImpl
extends ClickHouseHttpConnection {
    private static final Logger log = LoggerFactory.getLogger(HttpUrlConnectionImpl.class);
    private static final String USER_AGENT = ClickHouseClientOption.buildUserAgent(null, "HttpURLConnection");
    private final HttpURLConnection conn;

    private ClickHouseHttpResponse buildResponse(ClickHouseOutputStream output, Runnable postCloseAction) throws IOException {
        Runnable action;
        InputStream source;
        String displayName = this.getResponseHeader("X-ClickHouse-Server-Display-Name", this.server.getHost());
        String queryId = this.getResponseHeader("X-ClickHouse-Query-Id", "");
        String summary = this.getResponseHeader("X-ClickHouse-Summary", "{}");
        ClickHouseConfig c = this.config;
        ClickHouseFormat format = c.getFormat();
        TimeZone timeZone = c.getServerTimeZone();
        boolean hasCustomOutput = output != null && output.getUnderlyingStream().hasOutput();
        boolean hasQueryResult = false;
        if (!ClickHouseChecker.isNullOrEmpty(queryId)) {
            String value = this.getResponseHeader("X-ClickHouse-Format", "");
            if (!ClickHouseChecker.isNullOrEmpty(value)) {
                format = ClickHouseFormat.valueOf(value);
                hasQueryResult = true;
            }
            TimeZone timeZone2 = timeZone = !ClickHouseChecker.isNullOrEmpty(value = this.getResponseHeader("X-ClickHouse-Timezone", "")) ? TimeZone.getTimeZone(value) : timeZone;
        }
        if (output != null) {
            source = ClickHouseInputStream.empty();
            action = () -> {
                try (ClickHouseOutputStream o = output;){
                    ClickHouseInputStream.pipe(this.conn.getInputStream(), (OutputStream)o, c.getWriteBufferSize());
                    if (postCloseAction != null) {
                        postCloseAction.run();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to redirect response to given output stream", e);
                }
            };
        } else {
            source = this.conn.getInputStream();
            action = postCloseAction;
        }
        return new ClickHouseHttpResponse(this, hasCustomOutput ? ClickHouseInputStream.of(source, c.getReadBufferSize(), action) : (hasQueryResult ? ClickHouseClient.getAsyncResponseInputStream(c, source, action) : ClickHouseClient.getResponseInputStream(c, source, action)), displayName, queryId, summary, format, timeZone);
    }

    private HttpURLConnection newConnection(String url, boolean post) throws IOException {
        ClickHouseConfig c = this.config;
        Proxy proxy = HttpUrlConnectionImpl.getProxy(c);
        HttpURLConnection newConn = proxy != null ? (HttpURLConnection)new URL(url).openConnection(proxy) : (HttpURLConnection)new URL(url).openConnection();
        if (newConn instanceof HttpsURLConnection && c.isSsl()) {
            HttpsURLConnection secureConn = (HttpsURLConnection)newConn;
            SSLContext sslContext = ClickHouseSslContextProvider.getProvider().getSslContext(SSLContext.class, c).orElse(null);
            HostnameVerifier verifier = c.getSslMode() == ClickHouseSslMode.STRICT ? HttpsURLConnection.getDefaultHostnameVerifier() : (hostname, session) -> true;
            secureConn.setHostnameVerifier(verifier);
            if (sslContext != null) {
                secureConn.setSSLSocketFactory(sslContext.getSocketFactory());
            }
        }
        if (post) {
            newConn.setInstanceFollowRedirects(true);
            newConn.setRequestMethod("POST");
        }
        newConn.setUseCaches(false);
        newConn.setAllowUserInteraction(false);
        newConn.setDoInput(true);
        newConn.setDoOutput(true);
        newConn.setConnectTimeout(c.getConnectionTimeout());
        newConn.setReadTimeout(c.getSocketTimeout());
        return newConn;
    }

    private String getResponseHeader(String header, String defaultValue) {
        String value = this.conn.getHeaderField(header);
        return value != null ? value : defaultValue;
    }

    private void setHeaders(HttpURLConnection conn, Map<String, String> headers) {
        if ((headers = this.mergeHeaders(headers)) != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
    }

    private void checkResponse(HttpURLConnection conn) throws IOException {
        if (conn.getResponseCode() != 200) {
            String errorMsg;
            String errorCode = conn.getHeaderField("X-ClickHouse-Exception-Code");
            String serverName = conn.getHeaderField("X-ClickHouse-Server-Display-Name");
            InputStream errorInput = conn.getErrorStream();
            if (errorInput == null) {
                throw new ConnectException(ClickHouseUtils.format("HTTP response %d %s (ClickHouse error %s returned from %s)", conn.getResponseCode(), conn.getResponseMessage(), errorCode, serverName));
            }
            int bufferSize = (Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue();
            ByteArrayOutputStream output = new ByteArrayOutputStream(bufferSize);
            ClickHouseInputStream.pipe(errorInput, (OutputStream)output, bufferSize);
            byte[] bytes = output.toByteArray();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)ClickHouseClient.getResponseInputStream(this.config, new ByteArrayInputStream(bytes), null), StandardCharsets.UTF_8));){
                StringBuilder builder = new StringBuilder();
                while ((errorMsg = reader.readLine()) != null) {
                    builder.append(errorMsg).append('\n');
                }
                errorMsg = builder.toString();
            }
            catch (IOException e) {
                errorMsg = HttpUrlConnectionImpl.parseErrorFromException(errorCode, serverName, e, bytes);
            }
            throw new IOException(errorMsg);
        }
    }

    protected HttpUrlConnectionImpl(ClickHouseNode server, ClickHouseRequest<?> request, ExecutorService executor) throws IOException {
        super(server, request);
        this.conn = this.newConnection(this.url, true);
    }

    @Override
    protected final String getDefaultUserAgent() {
        return USER_AGENT;
    }

    @Override
    protected boolean isReusable() {
        return false;
    }

    @Override
    protected ClickHouseHttpResponse post(ClickHouseConfig config, String sql, ClickHouseInputStream data, List<ClickHouseExternalTable> tables, ClickHouseOutputStream output, String url, Map<String, String> headers, Runnable postCloseAction) throws IOException {
        byte[] boundary = null;
        if (tables != null && !tables.isEmpty()) {
            String uuid = this.rm.createUniqueId();
            this.conn.setRequestProperty("content-type", "multipart/form-data; boundary=".concat(uuid));
            boundary = uuid.getBytes(StandardCharsets.US_ASCII);
        } else {
            this.conn.setRequestProperty("content-type", "text/plain; charset=UTF-8");
        }
        this.setHeaders(this.conn, headers);
        if (data != null || boundary != null) {
            this.conn.setChunkedStreamingMode(config.getRequestChunkSize());
        }
        HttpUrlConnectionImpl.postData(config, boundary, sql, data, tables, this.conn.getOutputStream());
        this.checkResponse(this.conn);
        return this.buildResponse(output, postCloseAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ping(int timeout) {
        block11: {
            String response = this.config.getStrOption(ClickHouseHttpOption.DEFAULT_RESPONSE);
            String url = null;
            HttpURLConnection c = null;
            try {
                boolean bl;
                url = this.getBaseUrl().concat("ping");
                c = this.newConnection(url, false);
                c.setConnectTimeout(timeout);
                c.setReadTimeout(timeout);
                this.checkResponse(c);
                int size = 12;
                ByteArrayOutputStream out = new ByteArrayOutputStream(size);
                try {
                    ClickHouseInputStream.pipe(c.getInputStream(), (OutputStream)out, size);
                    c.disconnect();
                    c = null;
                    bl = response.equals(new String(out.toByteArray(), StandardCharsets.UTF_8));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.debug((Object)"Failed to ping url %s due to: %s", url, e.getMessage());
                        break block11;
                    }
                }
                out.close();
                return bl;
            }
            finally {
                if (c != null) {
                    c.disconnect();
                }
            }
        }
        return false;
    }

    @Override
    public void close() {
        this.conn.disconnect();
    }
}

