/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDataStreamFactory;
import com.clickhouse.client.ClickHouseDeserializer;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.ClickHouseSerializer;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseConfigChangeListener;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.data.ClickHouseExternalTable;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseResultSet;
import com.clickhouse.jdbc.ClickHouseStatement;
import com.clickhouse.jdbc.JdbcWrapper;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import com.clickhouse.jdbc.parser.StatementType;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ClickHouseStatementImpl
extends JdbcWrapper
implements ClickHouseConfigChangeListener<ClickHouseRequest<?>>,
ClickHouseStatement {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseStatementImpl.class);
    private final ClickHouseConnection connection;
    private final ClickHouseRequest<?> request;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final List<ClickHouseSqlStatement> batchStmts;
    private boolean closed;
    private boolean closeOnCompletion;
    private String cursorName;
    private boolean escapeScan;
    private int fetchSize;
    private int maxFieldSize;
    private long maxRows;
    private boolean poolable;
    private volatile String queryId;
    private int queryTimeout;
    private ClickHouseResultSet currentResult;
    private long currentUpdateCount;
    protected ClickHouseSqlStatement[] parsedStmts;
    protected ClickHouseDeserializer<ClickHouseValue> deserializer;
    protected ClickHouseSerializer<ClickHouseValue> serializer;

    private ClickHouseResponse getLastResponse(Map<ClickHouseOption, Serializable> options, List<ClickHouseExternalTable> tables, Map<String, String> settings) throws SQLException {
        if (this.parsedStmts.length > 1) {
            this.request.session(UUID.randomUUID().toString());
        }
        ClickHouseResponse response = null;
        int len = this.parsedStmts.length;
        for (int i = 0; i < len; ++i) {
            ClickHouseSqlStatement stmt = this.parsedStmts[i];
            try {
                this.queryId = this.connection.newQueryId();
                response = (ClickHouseResponse)this.request.query(stmt.getSQL(), this.queryId).execute().get();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw SqlExceptionUtils.forCancellation(e);
            }
            catch (Exception e) {
                throw SqlExceptionUtils.handle(e);
            }
            finally {
                if (i + 1 < len && response != null) {
                    response.close();
                }
            }
        }
        return response;
    }

    protected void ensureOpen() throws SQLException {
        if (this.closed) {
            throw SqlExceptionUtils.clientError("Cannot operate on a closed statement");
        }
    }

    protected ClickHouseResponse executeStatement(String stmt, Map<ClickHouseOption, Serializable> options, List<ClickHouseExternalTable> tables, Map<String, String> settings) throws SQLException {
        try {
            if (options != null) {
                this.request.options(options);
            }
            if (settings != null && !settings.isEmpty()) {
                if (!this.request.getSessionId().isPresent()) {
                    this.request.session(UUID.randomUUID().toString());
                }
                for (Map.Entry<String, String> e : settings.entrySet()) {
                    this.request.set(e.getKey(), e.getValue());
                }
            }
            if (tables != null && !tables.isEmpty()) {
                ArrayList<ClickHouseExternalTable> list = new ArrayList<ClickHouseExternalTable>(tables.size());
                for (ClickHouseExternalTable t : tables) {
                    if (t.isTempTable()) {
                        if (!this.request.getSessionId().isPresent()) {
                            this.request.session(UUID.randomUUID().toString());
                        }
                        this.request.query("drop temporary table if exists `" + t.getName() + "`").execute().get();
                        this.request.query("create temporary table `" + t.getName() + "`(" + t.getStructure() + ")").execute().get();
                        ((ClickHouseRequest.Mutation)this.request.write().table(t.getName())).data(t.getContent()).sendAndWait();
                        continue;
                    }
                    list.add(t);
                }
                this.request.external(list);
            }
            this.queryId = this.connection.newQueryId();
            return (ClickHouseResponse)this.request.query(stmt, this.queryId).execute().get();
        }
        catch (InterruptedException e) {
            log.error((Object)"can not close stream: %s", new Object[]{e.getMessage()});
            Thread.currentThread().interrupt();
            throw SqlExceptionUtils.forCancellation(e);
        }
        catch (Exception e) {
            throw SqlExceptionUtils.handle(e);
        }
    }

    protected ClickHouseResponse executeStatement(ClickHouseSqlStatement stmt, Map<ClickHouseOption, Serializable> options, List<ClickHouseExternalTable> tables, Map<String, String> settings) throws SQLException {
        return this.executeStatement(stmt.getSQL(), options, tables, settings);
    }

    protected int executeInsert(String sql, InputStream input) throws SQLException {
        ClickHouseResponseSummary summary = null;
        try {
            this.queryId = this.connection.newQueryId();
            try (ClickHouseResponse resp = (ClickHouseResponse)((ClickHouseRequest.Mutation)this.request.write().query(sql, this.queryId)).data(input).execute().get();
                 ResultSet rs = this.updateResult(new ClickHouseSqlStatement(sql, StatementType.INSERT), resp);){
                summary = resp.getSummary();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"can not close stream: %s", new Object[]{e.getMessage()});
            Thread.currentThread().interrupt();
            throw SqlExceptionUtils.forCancellation(e);
        }
        catch (Exception e) {
            throw SqlExceptionUtils.handle(e);
        }
        return summary != null && summary.getWrittenRows() > 0L ? (int)summary.getWrittenRows() : 1;
    }

    protected ClickHouseSqlStatement getLastStatement() {
        ClickHouseSqlStatement stmt = null;
        if (this.parsedStmts != null && this.parsedStmts.length > 0) {
            stmt = this.parsedStmts[this.parsedStmts.length - 1];
        }
        return (ClickHouseSqlStatement)ClickHouseChecker.nonNull(stmt, (String)"ParsedStatement");
    }

    protected void setLastStatement(ClickHouseSqlStatement stmt) {
        if (this.parsedStmts != null && this.parsedStmts.length > 0) {
            this.parsedStmts[this.parsedStmts.length - 1] = (ClickHouseSqlStatement)ClickHouseChecker.nonNull((Object)stmt, (String)"ParsedStatement");
        }
    }

    protected ClickHouseSqlStatement parseSqlStatements(String sql) {
        this.parsedStmts = this.connection.parse(sql, this.getConfig());
        if (this.parsedStmts == null || this.parsedStmts.length == 0) {
            throw new IllegalArgumentException("Failed to parse given SQL: " + sql);
        }
        return this.getLastStatement();
    }

    protected ClickHouseResultSet newEmptyResultSet() throws SQLException {
        return new ClickHouseResultSet("", "", this, ClickHouseResponse.EMPTY);
    }

    protected ResultSet updateResult(ClickHouseSqlStatement stmt, ClickHouseResponse response) throws SQLException {
        ClickHouseResultSet rs = null;
        if (stmt.isQuery() || !response.getColumns().isEmpty()) {
            this.currentUpdateCount = -1L;
            rs = this.currentResult = new ClickHouseResultSet(stmt.getDatabaseOrDefault(this.getConnection().getCurrentDatabase()), stmt.getTable(), this, response);
        } else {
            this.currentUpdateCount = response.getSummary().getWrittenRows();
            if (this.currentUpdateCount <= 0L) {
                this.currentUpdateCount = 1L;
            }
            this.currentResult = null;
            response.close();
        }
        return rs == null ? this.newEmptyResultSet() : rs;
    }

    protected ClickHouseStatementImpl(ClickHouseConnectionImpl connection, ClickHouseRequest<?> request, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (connection == null || request == null) {
            throw SqlExceptionUtils.clientError("Non-null connection and request are required");
        }
        this.connection = connection;
        this.request = request.setChangeListener((ClickHouseConfigChangeListener)this);
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        this.resultSetHoldability = 2;
        this.closed = false;
        this.closeOnCompletion = true;
        this.fetchSize = connection.getJdbcConfig().getFetchSize();
        this.maxFieldSize = 0;
        this.maxRows = 0L;
        this.poolable = false;
        this.queryId = null;
        this.queryTimeout = 0;
        this.currentResult = null;
        this.currentUpdateCount = -1L;
        this.batchStmts = new LinkedList<ClickHouseSqlStatement>();
        ClickHouseConfig c = request.getConfig();
        this.setLargeMaxRows(c.getMaxResultRows());
        this.setQueryTimeout(c.getMaxExecutionTime());
        this.optionChanged(this.request, (ClickHouseOption)ClickHouseClientOption.FORMAT, (Serializable)null, (Serializable)null);
    }

    public void optionChanged(ClickHouseRequest<?> source, ClickHouseOption option, Serializable oldValue, Serializable newValue) {
        if (source != this.request) {
            return;
        }
        if (option == ClickHouseClientOption.FORMAT) {
            this.deserializer = ClickHouseDataStreamFactory.getInstance().getDeserializer(this.request.getFormat());
            this.serializer = ClickHouseDataStreamFactory.getInstance().getSerializer(this.request.getInputFormat());
        }
    }

    public void settingChanged(ClickHouseRequest<?> source, String setting, Serializable oldValue, Serializable newValue) {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.executeQuery(sql);
        return this.currentResult != null;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.ensureOpen();
        if (!this.batchStmts.isEmpty()) {
            throw SqlExceptionUtils.undeterminedExecutionError();
        }
        this.parseSqlStatements(sql);
        ClickHouseResponse response = this.getLastResponse(null, null, null);
        try {
            return this.updateResult(this.getLastStatement(), response);
        }
        catch (Exception e) {
            if (response != null) {
                response.close();
            }
            throw SqlExceptionUtils.handle(e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.ensureOpen();
        if (!this.batchStmts.isEmpty()) {
            throw SqlExceptionUtils.undeterminedExecutionError();
        }
        this.parseSqlStatements(sql);
        ClickHouseResponseSummary summary = null;
        try (ClickHouseResponse response = this.getLastResponse(null, null, null);){
            summary = response.getSummary();
        }
        catch (Exception e) {
            throw SqlExceptionUtils.handle(e);
        }
        return summary != null ? summary.getWrittenRows() : 1L;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return (int)this.executeLargeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        if (this.currentResult != null) {
            this.currentResult.close();
        }
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.ensureOpen();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw SqlExceptionUtils.clientError("Max field size cannot be set to negative number");
        }
        this.ensureOpen();
        this.maxFieldSize = max;
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.ensureOpen();
        return this.maxRows;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return (int)this.getLargeMaxRows();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        if (max < 0L) {
            throw SqlExceptionUtils.clientError("Max rows cannot be set to negative number");
        }
        this.ensureOpen();
        if (this.maxRows != max) {
            if (max == 0L) {
                this.request.removeSetting("max_result_rows");
                this.request.removeSetting("result_overflow_mode");
            } else {
                this.request.set("max_result_rows", (Serializable)Long.valueOf(max));
                this.request.set("result_overflow_mode", "break");
            }
            this.maxRows = max;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureOpen();
        this.escapeScan = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.ensureOpen();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw SqlExceptionUtils.clientError("Query timeout cannot be set to negative seconds");
        }
        this.ensureOpen();
        if (this.queryTimeout != seconds) {
            if (seconds == 0) {
                this.request.removeSetting("max_execution_time");
            } else {
                this.request.set("max_execution_time", (Serializable)Integer.valueOf(seconds));
            }
            this.queryTimeout = seconds;
        }
    }

    @Override
    public void cancel() throws SQLException {
        String qid = this.queryId;
        if (qid == null || this.isClosed()) {
            return;
        }
        ClickHouseClient.send((ClickHouseNode)this.request.getServer(), (String)String.format("KILL QUERY WHERE query_id='%s'", qid), (String[])new String[0]).whenComplete((summary, exception) -> {
            if (exception != null) {
                log.warn((Object)"Failed to kill query [%s] due to: %s", new Object[]{qid, exception.getMessage()});
            } else if (summary != null) {
                log.debug((Object)"Killed query [%s]", new Object[]{qid});
            }
        });
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ensureOpen();
        this.cursorName = name;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.ensureOpen();
        return this.currentResult;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.ensureOpen();
        return this.currentUpdateCount;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return (int)this.getLargeUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.ensureOpen();
        if (this.currentResult != null) {
            this.currentResult.close();
            this.currentResult = null;
        }
        this.currentUpdateCount = -1L;
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureOpen();
        if (direction != 1000) {
            throw SqlExceptionUtils.unsupportedError("only FETCH_FORWARD is supported in setFetchDirection");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw SqlExceptionUtils.clientError("Fetch size cannot be negative number");
        }
        this.ensureOpen();
        if (this.fetchSize != rows) {
            this.fetchSize = rows;
            if (rows == 0) {
                this.request.removeOption((ClickHouseOption)ClickHouseClientOption.READ_BUFFER_SIZE);
            } else {
                this.request.option((ClickHouseOption)ClickHouseClientOption.READ_BUFFER_SIZE, (Serializable)Integer.valueOf(rows * 1024));
            }
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureOpen();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureOpen();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureOpen();
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureOpen();
        for (ClickHouseSqlStatement s : this.connection.parse(sql, this.getConfig())) {
            this.batchStmts.add(s);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        this.batchStmts.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        long[] largeUpdateCounts = this.executeLargeBatch();
        int len = largeUpdateCounts.length;
        int[] results = new int[len];
        for (int i = 0; i < len; ++i) {
            results[i] = (int)largeUpdateCounts[i];
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.ensureOpen();
        if (this.batchStmts.isEmpty()) {
            throw SqlExceptionUtils.emptyBatchError();
        }
        boolean continueOnError = this.getConnection().getJdbcConfig().isContinueBatchOnError();
        long[] results = new long[this.batchStmts.size()];
        try {
            int i = 0;
            for (ClickHouseSqlStatement s : this.batchStmts) {
                try {
                    ClickHouseResponse r = this.executeStatement(s, null, null, null);
                    try {
                        ResultSet rs = this.updateResult(s, r);
                        try {
                            if (this.currentResult != null) {
                                throw SqlExceptionUtils.queryInBatchError(results);
                            }
                            results[i] = this.currentUpdateCount <= 0L ? 0L : this.currentUpdateCount;
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    finally {
                        if (r == null) continue;
                        r.close();
                    }
                }
                catch (Exception e) {
                    results[i] = -3L;
                    if (!continueOnError) {
                        throw SqlExceptionUtils.batchUpdateError(e, results);
                    }
                    log.error((Object)"Faled to execute task %d of %d", new Object[]{i + 1, this.batchStmts.size(), e});
                }
                finally {
                    ++i;
                }
            }
        }
        finally {
            this.clearBatch();
        }
        return results;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.ensureOpen();
        switch (current) {
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                if (this.currentResult == null) break;
                this.currentResult.close();
                break;
            }
            default: {
                throw SqlExceptionUtils.clientError("Unknown statement constants: " + current);
            }
        }
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.ensureOpen();
        return new ClickHouseResultSet(this.request.getConfig().getDatabase(), "unknown", this, ClickHouseResponse.EMPTY);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureOpen();
        return this.resultSetHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureOpen();
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.ensureOpen();
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ensureOpen();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureOpen();
        return this.closeOnCompletion;
    }

    @Override
    public ClickHouseConnection getConnection() throws SQLException {
        this.ensureOpen();
        return this.connection;
    }

    @Override
    public ClickHouseConfig getConfig() {
        return this.request.getConfig();
    }

    @Override
    public ClickHouseRequest<?> getRequest() {
        return this.request;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == ClickHouseRequest.class || super.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface == ClickHouseRequest.class ? iface.cast(this.request) : super.unwrap(iface);
    }
}

