/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;

public interface ClickHouseOption
extends Serializable {
    public static Map<String, String> toKeyValuePairs(String str) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String key = null;
        StringBuilder builder = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i + 1 < len) {
                ch = str.charAt(++i);
                builder.append(ch);
                continue;
            }
            if (Character.isWhitespace(ch)) {
                if (builder.length() <= 0) continue;
                builder.append(ch);
                continue;
            }
            if (ch == '=' && key == null) {
                key = builder.toString().trim();
                builder.setLength(0);
                continue;
            }
            if (ch == ',' && key != null) {
                String value = builder.toString().trim();
                builder.setLength(0);
                if (!key.isEmpty() && !value.isEmpty()) {
                    map.put(key, value);
                }
                key = null;
                continue;
            }
            builder.append(ch);
        }
        if (key != null && builder.length() > 0) {
            String value = builder.toString().trim();
            if (!key.isEmpty() && !value.isEmpty()) {
                map.put(key, value);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T extends Serializable> T fromString(String value, Class<T> clazz) {
        Serializable result;
        if (clazz == null) {
            throw new IllegalArgumentException("Non-null value type is required");
        }
        if (value == null) {
            value = "";
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            Boolean boolValue = value.isEmpty() ? Boolean.FALSE : (value.length() == 1 ? Boolean.valueOf("1".equals(value)) : Boolean.valueOf(value));
            result = boolValue;
        } else if (Byte.TYPE == clazz || Byte.class == clazz) {
            result = value.isEmpty() ? Byte.valueOf((byte)0) : Byte.valueOf(value);
        } else if (Short.TYPE == clazz || Short.class == clazz) {
            result = value.isEmpty() ? Short.valueOf((short)0) : Short.valueOf(value);
        } else if (Integer.TYPE == clazz || Integer.class == clazz) {
            result = value.isEmpty() ? Integer.valueOf(0) : Integer.valueOf(value);
        } else if (Long.TYPE == clazz || Long.class == clazz) {
            result = value.isEmpty() ? Long.valueOf(0L) : Long.valueOf(value);
        } else if (Float.TYPE == clazz || Float.class == clazz) {
            result = value.isEmpty() ? Float.valueOf(0.0f) : Float.valueOf(value);
        } else if (Double.TYPE == clazz || Double.class == clazz) {
            result = value.isEmpty() ? Double.valueOf(0.0) : Double.valueOf(value);
        } else if (Enum.class.isAssignableFrom(clazz)) {
            Enum enumValue = null;
            try {
                enumValue = (Enum)Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException exp) {
                for (Enum e : (Enum[])clazz.getEnumConstants()) {
                    if (!e.name().equalsIgnoreCase(value)) continue;
                    enumValue = e;
                    break;
                }
            }
            if (enumValue == null) {
                throw new IllegalArgumentException("No enum constant " + clazz.getCanonicalName() + "." + value);
            }
            result = enumValue;
        } else {
            result = Map.class.isAssignableFrom(clazz) ? (Serializable)((Object)ClickHouseOption.toKeyValuePairs(value)) : (TimeZone.class.isAssignableFrom(clazz) ? TimeZone.getTimeZone(value) : (Serializable)clazz.cast(value));
        }
        return (T)result;
    }

    public static <T extends Serializable> T fromString(String value, T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Non-null default value is required");
        }
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return (T)ClickHouseOption.fromString(value, defaultValue.getClass());
    }

    public Serializable getDefaultValue();

    default public Optional<String> getDefaultValueFromEnvVar() {
        String value = System.getenv(this.getEnvironmentVariable());
        if (value != null) {
            value = value.trim();
        }
        return Optional.ofNullable(value);
    }

    default public Optional<String> getDefaultValueFromSysProp() {
        String value = System.getProperty(this.getSystemProperty());
        if (value != null) {
            value = value.trim();
        }
        return Optional.ofNullable(value);
    }

    public String getDescription();

    default public Serializable getEffectiveDefaultValue() {
        Optional<String> value = this.getDefaultValueFromEnvVar();
        if (!value.isPresent() || value.get().isEmpty()) {
            value = this.getDefaultValueFromSysProp();
        }
        if (!value.isPresent() || value.get().isEmpty()) {
            return this.getDefaultValue();
        }
        return ClickHouseOption.fromString(value.get(), this.getValueType());
    }

    default public <T> T getEffectiveValue(T value) {
        Object result = value == null ? this.getEffectiveDefaultValue() : value;
        return result;
    }

    public String getKey();

    default public String getPrefix() {
        return "CHC";
    }

    default public String getEnvironmentVariable() {
        String name = this.name().toUpperCase(Locale.ROOT);
        String prefix = this.getPrefix().toUpperCase(Locale.ROOT);
        return new StringBuilder(prefix.length() + name.length() + 1).append(prefix).append('_').append(name).toString();
    }

    default public String getSystemProperty() {
        String name = this.name().toLowerCase(Locale.ROOT);
        String prefix = this.getPrefix().toLowerCase(Locale.ROOT);
        return new StringBuilder(prefix.length() + name.length() + 1).append(prefix).append('_').append(name).toString();
    }

    public Class<? extends Serializable> getValueType();

    public boolean isSensitive();

    public String name();
}

