/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j;

public class Word {
    public static final String TYPE_WORD = "word";
    public static final String TYPE_LETTER = "letter";
    public static final String TYPE_LETTER_OR_DIGIT = "letter_or_digit";
    public static final String TYPE_DIGIT = "digit";
    public static final String TYPE_DIGIT_OR_LETTER = "digit_or_letter";
    public static final String TYPE_LETTER_NUMBER = "letter_number";
    public static final String TYPE_OTHER_NUMBER = "other_number";
    private int degree = -1;
    private int startOffset;
    private char[] sen;
    private int offset;
    private int len;
    private String type = "word";

    public Word(char[] word, int startOffset) {
        this.sen = word;
        this.startOffset = startOffset;
        this.offset = 0;
        this.len = word.length;
    }

    public Word(char[] word, int startOffset, String wordType) {
        this(word, startOffset);
        this.type = wordType;
    }

    public Word(char[] sen, int senStartOffset, int offset, int len) {
        this.sen = sen;
        this.startOffset = senStartOffset;
        this.offset = offset;
        this.len = len;
    }

    public String getString() {
        return new String(this.getSen(), this.getWordOffset(), this.getLength());
    }

    public String toString() {
        return this.getString();
    }

    public int getWordOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.len;
    }

    public char[] getSen() {
        return this.sen;
    }

    public int getStartOffset() {
        return this.startOffset + this.offset;
    }

    public int getEndOffset() {
        return this.getStartOffset() + this.getLength();
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = degree;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

