/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.maven.plugins.junit4;

import com.carrotsearch.ant.tasks.junit4.JUnit4;
import com.carrotsearch.maven.plugins.junit4.MavenListenerAdapter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.antrun.AntrunXmlPlexusConfigurationWriter;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

@Mojo(name="junit4", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST)
public class JUnit4Mojo
extends AbstractMojo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Map<String, String> EMPTY_STRING_STRING_MAP = Collections.emptyMap();
    private static final String DEFAULT_TARGET = "__default__";
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="project.build.directory", readonly=true, required=true)
    private File dir;
    @Parameter(property="project.build.directory")
    private File tempDir;
    @Parameter(defaultValue="1")
    private String parallelism = "1";
    @Parameter
    private String failureProperty;
    @Parameter(property="tests.seed", defaultValue="")
    private String seed;
    @Parameter(defaultValue="true")
    private boolean shuffleOnSlave = true;
    @Parameter(defaultValue="true")
    private boolean printSummary = true;
    @Parameter(defaultValue="true")
    private boolean haltOnFailure = true;
    @Parameter(defaultValue="true")
    private boolean isolateWorkingDirectories = true;
    @Parameter(defaultValue="fail")
    private String onNonEmptyWorkDirectory = JUnit4.DEFAULT_NON_EMPTY_WORKDIR_ACTION.name();
    @Parameter(defaultValue="false")
    private boolean sysouts = false;
    @Parameter(defaultValue="0.25")
    private float dynamicAssignmentRatio = 0.25f;
    @Parameter
    private String maxMemory;
    @Parameter
    private boolean leaveTemporary;
    @Parameter
    private String[] jvmArgs;
    @Parameter(property="argLine")
    private String argLine;
    @Parameter
    private Map<String, String> systemProperties;
    @Parameter
    private Map<String, String> environmentVariables;
    @Parameter(defaultValue="java")
    private String jvm;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testClassesDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> excludes;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports")
    private File surefireReportsDirectory;
    @Parameter(property="junitArtifactName", defaultValue="junit:junit")
    private String junitArtifactName;
    @Parameter(property="jvmOutputAction", defaultValue="pipe,warn")
    private String jvmOutputAction;
    @Parameter(defaultValue="true")
    private boolean uniqueSuiteNames = true;
    @Parameter
    private PlexusConfiguration listeners;
    @Parameter
    private PlexusConfiguration runListeners;
    @Parameter
    private PlexusConfiguration assertions;
    @Parameter
    private PlexusConfiguration balancers;
    @Parameter
    private PlexusConfiguration verbatim;
    @Parameter(defaultValue="0")
    private long heartbeat;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(defaultValue="${project.packaging}", readonly=true)
    private String packaging;
    @Parameter
    private List<String> classpathDependencyExcludes;
    @Parameter(defaultValue="")
    private String classpathDependencyScopeExclude;
    @Parameter
    private List<String> additionalClasspathElements;
    @Parameter
    private String prefix;
    @Parameter
    private Boolean debugStream;
    @Parameter
    private Boolean newEnvironment;
    @Parameter(defaultValue="ignore")
    private String ifNoTests;
    @Parameter
    private String statsPropertyPrefix;
    @Parameter(defaultValue="${plugin.artifactMap}", required=true, readonly=true)
    private Map<String, Artifact> pluginArtifactMap;
    @Parameter(defaultValue="${project.artifactMap}", required=true, readonly=true)
    private Map<String, Artifact> projectArtifactMap;
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ArtifactMetadataSource metadataSource;
    @Component
    private ArtifactResolver resolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.packaging)) {
            this.getLog().debug((CharSequence)("Skipping execution for packaging \"" + this.packaging + "\""));
            return;
        }
        if (!this.dir.isDirectory() || !this.tempDir.isDirectory()) {
            this.getLog().warn((CharSequence)("Location does not exist or is not a directory: " + this.dir.getAbsolutePath()));
            this.skipTests = true;
        }
        if (this.skipTests) {
            return;
        }
        this.validateParameters();
        Project antProject = new Project();
        antProject.init();
        antProject.setBaseDir(this.dir);
        antProject.addBuildListener((BuildListener)new MavenListenerAdapter(this.getLog()));
        Document doc = DocumentFactory.getInstance().createDocument();
        try {
            this.populateJUnitElement(this.createDocumentSkeleton(doc));
            File tempAntFile = this.createTemporaryAntFile(doc);
            ProjectHelper.configureProject((Project)antProject, (File)tempAntFile);
            try {
                antProject.executeTarget(DEFAULT_TARGET);
            }
            finally {
                if (!this.leaveTemporary) {
                    tempAntFile.delete();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("An I/O error occurred: " + e.getMessage(), (Exception)e);
        }
        catch (BuildException e) {
            throw new MojoExecutionException(e.getMessage(), e.getCause());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void validateParameters() throws MojoExecutionException {
        Artifact junitArtifact = this.projectArtifactMap.get(this.junitArtifactName);
        if (junitArtifact == null) {
            throw new MojoExecutionException("Missing JUnit artifact in project dependencies: " + this.junitArtifactName);
        }
        this.checkVersion("JUnit", "[4.10,)", junitArtifact);
        if (this.includes == null || this.includes.isEmpty()) {
            this.includes = Arrays.asList("**/Test*.class", "**/*Test.class");
        }
        if (this.excludes == null || this.excludes.isEmpty()) {
            this.excludes = Arrays.asList("**/*$*.class");
        }
    }

    private void checkVersion(String artifactName, String versionSpec, Artifact artifact) throws MojoExecutionException {
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)versionSpec);
            if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getVersion()))) {
                throw new MojoExecutionException("JUnit4 plugin requires " + artifactName + " in version " + versionSpec + " among project dependencies, you declared: " + artifact.getVersion());
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    private void populateJUnitElement(Element junit4) {
        if (this.dir != null) {
            junit4.addAttribute("dir", this.dir.getAbsolutePath());
        }
        if (this.tempDir != null) {
            junit4.addAttribute("tempDir", this.tempDir.getAbsolutePath());
        }
        if (this.parallelism != null) {
            junit4.addAttribute("parallelism", this.parallelism);
        }
        if (this.failureProperty != null) {
            junit4.addAttribute("failureProperty", this.failureProperty);
        }
        if (this.seed != null) {
            junit4.addAttribute("seed", this.seed);
        }
        if (this.jvm != null) {
            junit4.addAttribute("jvm", this.jvm);
        }
        if (this.maxMemory != null) {
            junit4.addAttribute("maxMemory", this.maxMemory);
        }
        if (this.jvmOutputAction != null) {
            junit4.addAttribute("jvmOutputAction", this.jvmOutputAction);
        }
        if (this.heartbeat != 0L) {
            junit4.addAttribute("heartbeat", Long.toString(this.heartbeat));
        }
        if (this.prefix != null) {
            junit4.addAttribute("prefix", this.prefix);
        }
        if (this.debugStream != null) {
            junit4.addAttribute("debugStream", this.debugStream.toString());
        }
        if (this.newEnvironment != null) {
            junit4.addAttribute("newEnvironment", this.newEnvironment.toString());
        }
        if (this.ifNoTests != null) {
            junit4.addAttribute("ifNoTests", this.ifNoTests);
        }
        if (this.statsPropertyPrefix != null) {
            junit4.addAttribute("statsPropertyPrefix", this.statsPropertyPrefix);
        }
        if (this.onNonEmptyWorkDirectory != null) {
            junit4.addAttribute("onNonEmptyWorkDirectory", this.onNonEmptyWorkDirectory);
        }
        junit4.addAttribute("shuffleOnSlave", Boolean.toString(this.shuffleOnSlave));
        junit4.addAttribute("printSummary", Boolean.toString(this.printSummary));
        junit4.addAttribute("isolateWorkingDirectories", Boolean.toString(this.isolateWorkingDirectories));
        junit4.addAttribute("haltOnFailure", Boolean.toString(this.haltOnFailure));
        junit4.addAttribute("leaveTemporary", Boolean.toString(this.leaveTemporary));
        junit4.addAttribute("dynamicAssignmentRatio", Float.toString(this.dynamicAssignmentRatio));
        junit4.addAttribute("sysouts", Boolean.toString(this.sysouts));
        junit4.addAttribute("uniqueSuiteNames", Boolean.toString(this.uniqueSuiteNames));
        for (String jvmArg : (String[])MoreObjects.firstNonNull((Object)this.jvmArgs, (Object)EMPTY_STRING_ARRAY)) {
            junit4.addElement("jvmarg").addAttribute("value", jvmArg);
        }
        if (this.argLine != null) {
            junit4.addElement("jvmarg").addAttribute("line", this.argLine);
        }
        for (Map.Entry entry : ((Map)MoreObjects.firstNonNull(this.systemProperties, EMPTY_STRING_STRING_MAP)).entrySet()) {
            Element sysproperty = junit4.addElement("sysproperty");
            sysproperty.addAttribute("key", Strings.nullToEmpty((String)((String)entry.getKey())));
            sysproperty.addAttribute("value", Strings.nullToEmpty((String)((String)entry.getValue())));
        }
        for (Map.Entry entry : ((Map)MoreObjects.firstNonNull(this.environmentVariables, EMPTY_STRING_STRING_MAP)).entrySet()) {
            Element sysproperty = junit4.addElement("env");
            sysproperty.addAttribute("key", Strings.nullToEmpty((String)((String)entry.getKey())));
            sysproperty.addAttribute("value", Strings.nullToEmpty((String)((String)entry.getValue())));
        }
        this.setupTestInput(junit4);
        this.setupTestClasspath(junit4);
        if (this.listeners != null) {
            this.appendRawXml(this.listeners, junit4);
        } else {
            Element listenersElement = junit4.addElement("listeners");
            Element element = listenersElement.addElement("report-ant-xml");
            element.addAttribute("dir", this.surefireReportsDirectory.getAbsolutePath());
            element.addAttribute("mavenExtensions", "true");
            Element consoleReport = listenersElement.addElement("report-text");
            consoleReport.addAttribute("showThrowable", "true");
            consoleReport.addAttribute("showStackTraces", "true");
            consoleReport.addAttribute("showOutput", "never");
            consoleReport.addAttribute("showStatusOk", "false");
            consoleReport.addAttribute("showStatusError", "true");
            consoleReport.addAttribute("showStatusFailure", "true");
            consoleReport.addAttribute("showStatusIgnored", "false");
            consoleReport.addAttribute("showSuiteSummary", "true");
        }
        this.appendRawXml(this.runListeners, junit4);
        this.appendRawXml(this.assertions, junit4);
        this.appendRawXml(this.balancers, junit4);
        if (this.verbatim != null) {
            for (PlexusConfiguration c : this.verbatim.getChildren()) {
                this.appendRawXml(c, junit4);
            }
        }
    }

    private void appendRawXml(PlexusConfiguration config, Element elem) {
        try {
            if (config == null) {
                return;
            }
            StringWriter writer = new StringWriter();
            AntrunXmlPlexusConfigurationWriter xmlWriter = new AntrunXmlPlexusConfigurationWriter();
            xmlWriter.write(config, (Writer)writer);
            Element root = new SAXReader().read((Reader)new StringReader(writer.toString())).getRootElement();
            root.detach();
            elem.add(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private File createTemporaryAntFile(Document doc) throws IOException {
        try (Closer closer = Closer.create();){
            File antFile = File.createTempFile("junit4-ant-", ".xml", this.dir);
            OutputStream os = (OutputStream)closer.register((Closeable)new FileOutputStream(antFile));
            XMLWriter xmlWriter = new XMLWriter(os, OutputFormat.createPrettyPrint());
            xmlWriter.write(doc);
            File file = antFile;
            return file;
        }
    }

    private Element createDocumentSkeleton(Document doc) {
        Element project = doc.addElement("project");
        project.addAttribute("name", "junit4-maven-synthetic");
        project.addAttribute("default", DEFAULT_TARGET);
        project.addComment("Define JUnit4 task and data types.");
        Element taskdef = project.addElement("taskdef");
        taskdef.addAttribute("resource", "com/carrotsearch/junit4/antlib.xml");
        this.addArtifactClassPath(taskdef.addElement("classpath"), this.pluginArtifactMap.get("com.carrotsearch.randomizedtesting:junit4-ant"));
        this.addArtifactClassPath(taskdef.addElement("classpath"), this.projectArtifactMap.get("junit:junit"));
        project.addComment("Invoke JUnit4 task.");
        Element target = project.addElement("target");
        target.addAttribute("name", DEFAULT_TARGET);
        Element junit4 = target.addElement("junit4");
        return junit4;
    }

    private void addArtifactClassPath(Element cp, Artifact artifact) {
        ArtifactResolutionResult result = this.resolveArtifact(artifact, new Artifact[0]);
        if (!result.isSuccess()) {
            throw new RuntimeException("Could not resolve: " + artifact.toString());
        }
        for (Artifact a : result.getArtifacts()) {
            cp.addElement("pathelement").addAttribute("location", a.getFile().getAbsolutePath());
        }
    }

    private ArtifactResolutionResult resolveArtifact(Artifact artifact, Artifact ... filtered) {
        ExcludesArtifactFilter filter;
        if (filtered.length > 0) {
            ArrayList<String> exclusions = new ArrayList<String>(filtered.length);
            for (Artifact filteredArtifact : filtered) {
                exclusions.add(filteredArtifact.getGroupId() + ":" + filteredArtifact.getArtifactId());
            }
            filter = new ExcludesArtifactFilter(exclusions);
        } else {
            filter = null;
        }
        Artifact originatingArtifact = this.repositorySystem.createArtifact("dummy", "dummy", "1.0", "jar");
        try {
            return this.resolver.resolveTransitively(Collections.singleton(artifact), originatingArtifact, this.session.getLocalRepository(), this.project.getPluginArtifactRepositories(), this.metadataSource, (ArtifactFilter)filter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setupTestClasspath(Element junit4) {
        junit4.addComment("Runtime classpath.");
        Element cp = junit4.addElement("classpath");
        cp.addComment("Test classes directory.");
        cp.addElement("pathelement").addAttribute("location", this.testClassesDirectory.getAbsolutePath());
        cp.addComment("Test classes directory.");
        cp.addElement("pathelement").addAttribute("location", this.classesDirectory.getAbsolutePath());
        cp.addComment("Project dependencies.");
        Set<Artifact> classpathArtifacts = this.project.getArtifacts();
        if (!Strings.isNullOrEmpty((String)this.classpathDependencyScopeExclude)) {
            classpathArtifacts = this.filterArtifacts(cp, classpathArtifacts, (ArtifactFilter)new ScopeArtifactFilter(this.classpathDependencyScopeExclude));
        }
        if (this.classpathDependencyExcludes != null && !this.classpathDependencyExcludes.isEmpty()) {
            classpathArtifacts = this.filterArtifacts(cp, classpathArtifacts, (ArtifactFilter)new PatternIncludesArtifactFilter(this.classpathDependencyExcludes));
        }
        for (Artifact artifact : classpathArtifacts) {
            File file;
            if (!artifact.getArtifactHandler().isAddedToClasspath() || (file = artifact.getFile()) == null) continue;
            cp.addComment("Dependency artifact: " + artifact.getId());
            cp.addElement("pathelement").addAttribute("location", file.getAbsolutePath());
        }
        cp.addComment("Additional classpath elements.");
        if (this.additionalClasspathElements != null && !this.additionalClasspathElements.isEmpty()) {
            for (String classpathElement : this.additionalClasspathElements) {
                if (Strings.isNullOrEmpty((String)classpathElement)) continue;
                cp.addElement("pathelement").addAttribute("location", classpathElement);
            }
        }
    }

    private Set<Artifact> filterArtifacts(Element cp, Set<Artifact> artifacts, ArtifactFilter filter) {
        LinkedHashSet<Artifact> filteredArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!filter.include(artifact)) {
                filteredArtifacts.add(artifact);
                continue;
            }
            cp.addComment("Filtered out artifact: " + artifact.getId() + ", location: " + artifact.getFile());
        }
        return filteredArtifacts;
    }

    private void setupTestInput(Element junit4) {
        Element patternSet = DocumentFactory.getInstance().createElement("patternset");
        for (String includePattern : this.includes) {
            patternSet.addElement("include").addAttribute("name", includePattern);
        }
        for (String excludePattern : this.excludes) {
            patternSet.addElement("exclude").addAttribute("name", excludePattern);
        }
        if (this.testClassesDirectory != null) {
            junit4.addComment("Test classes search paths and patterns.");
            Element fs = junit4.addElement("fileset");
            fs.addAttribute("dir", this.testClassesDirectory.getAbsolutePath());
            fs.addAttribute("erroronmissingdir", "false");
            fs.add(patternSet.createCopy());
        }
    }
}

