/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting;

public final class SeedUtils {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    public static long parseSeed(String string) {
        long l = 0L;
        for (char c : string.toCharArray()) {
            c = Character.toLowerCase(c);
            l <<= 4;
            if (c >= '0' && c <= '9') {
                l |= (long)(c - 48);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                l |= (long)(c - 97 + 10);
                continue;
            }
            throw new IllegalArgumentException("Expected hexadecimal seed: " + string);
        }
        return l;
    }

    public static String formatSeed(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        do {
            stringBuilder.append(HEX[(int)(l & 0xFL)]);
        } while ((l >>>= 4) != 0L);
        return stringBuilder.reverse().toString();
    }

    public static long[] parseSeedChain(String string) {
        if (!(string = string.replaceAll("[\\[\\]]", "")).matches("[0-9A-Fa-f\\:]+")) {
            throw new IllegalArgumentException("Not a valid seed chain: " + string);
        }
        String[] stringArray = string.split("[\\:]");
        long[] lArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            lArray[i] = SeedUtils.parseSeed(stringArray[i]);
        }
        return lArray;
    }
}

