/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base;

import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.integration.hibernate.base.CustomCollectionPersister;
import com.blazebit.persistence.integration.hibernate.base.Database;
import com.blazebit.persistence.integration.jpa.JpaMetamodelAccessorImpl;
import com.blazebit.persistence.spi.JoinTable;
import com.blazebit.persistence.spi.JpaMetamodelAccessor;
import com.blazebit.persistence.spi.JpaProvider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

public class HibernateJpaProvider
implements JpaProvider {
    protected final PersistenceUnitUtil persistenceUnitUtil;
    protected final DB db;
    protected final MappingMetamodelImplementor mappingMetamodel;

    public HibernateJpaProvider(PersistenceUnitUtil persistenceUnitUtil, String dbms, MappingMetamodelImplementor mappingMetamodel) {
        this.persistenceUnitUtil = persistenceUnitUtil;
        try {
            this.db = "mysql".equals(dbms) || "mysql8".equals(dbms) ? DB.MY_SQL : ("db2".equals(dbms) ? DB.DB2 : ("microsoft".equals(dbms) ? DB.MSSQL : DB.OTHER));
            this.mappingMetamodel = mappingMetamodel;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean supportsEntityJoin() {
        return true;
    }

    public boolean supportsCrossJoin() {
        return true;
    }

    public boolean needsJoinSubqueryRewrite() {
        return false;
    }

    public boolean supportsForeignAssociationInOnClause() {
        return true;
    }

    public boolean needsAssociationToIdRewriteInOnClause() {
        return false;
    }

    public boolean needsBrokenAssociationToIdRewriteInOnClause() {
        return false;
    }

    public boolean supportsCollectionTableCleanupOnDelete() {
        return true;
    }

    public boolean supportsJoinTableCleanupOnDelete() {
        return true;
    }

    public boolean needsCorrelationPredicateWhenCorrelatingWithWhereClause() {
        return false;
    }

    public boolean supportsSingleValuedAssociationNaturalIdExpressions() {
        return true;
    }

    public boolean supportsGroupByEntityAlias() {
        return false;
    }

    public boolean needsElementCollectionIdCutoff() {
        return false;
    }

    public boolean needsUnproxyForFieldAccess() {
        return true;
    }

    public boolean needsCaseWhenElseBranch() {
        return false;
    }

    public boolean supportsLikePatternEscape() {
        return true;
    }

    public boolean supportsJpa21() {
        return true;
    }

    public boolean supportsInsertStatement() {
        return true;
    }

    public boolean needsBracketsForListParameter() {
        return true;
    }

    public String getBooleanExpression(boolean value) {
        return value ? "CASE WHEN 1 = 1 THEN true ELSE false END" : "CASE WHEN 1 = 1 THEN false ELSE true END";
    }

    public String getBooleanConditionalExpression(boolean value) {
        return value ? "1 = 1" : "1 = 0";
    }

    public String getNullExpression() {
        return "NULLFN()";
    }

    public String escapeCharacter(char character) {
        return Character.toString(character);
    }

    public boolean supportsNullPrecedenceExpression() {
        return this.db == DB.OTHER;
    }

    public void renderNullPrecedence(StringBuilder sb, String expression, String resolvedExpression, String order, String nulls) {
        if (nulls != null) {
            if (this.db != DB.OTHER) {
                if (this.db == DB.DB2) {
                    if ("FIRST".equals(nulls) && "DESC".equalsIgnoreCase(order) || "LAST".equals(nulls) && "ASC".equalsIgnoreCase(order)) {
                        sb.append(expression);
                        sb.append(" ").append(order);
                        return;
                    }
                } else if (this.db == DB.MSSQL && ("ASC".equalsIgnoreCase(order) && "FIRST".equals(nulls) || "DESC".equalsIgnoreCase(order) && "LAST".equals(nulls))) {
                    sb.append(expression);
                    sb.append(" ").append(order);
                    return;
                }
                if (this.db != DB.MY_SQL || "ASC".equalsIgnoreCase(order) && "LAST".equals(nulls) || "DESC".equalsIgnoreCase(order) && "FIRST".equals(nulls)) {
                    sb.append("CASE WHEN ").append(resolvedExpression != null ? resolvedExpression : expression).append(" IS NULL THEN ");
                    if ("FIRST".equals(nulls)) {
                        sb.append("0 ELSE 1");
                    } else {
                        sb.append("1 ELSE 0");
                    }
                    sb.append(" END, ");
                }
                sb.append(expression);
                if (order != null) {
                    sb.append(" ").append(order);
                }
            } else {
                sb.append(expression);
                if (order != null) {
                    sb.append(' ').append(order).append(" NULLS ").append(nulls);
                }
            }
        } else {
            sb.append(expression);
            if (order != null) {
                sb.append(' ').append(order);
            }
        }
    }

    public String getOnClause() {
        return "ON";
    }

    public String getCollectionValueFunction() {
        return null;
    }

    public boolean supportsCollectionValueDereference() {
        return false;
    }

    public boolean supportsSubqueryLimitOffset() {
        return true;
    }

    public boolean supportsSetOperations() {
        return true;
    }

    public boolean supportsListagg() {
        return true;
    }

    public Class<?> getDefaultQueryResultType() {
        return Object.class;
    }

    public String getCustomFunctionInvocation(String functionName, int argumentCount) {
        return functionName + "(";
    }

    public boolean supportsRootTreat() {
        return false;
    }

    public boolean supportsTreatJoin() {
        return true;
    }

    public boolean supportsTreatCorrelation() {
        return false;
    }

    public boolean supportsRootTreatJoin() {
        return false;
    }

    public boolean supportsRootTreatTreatJoin() {
        return false;
    }

    public boolean supportsSubtypePropertyResolving() {
        return true;
    }

    public boolean supportsSubtypeRelationResolving() {
        return true;
    }

    public boolean supportsCountStar() {
        return true;
    }

    public boolean supportsCountTuple() {
        return true;
    }

    public boolean supportsCustomFunctions() {
        return true;
    }

    public boolean supportsNonScalarSubquery() {
        return true;
    }

    public boolean supportsSubqueryInFunction() {
        return true;
    }

    public boolean supportsSubqueryAliasShadowing() {
        return true;
    }

    protected final String getTypeName(ManagedType<?> ownerType) {
        Class javaType = ownerType.getJavaType();
        return javaType == null || javaType == Map.class ? ((jakarta.persistence.metamodel.EntityType)ownerType).getName() : javaType.getName();
    }

    protected final AbstractEntityPersister getEntityPersister(ManagedType<?> ownerType) {
        Class javaType = ownerType.getJavaType();
        EntityPersister entityPersister = javaType == null ? this.mappingMetamodel.findEntityDescriptor(((jakarta.persistence.metamodel.EntityType)ownerType).getName()) : this.mappingMetamodel.findEntityDescriptor(javaType.getName());
        if (entityPersister == null) {
            try {
                entityPersister = this.mappingMetamodel.findEntityDescriptor(((ManagedDomainType)ownerType).getTypeName());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't get type name!", e);
            }
        }
        return (AbstractEntityPersister)entityPersister;
    }

    protected final QueryableCollection getCollectionPersister(ManagedType<?> ownerType, String attributeName) {
        QueryableCollection collection;
        AbstractEntityPersister entityPersister = this.getEntityPersister(ownerType);
        do {
            String ownerTypeName = entityPersister.getName();
            StringBuilder sb = new StringBuilder(ownerTypeName.length() + attributeName.length() + 1);
            sb.append(ownerTypeName);
            sb.append('.');
            sb.append(attributeName);
            collection = (QueryableCollection)this.mappingMetamodel.findCollectionDescriptor(sb.toString());
            if (collection != null) continue;
            String superclass = entityPersister.getEntityMetamodel().getSuperclass();
            AbstractEntityPersister abstractEntityPersister = entityPersister = superclass == null ? null : (AbstractEntityPersister)this.mappingMetamodel.findEntityDescriptor(superclass);
        } while (collection == null && entityPersister != null);
        return collection;
    }

    public String[] getDiscriminatorColumnCheck(jakarta.persistence.metamodel.EntityType<?> entityType) {
        AbstractEntityPersister entityPersister = this.getEntityPersister((ManagedType<?>)entityType);
        if (entityPersister.isInherited()) {
            String discriminatorColumnName = entityPersister.getDiscriminatorColumnName();
            String discriminatorSQLValue = entityPersister.getDiscriminatorSQLValue();
            return new String[]{discriminatorColumnName, discriminatorSQLValue};
        }
        return null;
    }

    public boolean isForeignJoinColumn(jakarta.persistence.metamodel.EntityType<?> ownerType, String attributeName) {
        int dotIndex;
        AbstractEntityPersister persister = this.getEntityPersister((ManagedType<?>)ownerType);
        int nextStart = 0;
        AbstractEntityPersister modelPartContainer = persister;
        while ((dotIndex = attributeName.indexOf(46, nextStart)) != -1) {
            if ((modelPartContainer = (ModelPartContainer)modelPartContainer.findSubPart(attributeName.substring(nextStart, dotIndex), null)) instanceof PluralAttributeMapping) {
                return true;
            }
            if (modelPartContainer instanceof EntityAssociationMapping && ((EntityAssociationMapping)modelPartContainer).getSideNature() == ForeignKeyDescriptor.Nature.TARGET) {
                return true;
            }
            nextStart = dotIndex + 1;
        }
        ModelPart modelPart = modelPartContainer.findSubPart(attributeName.substring(nextStart), null);
        return modelPart instanceof PluralAttributeMapping || modelPart instanceof EntityAssociationMapping && ((EntityAssociationMapping)modelPart).getSideNature() == ForeignKeyDescriptor.Nature.TARGET;
    }

    public boolean isColumnShared(jakarta.persistence.metamodel.EntityType<?> ownerType, String attributeName) {
        AbstractEntityPersister persister = this.getEntityPersister((ManagedType<?>)ownerType);
        if (!(persister instanceof SingleTableEntityPersister) && !(persister instanceof UnionSubclassEntityPersister)) {
            return false;
        }
        if (persister instanceof SingleTableEntityPersister) {
            SingleTableEntityPersister singleTableEntityPersister = (SingleTableEntityPersister)persister;
            SingleTableEntityPersister rootPersister = (SingleTableEntityPersister)this.mappingMetamodel.findEntityDescriptor(singleTableEntityPersister.getRootEntityName());
            return this.isColumnShared((AbstractEntityPersister)singleTableEntityPersister, rootPersister.getName(), rootPersister.getEntityMetamodel().getSubclassEntityNames(), attributeName);
        }
        if (persister instanceof UnionSubclassEntityPersister) {
            UnionSubclassEntityPersister unionSubclassEntityPersister = (UnionSubclassEntityPersister)persister;
            UnionSubclassEntityPersister rootPersister = (UnionSubclassEntityPersister)this.mappingMetamodel.findEntityDescriptor(unionSubclassEntityPersister.getRootEntityName());
            return this.isColumnShared((AbstractEntityPersister)unionSubclassEntityPersister, rootPersister.getName(), rootPersister.getEntityMetamodel().getSubclassEntityNames(), attributeName);
        }
        return false;
    }

    public JpaProvider.ConstraintType requiresTreatFilter(jakarta.persistence.metamodel.EntityType<?> ownerType, String attributeName, JoinType joinType) {
        return JpaProvider.ConstraintType.NONE;
    }

    private boolean isColumnShared(AbstractEntityPersister persister, String rootName, Set<String> subclassNames, String attributeName) {
        String[] columnNames = persister.getSubclassPropertyColumnNames(attributeName);
        for (String subclass : subclassNames) {
            AbstractEntityPersister subclassPersister;
            if (subclass.equals(persister.getName()) || subclass.equals(rootName) || !this.isColumnShared(subclassPersister = (AbstractEntityPersister)this.mappingMetamodel.findEntityDescriptor(subclass), columnNames)) continue;
            return true;
        }
        return false;
    }

    private boolean isColumnShared(AbstractEntityPersister subclassPersister, String[] columnNames) {
        ArrayList<String> propertiesToCheck = new ArrayList<String>(Arrays.asList(subclassPersister.getPropertyNames()));
        while (!propertiesToCheck.isEmpty()) {
            String propertyName = (String)propertiesToCheck.remove(propertiesToCheck.size() - 1);
            Type propertyType = this.getPropertyType(subclassPersister, propertyName);
            if (propertyType instanceof ComponentType) {
                ComponentType componentType = (ComponentType)propertyType;
                for (String subPropertyName : componentType.getPropertyNames()) {
                    propertiesToCheck.add(propertyName + "." + subPropertyName);
                }
                continue;
            }
            Object[] subclassColumnNames = subclassPersister.getSubclassPropertyColumnNames(propertyName);
            if (!Arrays.deepEquals(columnNames, subclassColumnNames)) continue;
            return true;
        }
        return false;
    }

    public String getMappedBy(jakarta.persistence.metamodel.EntityType<?> ownerType, String attributeName) {
        QueryableCollection persister = this.getCollectionPersister((ManagedType<?>)ownerType, attributeName);
        if (persister != null) {
            if (persister.isInverse()) {
                return this.getMappedBy((CollectionPersister)persister);
            }
            if (persister instanceof OneToManyPersister) {
                return "";
            }
        } else {
            AbstractEntityPersister entityPersister = this.getEntityPersister((ManagedType<?>)ownerType);
            Type propertyType = this.getPropertyType(entityPersister, attributeName);
            if (propertyType instanceof OneToOneType) {
                return ((OneToOneType)propertyType).getRHSUniqueKeyPropertyName();
            }
        }
        return null;
    }

    public Map<String, String> getWritableMappedByMappings(jakarta.persistence.metamodel.EntityType<?> inverseType, jakarta.persistence.metamodel.EntityType<?> ownerType, String attributeName, String inverseAttribute) {
        String[] sourcePropertyNames;
        String sourcePropertyPrefix;
        AbstractEntityPersister entityPersister = this.getEntityPersister((ManagedType<?>)ownerType);
        int propertyIndex = entityPersister.getEntityMetamodel().getPropertyIndex(attributeName);
        Type propertyType = entityPersister.getPropertyTypes()[propertyIndex];
        if (propertyType instanceof CollectionType) {
            QueryableCollection persister = this.getCollectionPersister((ManagedType<?>)ownerType, attributeName);
            AbstractEntityPersister inversePersister = this.getEntityPersister((ManagedType<?>)inverseType);
            if (!persister.isInverse() && persister.getTableName().equals(inversePersister.getTableName())) {
                Set<String> elementAttributes = HibernateJpaProvider.getColumnMatchingAttributeNames(entityPersister, Arrays.asList(entityPersister.toColumns(attributeName)));
                Set<String> keyAttributes = this.removeIdentifierAccess(ownerType, elementAttributes, inverseType, HibernateJpaProvider.getColumnMatchingAttributeNames(inversePersister, Arrays.asList(persister.getKeyColumnNames())));
                LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
                Iterator<String> elemAttrIter = elementAttributes.iterator();
                Iterator<String> keyAttrIter = keyAttributes.iterator();
                while (elemAttrIter.hasNext()) {
                    mapping.put(elemAttrIter.next(), keyAttrIter.next());
                }
                if (mapping.isEmpty()) {
                    throw new IllegalArgumentException("Mapped by property '" + inverseType.getName() + "#" + attributeName + "' must be writable or the column must be part of the id!");
                }
                return mapping;
            }
            if (entityPersister.getEntityMetamodel().getPropertyInsertability()[propertyIndex]) {
                return null;
            }
            throw new IllegalArgumentException("Mapped by property '" + inverseType.getName() + "#" + attributeName + "' must be writable!");
        }
        if (entityPersister.getEntityMetamodel().getPropertyInsertability()[propertyIndex]) {
            return null;
        }
        EntityType ownerPropertyType = (EntityType)propertyType;
        AbstractEntityPersister sourceType = (AbstractEntityPersister)this.mappingMetamodel.findEntityDescriptor(ownerPropertyType.getAssociatedEntityName());
        Type identifierType = ownerPropertyType.getIdentifierOrUniqueKeyType((Mapping)entityPersister.getFactory());
        if (identifierType.isComponentType()) {
            ComponentType componentType = (ComponentType)identifierType;
            sourcePropertyPrefix = sourceType.getIdentifierPropertyName() == null ? "" : sourceType.getIdentifierPropertyName() + ".";
            sourcePropertyNames = componentType.getPropertyNames();
        } else {
            sourcePropertyPrefix = "";
            sourcePropertyNames = new String[]{sourceType.getIdentifierPropertyName()};
        }
        String[] targetColumnNames = entityPersister.getPropertyColumnNames(propertyIndex);
        Type targetIdType = entityPersister.getIdentifierType();
        if (targetIdType.isComponentType()) {
            ComponentType targetIdentifierType = (ComponentType)entityPersister.getIdentifierType();
            String targetPropertyPrefix = entityPersister.getIdentifierPropertyName() == null ? "" : entityPersister.getIdentifierPropertyName() + ".";
            String[] identifierColumnNames = entityPersister.getIdentifierColumnNames();
            String[] targetIdentifierTypePropertyNames = targetIdentifierType.getPropertyNames();
            LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
            block1: for (int i = 0; i < targetColumnNames.length; ++i) {
                for (int j = 0; j < identifierColumnNames.length; ++j) {
                    if (!targetColumnNames[i].equals(identifierColumnNames[j])) continue;
                    mapping.put(sourcePropertyPrefix + sourcePropertyNames[i], targetPropertyPrefix + targetIdentifierTypePropertyNames[j]);
                    continue block1;
                }
            }
            if (mapping.isEmpty()) {
                throw new IllegalArgumentException("Mapped by property '" + inverseType.getName() + "#" + attributeName + "' must be writable or the column must be part of the id!");
            }
            return mapping;
        }
        String targetIdColumnName = entityPersister.getIdentifierColumnNames()[0];
        if (!targetIdColumnName.equals(targetColumnNames[0])) {
            throw new IllegalArgumentException("Mapped by property '" + inverseType.getName() + "#" + attributeName + "' must be writable or the column must be part of the id!");
        }
        LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
        mapping.put(sourcePropertyPrefix + sourcePropertyNames[0], entityPersister.getIdentifierPropertyName());
        return mapping;
    }

    private Set<String> removeIdentifierAccess(jakarta.persistence.metamodel.EntityType<?> elementType, Set<String> elementAttributeNames, jakarta.persistence.metamodel.EntityType<?> ownerType, Set<String> columnMatchingAttributeNames) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Iterator<String> iterator = elementAttributeNames.iterator();
        AbstractEntityPersister elementPersister = this.getEntityPersister((ManagedType<?>)elementType);
        AbstractEntityPersister entityPersister = this.getEntityPersister((ManagedType<?>)ownerType);
        ArrayList<String> addedAttributeNames = new ArrayList<String>();
        for (String attributeName : columnMatchingAttributeNames) {
            String elementAttributeName = iterator.next();
            Type propertyType = this.getPropertyType(entityPersister, attributeName);
            if (propertyType instanceof EntityType) {
                if (!elementPersister.getEntityName().equals(((EntityType)propertyType).getAssociatedEntityName())) continue;
                int identifierCount = this.getJoinMappingPropertyNames(ownerType, null, attributeName).size();
                iterator.remove();
                for (int i = 1; i < identifierCount; ++i) {
                    iterator.next();
                    iterator.remove();
                }
                addedAttributeNames.add(attributeName);
                continue;
            }
            set.add(attributeName);
        }
        for (String addedAttributeName : addedAttributeNames) {
            set.add(addedAttributeName);
            elementAttributeNames.add("");
        }
        return set;
    }

    protected String getMappedBy(CollectionPersister persister) {
        if (persister instanceof CustomCollectionPersister) {
            return ((CustomCollectionPersister)persister).getMappedByProperty();
        }
        throw new IllegalStateException("Custom persister configured that doesn't implement the CustomCollectionPersister interface: " + persister);
    }

    public String[] getColumnNames(jakarta.persistence.metamodel.EntityType<?> entityType, String attributeName) {
        QueryableCollection collectionPersister = this.getCollectionPersister((ManagedType<?>)entityType, attributeName);
        if (collectionPersister == null) {
            return this.getColumnNames(this.getEntityPersister((ManagedType<?>)entityType), attributeName);
        }
        return collectionPersister.getElementColumnNames();
    }

    public String[] getColumnNames(AbstractEntityPersister entityPersister, String attributeName) {
        try {
            return entityPersister.getPropertyColumnNames(attributeName);
        }
        catch (MappingException e) {
            String attributePrefix;
            Type propertyType;
            int dotIndex = attributeName.lastIndexOf(46);
            if (dotIndex != -1 && (propertyType = this.getPropertyType(entityPersister, attributePrefix = attributeName.substring(0, dotIndex))) instanceof EntityType) {
                String[] columnNames = this.getColumnNames(entityPersister, attributePrefix);
                EntityType hibernateEntityType = (EntityType)propertyType;
                Type idType = hibernateEntityType.getIdentifierOrUniqueKeyType((Mapping)entityPersister.getFactory());
                String attributeSubName = attributeName.substring(dotIndex + 1);
                if (idType instanceof CompositeType && ((CompositeType)idType).isEmbedded()) {
                    CompositeType idClassType = (CompositeType)idType;
                    int columnSpan = 0;
                    int propertyIndex = -1;
                    String[] propertyNames = idClassType.getPropertyNames();
                    Type[] subtypes = idClassType.getSubtypes();
                    for (int i = 0; i < propertyNames.length; ++i) {
                        if (propertyNames[i].equals(attributeSubName)) {
                            propertyIndex = i;
                            break;
                        }
                        columnSpan += subtypes[i].getColumnSpan((Mapping)entityPersister.getFactory());
                    }
                    if (propertyIndex != -1) {
                        String[] actualColumns = new String[subtypes[propertyIndex].getColumnSpan((Mapping)entityPersister.getFactory())];
                        System.arraycopy(columnNames, columnSpan, actualColumns, 0, actualColumns.length);
                        return actualColumns;
                    }
                } else if (attributeSubName.equals(hibernateEntityType.getIdentifierOrUniqueKeyPropertyName((Mapping)entityPersister.getFactory()))) {
                    return columnNames;
                }
            }
            throw new RuntimeException("Unknown property [" + attributeName + "] of entity [" + entityPersister.getEntityName() + "]", e);
        }
    }

    public String[] getColumnNames(jakarta.persistence.metamodel.EntityType<?> ownerType, String elementCollectionPath, String attributeName) {
        QueryableCollection persister = this.getCollectionPersister((ManagedType<?>)ownerType, elementCollectionPath);
        String subAttributeName = attributeName.substring(elementCollectionPath.length() + 1);
        if (persister.getElementType() instanceof ComponentType) {
            ComponentType elementType = (ComponentType)persister.getElementType();
            String[] propertyNames = elementType.getPropertyNames();
            Type[] subtypes = elementType.getSubtypes();
            String[] propertyParts = subAttributeName.split("\\.");
            int offset = 0;
            block0: for (int j = 0; j < propertyParts.length - 1; ++j) {
                String propertyName = propertyParts[j];
                for (int i = 0; i < propertyNames.length; ++i) {
                    int span = subtypes[i].getColumnSpan((Mapping)persister.getFactory());
                    if (propertyName.equals(propertyNames[i])) {
                        if (subtypes[i] instanceof ComponentType) {
                            elementType = (ComponentType)subtypes[i];
                            propertyNames = elementType.getPropertyNames();
                            subtypes = elementType.getSubtypes();
                            continue block0;
                        }
                        String[] columnNames = new String[span];
                        String[] elementColumnNames = persister.getElementColumnNames();
                        System.arraycopy(elementColumnNames, offset, columnNames, 0, span);
                        return columnNames;
                    }
                    offset += span;
                }
            }
            String propertyName = propertyParts[propertyParts.length - 1];
            for (int i = 0; i < propertyNames.length; ++i) {
                int span = subtypes[i].getColumnSpan((Mapping)persister.getFactory());
                if (propertyName.equals(propertyNames[i])) {
                    String[] columnNames = new String[span];
                    String[] elementColumnNames = persister.getElementColumnNames();
                    System.arraycopy(elementColumnNames, offset, columnNames, 0, span);
                    return columnNames;
                }
                offset += span;
            }
        } else if (persister.getElementType() instanceof EntityType) {
            AbstractEntityPersister elementPersister = (AbstractEntityPersister)this.mappingMetamodel.findEntityDescriptor(((EntityType)persister.getElementType()).getAssociatedEntityName());
            Type identifierType = ((EntityType)persister.getElementType()).getIdentifierOrUniqueKeyType((Mapping)persister.getFactory());
            String identifierOrUniqueKeyPropertyName = ((EntityType)persister.getElementType()).getIdentifierOrUniqueKeyPropertyName((Mapping)persister.getFactory());
            if (identifierType instanceof EmbeddedComponentType) {
                String[] propertyNames = ((EmbeddedComponentType)identifierType).getPropertyNames();
                String[] columnNames = this.columnNamesByPropertyName(elementPersister, propertyNames, subAttributeName, "", persister.getElementColumnNames(), (Mapping)persister.getFactory());
                if (columnNames != null) {
                    return columnNames;
                }
            } else {
                String[] propertyNames;
                String[] columnNames;
                String prefix;
                if (subAttributeName.equals(identifierOrUniqueKeyPropertyName)) {
                    return persister.getElementColumnNames();
                }
                if (identifierType instanceof ComponentType && subAttributeName.startsWith(prefix = identifierOrUniqueKeyPropertyName + ".") && (columnNames = this.columnNamesByPropertyName(elementPersister, propertyNames = ((ComponentType)identifierType).getPropertyNames(), subAttributeName.substring(identifierOrUniqueKeyPropertyName.length() + 1), prefix, persister.getElementColumnNames(), (Mapping)persister.getFactory())) != null) {
                    return columnNames;
                }
            }
        }
        throw new IllegalArgumentException("Couldn't find column names for " + this.getTypeName((ManagedType<?>)ownerType) + "#" + attributeName);
    }

    private String[] columnNamesByPropertyName(AbstractEntityPersister persister, String[] propertyNames, String subAttributeName, String prefix, String[] elementColumnNames, Mapping factory) {
        int offset = 0;
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            Type propertyType = this.getPropertyType(persister, prefix + propertyName);
            int span = propertyType.getColumnSpan(factory);
            if (subAttributeName.equals(propertyName)) {
                String[] columnNames = new String[span];
                System.arraycopy(elementColumnNames, offset, columnNames, 0, span);
                return columnNames;
            }
            offset += span;
        }
        return null;
    }

    private String unquote(String name) {
        return name;
    }

    public String[] getColumnTypes(jakarta.persistence.metamodel.EntityType<?> entityType, String attributeName) {
        EntityPersister elementPersister;
        QueryableCollection collectionPersister = this.getCollectionPersister((ManagedType<?>)entityType, attributeName);
        if (collectionPersister == null) {
            boolean isSubselect;
            int i;
            Table[] tables;
            AbstractEntityPersister entityPersister = this.getEntityPersister((ManagedType<?>)entityType);
            SessionFactoryImplementor sfi = entityPersister.getFactory();
            String[] columnNames = this.getColumnNames(entityPersister, attributeName);
            Database database = (Database)sfi.getServiceRegistry().locateServiceBinding(Database.class).getService();
            if (entityPersister instanceof JoinedSubclassEntityPersister) {
                tables = new Table[((JoinedSubclassEntityPersister)entityPersister).getSubclassTableSpan()];
                for (i = 0; i < tables.length; ++i) {
                    tables[i] = this.getTable(database, entityPersister.getSubclassTableName(i));
                }
            } else if (entityPersister instanceof UnionSubclassEntityPersister) {
                tables = new Table[((UnionSubclassEntityPersister)entityPersister).getSubclassTableSpan()];
                for (i = 0; i < tables.length; ++i) {
                    tables[i] = this.getTable(database, entityPersister.getSubclassTableName(i));
                }
            } else if (entityPersister instanceof SingleTableEntityPersister) {
                tables = new Table[((SingleTableEntityPersister)entityPersister).getSubclassTableSpan()];
                for (i = 0; i < tables.length; ++i) {
                    tables[i] = this.getTable(database, entityPersister.getSubclassTableName(i));
                }
            } else {
                tables = new Table[]{this.getTable(database, entityPersister.getTableName())};
            }
            boolean bl = isSubselect = tables.length == 1 && tables[0] == null;
            if (isSubselect || this.isFormula(columnNames)) {
                Type propertyType = this.getPropertyType(entityPersister, attributeName);
                return this.getColumnTypeForPropertyType(entityType, attributeName, sfi, propertyType);
            }
            return this.getColumnTypesForColumnNames(entityType.getName(), columnNames, tables);
        }
        SessionFactoryImplementor sfi = collectionPersister.getFactory();
        Database database = (Database)sfi.getServiceRegistry().locateServiceBinding(Database.class).getService();
        Table[] tables = collectionPersister.isOneToMany() && collectionPersister.getElementType() instanceof EntityType ? ((elementPersister = collectionPersister.getElementPersister()) instanceof UnionSubclassEntityPersister ? new Table[]{this.getTable(database, (String)((Object)collectionPersister.getElementPersister().getQuerySpaces()[0]))} : new Table[]{this.getTable(database, collectionPersister.getTableName())}) : new Table[]{this.getTable(database, collectionPersister.getTableName())};
        return this.getColumnTypesForColumnNames(collectionPersister.getName(), collectionPersister.getElementColumnNames(), tables);
    }

    private String[] getColumnTypesForColumnNames(String owner, String[] columnNames, Table[] tables) {
        String[] columnTypes = new String[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            Column column = null;
            for (int j = 0; j < tables.length && (column = tables[j].getColumn(new Column(columnNames[i]))) == null; ++j) {
            }
            if (column == null) {
                throw new IllegalArgumentException("Could not find column '" + columnNames[i] + "' in entity: " + owner);
            }
            columnTypes[i] = column.getSqlType();
        }
        return columnTypes;
    }

    private String[] getColumnTypeForPropertyType(jakarta.persistence.metamodel.EntityType<?> entityType, String attributeName, SessionFactoryImplementor sfi, Type propertyType) {
        if (propertyType instanceof EntityType) {
            propertyType = ((EntityType)propertyType).getIdentifierOrUniqueKeyType((Mapping)sfi);
        }
        return new String[]{sfi.getTypeConfiguration().getDdlTypeRegistry().getTypeName(propertyType.getSqlTypeCodes((Mapping)sfi)[0], Size.nil())};
    }

    public String[] getColumnTypes(jakarta.persistence.metamodel.EntityType<?> ownerType, String elementCollectionPath, String attributeName) {
        QueryableCollection persister = this.getCollectionPersister((ManagedType<?>)ownerType, elementCollectionPath);
        SessionFactoryImplementor sfi = persister.getFactory();
        String[] columnNames = null;
        Type propertyType = null;
        String subAttributeName = attributeName.substring(elementCollectionPath.length() + 1);
        if (persister.getElementType() instanceof ComponentType) {
            ComponentType elementType = (ComponentType)persister.getElementType();
            String[] propertyNames = elementType.getPropertyNames();
            Type[] subtypes = elementType.getSubtypes();
            String[] propertyParts = subAttributeName.split("\\.");
            int offset = 0;
            block0: for (int j = 0; j < propertyParts.length - 1; ++j) {
                String propertyName = propertyParts[j];
                for (int i = 0; i < propertyNames.length; ++i) {
                    int span = subtypes[i].getColumnSpan((Mapping)persister.getFactory());
                    if (propertyName.equals(propertyNames[i])) {
                        if (subtypes[i] instanceof ComponentType) {
                            elementType = (ComponentType)subtypes[i];
                            propertyNames = elementType.getPropertyNames();
                            subtypes = elementType.getSubtypes();
                            continue block0;
                        }
                        columnNames = new String[span];
                        String[] elementColumnNames = persister.getElementColumnNames();
                        System.arraycopy(elementColumnNames, offset, columnNames, 0, span);
                        continue block0;
                    }
                    offset += span;
                }
            }
            if (columnNames == null) {
                String propertyName = propertyParts[propertyParts.length - 1];
                for (int i = 0; i < propertyNames.length; ++i) {
                    int span = subtypes[i].getColumnSpan((Mapping)persister.getFactory());
                    if (propertyName.equals(propertyNames[i])) {
                        columnNames = new String[span];
                        String[] elementColumnNames = persister.getElementColumnNames();
                        System.arraycopy(elementColumnNames, offset, columnNames, 0, span);
                        break;
                    }
                    offset += span;
                }
            }
        } else if (persister.getElementType() instanceof EntityType) {
            String prefix;
            Type identifierType = ((EntityType)persister.getElementType()).getIdentifierOrUniqueKeyType((Mapping)persister.getFactory());
            String identifierOrUniqueKeyPropertyName = ((EntityType)persister.getElementType()).getIdentifierOrUniqueKeyPropertyName((Mapping)persister.getFactory());
            if (identifierType instanceof EmbeddedComponentType) {
                String[] propertyNames = ((EmbeddedComponentType)identifierType).getPropertyNames();
                Type[] subtypes = ((EmbeddedComponentType)identifierType).getSubtypes();
                int offset = 0;
                for (int i = 0; i < propertyNames.length; ++i) {
                    String propertyName = propertyNames[i];
                    int span = subtypes[i].getColumnSpan((Mapping)persister.getFactory());
                    if (subAttributeName.equals(propertyName)) {
                        columnNames = new String[span];
                        String[] elementColumnNames = persister.getElementColumnNames();
                        System.arraycopy(elementColumnNames, offset, columnNames, 0, span);
                        propertyType = subtypes[i];
                        break;
                    }
                    offset += span;
                }
            } else if (subAttributeName.equals(identifierOrUniqueKeyPropertyName)) {
                columnNames = persister.getElementColumnNames();
                propertyType = identifierType;
            } else if (identifierType instanceof ComponentType && subAttributeName.startsWith(prefix = identifierOrUniqueKeyPropertyName + ".")) {
                String[] propertyNames = ((ComponentType)identifierType).getPropertyNames();
                Type[] subtypes = ((ComponentType)identifierType).getSubtypes();
                String subPropertyName = subAttributeName.substring(prefix.length());
                int offset = 0;
                for (int i = 0; i < propertyNames.length; ++i) {
                    String propertyName = propertyNames[i];
                    int span = subtypes[i].getColumnSpan((Mapping)persister.getFactory());
                    if (subPropertyName.equals(propertyName)) {
                        columnNames = new String[span];
                        String[] elementColumnNames = persister.getElementColumnNames();
                        System.arraycopy(elementColumnNames, offset, columnNames, 0, span);
                        propertyType = subtypes[i];
                        break;
                    }
                    offset += span;
                }
            }
        }
        if (columnNames == null) {
            throw new IllegalArgumentException("Couldn't find column names for " + this.getTypeName((ManagedType<?>)ownerType) + "#" + attributeName);
        }
        if (this.isFormula(columnNames)) {
            return this.getColumnTypeForPropertyType(ownerType, attributeName, sfi, propertyType);
        }
        Database database = (Database)sfi.getServiceRegistry().locateServiceBinding(Database.class).getService();
        Table[] tables = new Table[]{this.getTable(database, persister.getTableName())};
        return this.getColumnTypesForColumnNames(ownerType.getName(), columnNames, tables);
    }

    private Table getTable(Database database, String tableName) {
        Table table = database.getTable(this.unquote(tableName));
        if (table == null) {
            table = database.getTable(this.unquote(tableName.substring(tableName.lastIndexOf(46) + 1)));
        }
        return table;
    }

    private boolean isFormula(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i] != null) continue;
            return true;
        }
        return false;
    }

    public JoinTable getJoinTable(jakarta.persistence.metamodel.EntityType<?> ownerType, String attributeName) {
        QueryableCollection persister = this.getCollectionPersister((ManagedType<?>)ownerType, attributeName);
        if (persister instanceof QueryableCollection) {
            QueryableCollection queryableCollection = persister;
            if (!queryableCollection.getElementType().isEntityType()) {
                String[] targetColumnMetaData = queryableCollection.getElementColumnNames();
                LinkedHashMap<String, String> targetColumnMapping = new LinkedHashMap<String, String>();
                for (int i = 0; i < targetColumnMetaData.length; ++i) {
                    targetColumnMapping.put(targetColumnMetaData[i], targetColumnMetaData[i]);
                }
                return this.createJoinTable(ownerType, queryableCollection, targetColumnMapping, null, attributeName);
            }
            if (queryableCollection.getElementPersister() instanceof Joinable) {
                String elementTableName = ((Joinable)queryableCollection.getElementPersister()).getTableName();
                if (!queryableCollection.getTableName().equals(elementTableName)) {
                    String[] targetColumnMetaData = queryableCollection.getElementColumnNames();
                    AbstractEntityPersister elementPersister = (AbstractEntityPersister)queryableCollection.getElementPersister();
                    String identifierOrUniqueKeyPropertyName = ((ManyToOneType)persister.getElementType()).getIdentifierOrUniqueKeyPropertyName((Mapping)persister.getFactory());
                    String[] targetPrimaryKeyColumnMetaData = identifierOrUniqueKeyPropertyName == null ? elementPersister.getKeyColumnNames() : this.getColumnNames(elementPersister, identifierOrUniqueKeyPropertyName);
                    LinkedHashMap<String, String> targetIdColumnMapping = new LinkedHashMap<String, String>();
                    for (int i = 0; i < targetColumnMetaData.length; ++i) {
                        targetIdColumnMapping.put(targetColumnMetaData[i], targetPrimaryKeyColumnMetaData[i]);
                    }
                    Set<String> idAttributeNames = HibernateJpaProvider.getColumnMatchingAttributeNames(elementPersister, Arrays.asList(targetPrimaryKeyColumnMetaData));
                    return this.createJoinTable(ownerType, queryableCollection, targetIdColumnMapping, idAttributeNames, attributeName);
                }
            }
        }
        return null;
    }

    private JoinTable createJoinTable(jakarta.persistence.metamodel.EntityType<?> ownerType, QueryableCollection queryableCollection, Map<String, String> targetColumnMapping, Set<String> targetIdAttributeNames, String attributeName) {
        Type elementType;
        String[] primaryKeyColumnMetaData;
        String[] indexColumnNames = queryableCollection.getIndexColumnNames();
        LinkedHashMap<String, String> keyColumnMapping = null;
        LinkedHashMap<String, String> keyColumnTypes = null;
        if (indexColumnNames != null && indexColumnNames[0] != null) {
            keyColumnMapping = new LinkedHashMap<String, String>(indexColumnNames.length);
            keyColumnTypes = new LinkedHashMap<String, String>(indexColumnNames.length);
            if (queryableCollection.getKeyType().isEntityType()) {
                throw new IllegalArgumentException("Determining the join table key foreign key mappings is not yet supported!");
            }
            SessionFactoryImplementor sfi = queryableCollection.getFactory();
            Database database = (Database)sfi.getServiceRegistry().locateServiceBinding(Database.class).getService();
            Table[] tables = new Table[]{this.getTable(database, queryableCollection.getTableName())};
            keyColumnMapping.put(indexColumnNames[0], indexColumnNames[0]);
            keyColumnTypes.put(indexColumnNames[0], this.getColumnTypesForColumnNames(queryableCollection.getName(), queryableCollection.getIndexColumnNames(), tables)[0]);
        }
        AbstractEntityPersister ownerEntityPersister = (AbstractEntityPersister)queryableCollection.getOwnerEntityPersister();
        if (queryableCollection.getKeyType() instanceof EmbeddedComponentType) {
            String[] propertyNames = ((EmbeddedComponentType)queryableCollection.getKeyType()).getPropertyNames();
            ArrayList<String> columnNames = new ArrayList<String>(propertyNames.length);
            for (String propertyName : propertyNames) {
                for (String propertyColumnName : this.getColumnNames(ownerEntityPersister, propertyName)) {
                    columnNames.add(propertyColumnName);
                }
            }
            primaryKeyColumnMetaData = columnNames.toArray(new String[columnNames.size()]);
        } else {
            ValuedModelPart targetPart = queryableCollection.getAttributeMapping().getKeyDescriptor().getTargetPart();
            primaryKeyColumnMetaData = new String[targetPart.getJdbcTypeCount()];
            for (int i = 0; i < primaryKeyColumnMetaData.length; ++i) {
                primaryKeyColumnMetaData[i] = targetPart.getSelectable(i).getSelectionExpression();
            }
        }
        String[] foreignKeyColumnMetaData = queryableCollection.getKeyColumnNames();
        LinkedHashMap<String, String> idColumnMapping = new LinkedHashMap<String, String>(primaryKeyColumnMetaData.length);
        for (int i = 0; i < foreignKeyColumnMetaData.length; ++i) {
            idColumnMapping.put(foreignKeyColumnMetaData[i], primaryKeyColumnMetaData[i]);
        }
        Set<String> idAttributeNames = HibernateJpaProvider.getColumnMatchingAttributeNames(ownerEntityPersister, Arrays.asList(primaryKeyColumnMetaData));
        if (targetIdAttributeNames == null && (elementType = queryableCollection.getElementType()) instanceof ComponentType) {
            targetIdAttributeNames = new LinkedHashSet<String>();
            this.collectPropertyNames(targetIdAttributeNames, null, elementType, (Mapping)queryableCollection.getFactory());
        }
        return new JoinTable(queryableCollection.getTableName(), idAttributeNames, idColumnMapping, keyColumnMapping, keyColumnTypes, targetIdAttributeNames, targetColumnMapping);
    }

    private static Set<String> getColumnMatchingAttributeNames(AbstractEntityPersister ownerEntityPersister, List<String> idColumnNames) {
        LinkedHashSet<String> idAttributeNames = new LinkedHashSet<String>();
        Type identifierType = ownerEntityPersister.getIdentifierType();
        if (identifierType instanceof ComponentType) {
            String[] idPropertyNames;
            block0: for (String propertyName : idPropertyNames = ((ComponentType)identifierType).getPropertyNames()) {
                String attributeName = ownerEntityPersister.getIdentifierPropertyName() == null ? "" : ownerEntityPersister.getIdentifierPropertyName() + "." + propertyName;
                String[] propertyColumnNames = ownerEntityPersister.getSubclassPropertyColumnNames(attributeName);
                if (propertyColumnNames == null) continue;
                for (int j = 0; j < propertyColumnNames.length; ++j) {
                    String propertyColumnName = propertyColumnNames[j];
                    if (!idColumnNames.contains(propertyColumnName)) continue;
                    idAttributeNames.add(attributeName);
                    continue block0;
                }
            }
            if (!idAttributeNames.isEmpty()) {
                return idAttributeNames;
            }
        } else {
            for (String identifierColumnName : ownerEntityPersister.getIdentifierColumnNames()) {
                if (!idColumnNames.contains(identifierColumnName)) continue;
                idAttributeNames.add(ownerEntityPersister.getIdentifierPropertyName());
                return idAttributeNames;
            }
        }
        String[] propertyNames = ownerEntityPersister.getPropertyNames();
        block3: for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            String[] propertyColumnNames = ownerEntityPersister.getSubclassPropertyColumnNames(propertyName);
            if (propertyColumnNames == null) continue;
            for (int j = 0; j < propertyColumnNames.length; ++j) {
                Type propertyType;
                String propertyColumnName = propertyColumnNames[j];
                if (!idColumnNames.contains(propertyColumnName)) continue;
                if (propertyName.charAt(0) == '_' && (propertyType = ownerEntityPersister.getSubclassPropertyType(i)) instanceof EmbeddedComponentType) {
                    idAttributeNames.addAll(Arrays.asList(((EmbeddedComponentType)propertyType).getPropertyNames()));
                    continue block3;
                }
                idAttributeNames.add(propertyName);
                continue block3;
            }
        }
        return idAttributeNames;
    }

    public boolean isBag(jakarta.persistence.metamodel.EntityType<?> ownerType, String attributeName) {
        CollectionPersister persister = null;
        String typeName = this.getTypeName((ManagedType<?>)ownerType);
        StringBuilder sb = new StringBuilder(typeName.length() + attributeName.length() + 1);
        for (IdentifiableType type = ownerType; persister == null && type != null; type = type.getSupertype()) {
            sb.setLength(0);
            sb.append(this.getTypeName((ManagedType<?>)type));
            sb.append('.');
            sb.append(attributeName);
            persister = this.mappingMetamodel.findCollectionDescriptor(sb.toString());
        }
        return persister != null && !persister.hasIndex() && !persister.isInverse() && !(this.getAttribute((jakarta.persistence.metamodel.EntityType<?>)ownerType, attributeName) instanceof SetAttribute);
    }

    public boolean isOrphanRemoval(ManagedType<?> ownerType, String attributeName) {
        EntityMetamodel entityMetamodel;
        Integer index;
        AbstractEntityPersister entityPersister = this.getEntityPersister(ownerType);
        if (entityPersister != null && (index = (entityMetamodel = entityPersister.getEntityMetamodel()).getPropertyIndexOrNull(attributeName)) != null) {
            return entityMetamodel.getCascadeStyles()[index].hasOrphanDelete();
        }
        return false;
    }

    public boolean isOrphanRemoval(ManagedType<?> ownerType, String elementCollectionPath, String attributeName) {
        int propertyIndex;
        Type elementType = this.getCollectionPersister(ownerType, elementCollectionPath).getElementType();
        if (!(elementType instanceof ComponentType)) {
            return false;
        }
        ComponentType componentType = (ComponentType)elementType;
        String subAttribute = attributeName.substring(elementCollectionPath.length() + 1);
        String[] propertyParts = subAttribute.split("\\.");
        for (propertyIndex = 0; propertyIndex < propertyParts.length - 1; ++propertyIndex) {
            int index = componentType.getPropertyIndex(propertyParts[propertyIndex]);
            Type propertyType = componentType.getSubtypes()[index];
            if (!(propertyType instanceof ComponentType)) break;
            componentType = (ComponentType)propertyType;
        }
        return componentType.getCascadeStyle(propertyIndex).hasOrphanDelete();
    }

    public boolean isDeleteCascaded(ManagedType<?> ownerType, String attributeName) {
        EntityMetamodel entityMetamodel;
        Integer index;
        AbstractEntityPersister entityPersister = this.getEntityPersister(ownerType);
        if (entityPersister != null && (index = (entityMetamodel = entityPersister.getEntityMetamodel()).getPropertyIndexOrNull(attributeName)) != null) {
            return entityMetamodel.getCascadeStyles()[index].doCascade(CascadingActions.DELETE);
        }
        return false;
    }

    public boolean isDeleteCascaded(ManagedType<?> ownerType, String elementCollectionPath, String attributeName) {
        int propertyIndex;
        Type elementType = this.getCollectionPersister(ownerType, elementCollectionPath).getElementType();
        if (!(elementType instanceof ComponentType)) {
            return false;
        }
        ComponentType componentType = (ComponentType)elementType;
        String subAttribute = attributeName.substring(elementCollectionPath.length() + 1);
        String[] propertyParts = subAttribute.split("\\.");
        for (propertyIndex = 0; propertyIndex < propertyParts.length - 1; ++propertyIndex) {
            int index = componentType.getPropertyIndex(propertyParts[propertyIndex]);
            Type propertyType = componentType.getSubtypes()[index];
            if (!(propertyType instanceof ComponentType)) break;
            componentType = (ComponentType)propertyType;
        }
        int leafPropertyIndex = componentType.getPropertyIndex(propertyParts[propertyIndex]);
        return componentType.getCascadeStyle(leafPropertyIndex).doCascade(CascadingActions.DELETE);
    }

    public boolean hasJoinCondition(ManagedType<?> owner, String elementCollectionPath, String attributeName) {
        Type propertyType;
        QueryableCollection persister;
        AbstractEntityPersister entityPersister = this.getEntityPersister(owner);
        if (entityPersister == null) {
            return false;
        }
        SessionFactoryImplementor factory = entityPersister.getFactory();
        if (elementCollectionPath != null && (persister = this.getCollectionPersister(owner, elementCollectionPath)) != null) {
            Type elementType = persister.getElementType();
            if (!(elementType instanceof ComponentType)) {
                return false;
            }
            ComponentType componentType = (ComponentType)elementType;
            String subAttribute = attributeName.substring(elementCollectionPath.length() + 1);
            String[] propertyParts = subAttribute.split("\\.");
            for (int i = 0; i < propertyParts.length - 1; ++i) {
                int index = componentType.getPropertyIndex(propertyParts[i]);
                propertyType = componentType.getSubtypes()[index];
                if (!(propertyType instanceof ComponentType)) {
                    return false;
                }
                componentType = (ComponentType)propertyType;
            }
            propertyType = componentType.getSubtypes()[componentType.getPropertyIndex(propertyParts[propertyParts.length - 1])];
        } else {
            propertyType = this.getPropertyType(entityPersister, attributeName);
        }
        if (propertyType instanceof CollectionType) {
            return ((QueryableCollection)this.mappingMetamodel.findCollectionDescriptor(((CollectionType)propertyType).getRole())).hasWhere();
        }
        if (propertyType instanceof EntityType) {
            AbstractEntityPersister elementPersister = (AbstractEntityPersister)this.mappingMetamodel.findEntityDescriptor(((EntityType)propertyType).getAssociatedEntityName());
            try {
                elementPersister.applyWhereRestrictions(null, null, true, null);
                return false;
            }
            catch (NullPointerException ex) {
                return true;
            }
        }
        return false;
    }

    private Type getPropertyType(AbstractEntityPersister entityPersister, String attributeName) {
        try {
            return entityPersister.getPropertyType(attributeName);
        }
        catch (QueryException ex) {
            Type propertyType;
            int dotIndex = attributeName.lastIndexOf(46);
            if (dotIndex != -1 && (propertyType = this.getPropertyType(entityPersister, attributeName.substring(0, dotIndex))) instanceof EntityType) {
                EntityType entityType = (EntityType)propertyType;
                Type idType = entityType.getIdentifierOrUniqueKeyType((Mapping)entityPersister.getFactory());
                String attributeSubName = attributeName.substring(dotIndex + 1);
                if (idType instanceof CompositeType && ((CompositeType)idType).isEmbedded()) {
                    CompositeType idClassType = (CompositeType)idType;
                    int propertyIndex = Arrays.asList(idClassType.getPropertyNames()).indexOf(attributeSubName);
                    if (propertyIndex != -1) {
                        return idClassType.getSubtypes()[propertyIndex];
                    }
                } else if (attributeSubName.equals(entityType.getIdentifierOrUniqueKeyPropertyName((Mapping)entityPersister.getFactory()))) {
                    return idType;
                }
            }
            throw ex;
        }
    }

    public boolean containsEntity(EntityManager em, Class<?> entityClass, Object id) {
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        EntityKey entityKey = session.generateEntityKey((Object)((Serializable)id), this.mappingMetamodel.findEntityDescriptor(entityClass.getName()));
        PersistenceContext pc = session.getPersistenceContext();
        return pc.getEntity(entityKey) != null || pc.getProxy(entityKey) != null;
    }

    private Attribute<?, ?> getAttribute(jakarta.persistence.metamodel.EntityType<?> ownerType, String attributeName) {
        if (attributeName.indexOf(46) == -1) {
            return ownerType.getAttribute(attributeName);
        }
        ManagedType t = ownerType;
        Attribute attr = null;
        String[] parts = attributeName.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            SingularAttribute singularAttribute;
            attr = t.getAttribute(parts[i]);
            if (i + 1 == parts.length) continue;
            if (attr instanceof SingularAttribute && (singularAttribute = (SingularAttribute)attr).getType().getPersistenceType() != Type.PersistenceType.BASIC) {
                t = (ManagedType)singularAttribute.getType();
                continue;
            }
            throw new IllegalArgumentException("Illegal attribute name for type [" + ownerType.getJavaType().getName() + "]: " + attributeName);
        }
        return attr;
    }

    public boolean supportsSingleValuedAssociationIdExpressions() {
        return true;
    }

    public boolean supportsUpdateSetEmbeddable() {
        return false;
    }

    public boolean supportsUpdateSetAssociationId() {
        return true;
    }

    public boolean supportsTransientEntityAsParameter() {
        return true;
    }

    public boolean needsTypeConstraintForColumnSharing() {
        return true;
    }

    public void setCacheable(Query query) {
        query.setHint("org.hibernate.cacheable", (Object)true);
    }

    public void setSingularParameter(Query query, String name, Object value) {
        query.setParameter(name, value);
    }

    public List<String> getIdentifierOrUniqueKeyEmbeddedPropertyNames(jakarta.persistence.metamodel.EntityType<?> owner, String attributeName) {
        return new ArrayList<String>(this.getJoinMappingPropertyNames(owner, null, attributeName).keySet());
    }

    public List<String> getIdentifierOrUniqueKeyEmbeddedPropertyNames(jakarta.persistence.metamodel.EntityType<?> owner, String elementCollectionPath, String attributeName) {
        return new ArrayList<String>(this.getJoinMappingPropertyNames(owner, elementCollectionPath, attributeName).keySet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> getJoinMappingPropertyNames(jakarta.persistence.metamodel.EntityType<?> owner, String elementCollectionPath, String attributeName) {
        Type propertyType;
        int i;
        QueryableCollection persister;
        AbstractEntityPersister entityPersister = this.getEntityPersister((ManagedType<?>)owner);
        SessionFactoryImplementor factory = entityPersister.getFactory();
        if (elementCollectionPath != null && (persister = this.getCollectionPersister((ManagedType<?>)owner, elementCollectionPath)) != null) {
            ComponentType componentType = (ComponentType)persister.getElementType();
            String subAttribute = attributeName.substring(elementCollectionPath.length() + 1);
            String[] propertyParts = subAttribute.split("\\.");
            for (i = 0; i < propertyParts.length - 1; ++i) {
                int index = componentType.getPropertyIndex(propertyParts[i]);
                propertyType = componentType.getSubtypes()[index];
                if (!(propertyType instanceof ComponentType)) {
                    throw new IllegalStateException("Can't get the id properties for: " + attributeName);
                }
                componentType = (ComponentType)propertyType;
            }
            propertyType = componentType.getSubtypes()[componentType.getPropertyIndex(propertyParts[propertyParts.length - 1])];
        } else {
            propertyType = this.getPropertyType(entityPersister, attributeName);
        }
        ArrayList<String> identifierOrUniqueKeyPropertyNames = new ArrayList<String>();
        ArrayList<String> sourceIdentifierOrUniqueKeyPropertyNames = new ArrayList<String>();
        if (propertyType instanceof CollectionType) {
            Type elementType = ((CollectionType)propertyType).getElementType(factory);
            if (elementType instanceof EntityType) {
                Set targetAttributeNames;
                JoinTable joinTable = this.getJoinTable(owner, attributeName);
                Set set = targetAttributeNames = joinTable == null ? null : joinTable.getTargetAttributeNames();
                if (targetAttributeNames == null) {
                    this.collectPropertyNames(identifierOrUniqueKeyPropertyNames, null, elementType, (Mapping)factory);
                    String mappedBy = this.getMappedBy((CollectionPersister)this.getCollectionPersister((ManagedType<?>)owner, attributeName));
                    if (mappedBy == null || mappedBy.isEmpty()) {
                        if (!((CollectionType)propertyType).useLHSPrimaryKey()) throw new IllegalArgumentException("One-to-many using natural key is unsupported!");
                        sourceIdentifierOrUniqueKeyPropertyNames.add(entityPersister.getIdentifierPropertyName());
                    } else {
                        AbstractEntityPersister elementPersister = (AbstractEntityPersister)this.mappingMetamodel.findEntityDescriptor(((EntityType)elementType).getAssociatedEntityName());
                        this.collectPropertyNames(sourceIdentifierOrUniqueKeyPropertyNames, null, this.getPropertyType(elementPersister, mappedBy), (Mapping)factory);
                    }
                } else {
                    AbstractEntityPersister elementPersister = (AbstractEntityPersister)this.mappingMetamodel.findEntityDescriptor(((EntityType)elementType).getAssociatedEntityName());
                    for (String targetAttributeName : targetAttributeNames) {
                        this.collectPropertyNames(identifierOrUniqueKeyPropertyNames, targetAttributeName, this.getPropertyType(elementPersister, targetAttributeName), (Mapping)factory);
                    }
                    for (String idAttributeName : joinTable.getIdAttributeNames()) {
                        this.collectPropertyNames(sourceIdentifierOrUniqueKeyPropertyNames, idAttributeName, this.getPropertyType(entityPersister, idAttributeName), (Mapping)factory);
                    }
                }
            }
        } else {
            this.collectPropertyNames(identifierOrUniqueKeyPropertyNames, null, propertyType, (Mapping)factory);
            if (propertyType instanceof EntityType) {
                AbstractEntityPersister elementPersister = (AbstractEntityPersister)this.mappingMetamodel.findEntityDescriptor(((EntityType)propertyType).getAssociatedEntityName());
                if (((EntityType)propertyType).isReferenceToPrimaryKey()) {
                    if (elementPersister.getIdentifierType().isComponentType()) {
                        String targetPropertyPrefix = elementPersister.getIdentifierPropertyName() == null ? attributeName + "." : "";
                        for (int i2 = 0; i2 < identifierOrUniqueKeyPropertyNames.size(); ++i2) {
                            sourceIdentifierOrUniqueKeyPropertyNames.add(targetPropertyPrefix + (String)identifierOrUniqueKeyPropertyNames.get(i2));
                        }
                    } else {
                        sourceIdentifierOrUniqueKeyPropertyNames.add(elementPersister.getIdentifierPropertyName());
                    }
                } else if (propertyType instanceof OneToOneType) {
                    String mappedBy = ((OneToOneType)propertyType).getRHSUniqueKeyPropertyName();
                    if (mappedBy == null || mappedBy.isEmpty()) {
                        throw new IllegalArgumentException("One-to-one using natural key is unsupported!");
                    }
                    this.collectPropertyNames(sourceIdentifierOrUniqueKeyPropertyNames, null, this.getPropertyType(elementPersister, mappedBy), (Mapping)factory);
                }
            }
        }
        LinkedHashMap<String, String> joinMapping = new LinkedHashMap<String, String>(identifierOrUniqueKeyPropertyNames.size());
        for (i = 0; i < identifierOrUniqueKeyPropertyNames.size(); ++i) {
            if (sourceIdentifierOrUniqueKeyPropertyNames.size() > i) {
                joinMapping.put((String)identifierOrUniqueKeyPropertyNames.get(i), (String)sourceIdentifierOrUniqueKeyPropertyNames.get(i));
                continue;
            }
            joinMapping.put((String)identifierOrUniqueKeyPropertyNames.get(i), null);
        }
        return joinMapping;
    }

    private void collectPropertyNames(Collection<String> propertyNames, String prefix, Type propertyType, Mapping factory) {
        if (propertyType instanceof ComponentType) {
            ComponentType componentType = (ComponentType)propertyType;
            for (String propertyName : componentType.getPropertyNames()) {
                Type subtype = componentType.getSubtypes()[componentType.getPropertyIndex(propertyName)];
                this.collectPropertyNames(propertyNames, prefix == null ? propertyName : prefix + "." + propertyName, subtype, factory);
            }
        } else if (propertyType instanceof EntityType) {
            EntityType entityType = (EntityType)propertyType;
            Type identifierOrUniqueKeyType = entityType.getIdentifierOrUniqueKeyType(factory);
            if (identifierOrUniqueKeyType instanceof EmbeddedComponentType) {
                EmbeddedComponentType embeddedComponentType = (EmbeddedComponentType)identifierOrUniqueKeyType;
                for (String propertyName : embeddedComponentType.getPropertyNames()) {
                    propertyNames.add(prefix == null ? propertyName : prefix + "." + propertyName);
                }
            } else {
                String identifierOrUniqueKeyPropertyName = entityType.getIdentifierOrUniqueKeyPropertyName(factory);
                this.collectPropertyNames(propertyNames, prefix == null ? identifierOrUniqueKeyPropertyName : prefix + "." + identifierOrUniqueKeyPropertyName, identifierOrUniqueKeyType, factory);
            }
        } else if (!(propertyType instanceof CollectionType) && prefix != null) {
            propertyNames.add(prefix);
        }
    }

    public boolean supportsEnumLiteral(ManagedType<?> ownerType, String attributeName, boolean key) {
        return true;
    }

    public boolean supportsTemporalLiteral() {
        return true;
    }

    public boolean supportsNonDrivingAliasInOnClause() {
        return true;
    }

    public boolean supportsSelectCompositeIdEntityInSubquery() {
        return false;
    }

    public boolean supportsProxyParameterForNonPkAssociation() {
        return false;
    }

    public boolean supportsProxyRemove() {
        return true;
    }

    public void initialize(Object entity) {
        Hibernate.initialize((Object)entity);
    }

    public Object getIdentifier(Object entity) {
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }
        return this.persistenceUnitUtil.getIdentifier(entity);
    }

    public <T> T unproxy(T entity) {
        if (entity instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)entity;
            LazyInitializer initializer = hibernateProxy.getHibernateLazyInitializer();
            return (T)initializer.getImplementation();
        }
        return entity;
    }

    public JpaMetamodelAccessor getJpaMetamodelAccessor() {
        return JpaMetamodelAccessorImpl.INSTANCE;
    }

    private static enum DB {
        OTHER,
        MY_SQL,
        DB2,
        MSSQL;

    }
}

