/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser;

import com.blazebit.persistence.parser.SQLLexer;
import com.blazebit.persistence.parser.SQLParser;
import com.blazebit.persistence.parser.SQLParserBaseVisitor;
import com.blazebit.persistence.parser.antlr.ANTLRErrorListener;
import com.blazebit.persistence.parser.antlr.CharStreams;
import com.blazebit.persistence.parser.antlr.CommonTokenStream;
import com.blazebit.persistence.parser.antlr.Parser;
import com.blazebit.persistence.parser.antlr.RecognitionException;
import com.blazebit.persistence.parser.antlr.Recognizer;
import com.blazebit.persistence.parser.antlr.atn.ATNConfigSet;
import com.blazebit.persistence.parser.antlr.dfa.DFA;
import com.blazebit.persistence.parser.expression.SyntaxErrorException;
import java.util.BitSet;

public class SqlParserUtils {
    private static final ANTLRErrorListener ERR_LISTENER = new ANTLRErrorListener(){

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new SyntaxErrorException("line " + line + ":" + charPositionInLine + " " + msg);
        }

        @Override
        public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        }
    };

    private SqlParserUtils() {
    }

    public static <T> T visitSelectStatement(CharSequence sql, SQLParserBaseVisitor<T> visitor) {
        SQLLexer lexer = new SQLLexer(CharStreams.fromString(sql.toString()));
        lexer.removeErrorListeners();
        lexer.addErrorListener(ERR_LISTENER);
        SQLParser parser = new SQLParser(new CommonTokenStream(lexer));
        parser.removeErrorListeners();
        parser.addErrorListener(ERR_LISTENER);
        return parser.parseSelectStatement().accept(visitor);
    }
}

