/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser;

import com.blazebit.persistence.parser.CharSequenceUtils;
import com.blazebit.persistence.parser.SubSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class JsonParser {
    private JsonParser() {
    }

    public static List<Object[]> parseStringOnly(CharSequence json, String ... fields) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        StringBuilder sb = new StringBuilder();
        if (json != null && json.length() != 0) {
            HashMap<String, Integer> fieldMap = new HashMap<String, Integer>(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                fieldMap.put(fields[i], i);
            }
            int start = CharSequenceUtils.indexOf(json, '[') + 1;
            int end = CharSequenceUtils.lastIndexOf(json, ']');
            for (int i = start; i < end; ++i) {
                Object[] object = new Object[fields.length];
                boolean quoteMode = false;
                int fieldIndex = -1;
                boolean escapes = false;
                block15: for (i = CharSequenceUtils.indexOf(json, '{', i) + 1; i < end; ++i) {
                    char c = json.charAt(i);
                    if (!quoteMode) {
                        if (c == '\"') {
                            quoteMode = true;
                            continue;
                        }
                        if (c == '}') break;
                        if (c == ':' || c == ',' || Character.isWhitespace(c)) continue;
                        switch (c) {
                            case 'n': {
                                object[fieldIndex] = null;
                                i += 3;
                                fieldIndex = -1;
                                escapes = false;
                                continue block15;
                            }
                            case '[': {
                                int nestedEnd = JsonParser.findEnd(json, i);
                                object[fieldIndex] = new SubSequence(json, i, nestedEnd);
                                fieldIndex = -1;
                                i = nestedEnd - 1;
                                continue block15;
                            }
                            default: {
                                throw new IllegalArgumentException("Non-String value unsupported! Found at: " + i);
                            }
                        }
                    }
                    if (c == '\\') {
                        escapes = true;
                        c = json.charAt(++i);
                        switch (c) {
                            case 'b': {
                                c = '\b';
                                break;
                            }
                            case 'f': {
                                c = '\f';
                                break;
                            }
                            case 'r': {
                                c = '\r';
                                break;
                            }
                            case 'n': {
                                c = '\n';
                                break;
                            }
                            case 't': {
                                c = '\t';
                                break;
                            }
                            case 'u': {
                                c = (char)Integer.parseInt(json.subSequence(i + 1, i + 5).toString(), 16);
                                i += 4;
                                break;
                            }
                            case '\"': 
                            case '/': 
                            case '\\': {
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected escape sequence at position: " + i);
                            }
                        }
                        sb.append(c);
                        continue;
                    }
                    if (c == '\"') {
                        if (fieldIndex == -1) {
                            fieldIndex = (Integer)fieldMap.get(sb.toString());
                        } else {
                            object[fieldIndex] = escapes ? sb.toString() : new SubSequence(json, i - sb.length(), i);
                            fieldIndex = -1;
                            escapes = false;
                        }
                        sb.setLength(0);
                        quoteMode = false;
                        continue;
                    }
                    sb.append(c);
                }
                list.add(object);
            }
        }
        return list;
    }

    private static int findEnd(CharSequence json, int i) {
        int arrayLevel = 1;
        int end = json.length();
        boolean quoteMode = false;
        ++i;
        while (i < end) {
            block11: {
                char c;
                block10: {
                    c = json.charAt(i);
                    if (quoteMode) break block10;
                    switch (c) {
                        case '\"': {
                            quoteMode = true;
                            break;
                        }
                        case '[': {
                            ++arrayLevel;
                            break;
                        }
                        case ']': {
                            if (--arrayLevel == 0) {
                                return i + 1;
                            } else {
                                break;
                            }
                        }
                    }
                    break block11;
                }
                if (c == '\\') {
                    ++i;
                } else if (c == '\"') {
                    quoteMode = false;
                }
            }
            ++i;
        }
        return i;
    }
}

