/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.transform;

import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.GroupByManager;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.OrderByManager;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvedExpression;
import com.blazebit.persistence.impl.SelectManager;
import com.blazebit.persistence.impl.transform.ExpressionTransformerGroup;
import com.blazebit.persistence.impl.transform.SizeExpressionTransformer;
import com.blazebit.persistence.impl.transform.SizeSelectInfoTransformer;
import com.blazebit.persistence.impl.transform.SizeTransformationVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SizeTransformerGroup
implements ExpressionTransformerGroup<ExpressionModifier> {
    private final SizeTransformationVisitor sizeTransformationVisitor;
    private final AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder;
    private final SelectManager<?> selectManager;
    private final JoinManager joinManager;
    private final GroupByManager groupByManager;
    private final ParameterManager parameterManager;
    private final SizeExpressionTransformer sizeExpressionTransformer;
    private final SizeSelectInfoTransformer sizeSelectExpressionTransformer;

    public SizeTransformerGroup(SizeTransformationVisitor sizeTransformationVisitor, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder, OrderByManager orderByManager, SelectManager<?> selectManager, JoinManager joinManager, GroupByManager groupByManager, ParameterManager parameterManager) {
        this.sizeTransformationVisitor = sizeTransformationVisitor;
        this.queryBuilder = queryBuilder;
        this.selectManager = selectManager;
        this.joinManager = joinManager;
        this.sizeExpressionTransformer = new SizeExpressionTransformer(sizeTransformationVisitor);
        this.groupByManager = groupByManager;
        this.parameterManager = parameterManager;
        this.sizeSelectExpressionTransformer = new SizeSelectInfoTransformer(sizeTransformationVisitor, orderByManager);
    }

    @Override
    public void beforeTransformationGroup() {
        for (ParameterManager.ParameterImpl<?> parameter : this.parameterManager.getParameterImpls()) {
            Set<AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> set = parameter.getClauseTypes().get((Object)ClauseType.SELECT);
            if (!(set != null && set.contains(this.queryBuilder) || (set = parameter.getClauseTypes().get((Object)ClauseType.ORDER_BY)) != null && set.contains(this.queryBuilder)) && ((set = parameter.getClauseTypes().get((Object)ClauseType.HAVING)) == null || !set.contains(this.queryBuilder)) || this.parameterManager.getLiteralParameterValue(parameter.getValue(), false) != null) continue;
            this.sizeTransformationVisitor.setCountTransformationDisabled(true);
        }
    }

    @Override
    public void applyExpressionTransformer(AbstractManager<? extends ExpressionModifier> manager) {
        if (manager.getClauseType() != ClauseType.SELECT || this.selectManager.containsSizeSelect()) {
            switch (manager.getClauseType()) {
                case WHERE: 
                case JOIN: 
                case GROUP_BY: 
                case HAVING: 
                case ORDER_BY: {
                    manager.apply(this.sizeExpressionTransformer);
                    break;
                }
                case SELECT: {
                    manager.apply(this.sizeSelectExpressionTransformer);
                    break;
                }
            }
        }
    }

    @Override
    public void afterTransformationGroup() {
        for (SizeTransformationVisitor.LateJoinEntry lateJoinEntry : this.sizeTransformationVisitor.getLateJoins().values()) {
            for (Expression requiredJoinExpression : lateJoinEntry.getExpressionsToJoin()) {
                for (ClauseType clauseType : lateJoinEntry.getClauseDependencies()) {
                    this.joinManager.implicitJoin(requiredJoinExpression, true, true, true, null, clauseType, new HashSet<String>(), false, false, true, false);
                }
            }
        }
        for (Map.Entry entry : this.sizeTransformationVisitor.getRequiredGroupBys().entrySet()) {
            this.groupByManager.collect((ResolvedExpression)entry.getKey(), (Set)entry.getValue());
        }
    }

    @Override
    public void afterAllTransformations() {
        if (this.groupByManager.hasCollectedGroupByClauses()) {
            for (Map.Entry<ResolvedExpression, Set<ClauseType>> entry : this.sizeTransformationVisitor.getSubqueryGroupBys().entrySet()) {
                this.groupByManager.collect(entry.getKey(), entry.getValue());
            }
        }
    }
}

