/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.ModificationQuerySpecification;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.DbmsModificationState;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeleteModificationQuerySpecification<T>
extends ModificationQuerySpecification<T> {
    private final String tableToDelete;
    private final String tableAlias;
    private final String[] idColumns;
    private final boolean innerJoinOnly;
    private final Query deleteExampleQuery;

    public DeleteModificationQuerySpecification(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> commonQueryBuilder, Query baseQuery, Query exampleQuery, Collection<? extends Parameter<?>> parameters, Set<String> parameterListNames, List<String> keyRestrictedLeftJoinAliases, List<EntityFunctionNode> entityFunctionNodes, boolean recursive, List<CTENode> ctes, boolean shouldRenderCteNodes, boolean isEmbedded, String[] returningColumns, ReturningObjectBuilder<T> objectBuilder, Map<DbmsModificationState, String> includedModificationStates, Map<String, String> returningAttributeBindingMap, boolean queryPlanCacheEnabled, String tableToDelete, String tableAlias, String[] idColumns, boolean innerJoinOnly, Query deleteExampleQuery) {
        super(commonQueryBuilder, baseQuery, exampleQuery, parameters, parameterListNames, keyRestrictedLeftJoinAliases, entityFunctionNodes, recursive, ctes, shouldRenderCteNodes, isEmbedded, returningColumns, objectBuilder, includedModificationStates, returningAttributeBindingMap, queryPlanCacheEnabled);
        this.tableToDelete = tableToDelete;
        this.tableAlias = tableAlias;
        this.idColumns = idColumns;
        this.innerJoinOnly = innerJoinOnly;
        this.deleteExampleQuery = deleteExampleQuery;
    }

    @Override
    protected void initialize() {
        int fromIndex;
        ArrayList<Query> participatingQueries = new ArrayList<Query>();
        for (Map.Entry entry : this.listParameters.entrySet()) {
            this.baseQuery.setParameter((String)entry.getKey(), entry.getValue());
        }
        String sql = this.applySqlTransformations(this.extendedQuerySupport.getSql(this.em, this.baseQuery)).toString();
        StringBuilder sb = new StringBuilder(sql.length());
        String tableToDelete = this.tableToDelete;
        if (tableToDelete == null) {
            sb.append(sql);
            fromIndex = SqlUtils.indexOfFrom(sql);
            tableToDelete = sql.substring(fromIndex + " from ".length(), sql.indexOf(32, fromIndex + " from ".length() + 1));
        } else {
            fromIndex = SqlUtils.indexOfFrom(sql);
            int tableStartIndex = fromIndex + " from ".length();
            int tableEndIndex = sql.indexOf(" ", tableStartIndex);
            int tableAliasEndIndex = sql.indexOf(" ", tableEndIndex + 1);
            switch (this.dbmsDialect.getDeleteJoinStyle()) {
                case FROM: {
                    sb.append("delete ").append(this.tableAlias);
                    sb.append(sql, fromIndex, sql.length());
                    break;
                }
                case USING: {
                    sb.append("delete from ");
                    if (this.innerJoinOnly) {
                        sb.append(tableToDelete).append(' ').append(this.tableAlias);
                        sb.append(" using ");
                        int onClauseIndex = SqlUtils.indexOfOn(sql, tableAliasEndIndex);
                        int onClauseEndIndex = SqlUtils.findEndOfOnClause(sql, onClauseIndex, SqlUtils.indexOfWhere(sql));
                        int[] range = SqlUtils.rtrimBackwardsToFirstWhitespace(sql, onClauseIndex - 1);
                        range = SqlUtils.rtrimBackwardsToFirstWhitespace(sql, range[0] - 1);
                        int joinTableStartIndex = range[0];
                        int predicateStartIndex = onClauseIndex + " on ".length();
                        sb.append(sql, joinTableStartIndex, onClauseIndex);
                        sb.append(sql, onClauseEndIndex, sql.length());
                        sb.append(" and ").append(sql, predicateStartIndex, onClauseEndIndex);
                        break;
                    }
                    sb.append(tableToDelete);
                    sb.append(" using ");
                    sb.append(sql, tableStartIndex, sql.length());
                    for (String idColumn : this.idColumns) {
                        sb.append(" and ").append(tableToDelete).append('.').append(idColumn).append(" = ").append(this.tableAlias).append('.').append(idColumn);
                    }
                    break;
                }
                case NONE: 
                case MERGE: {
                    int whereIndex = SqlUtils.indexOfWhere(sql);
                    sb.append("delete ").append(tableToDelete);
                    if (whereIndex == -1) break;
                    sb.append(sql, whereIndex, sql.length());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported delete join style: " + this.dbmsDialect.getDeleteJoinStyle());
                }
            }
        }
        StringBuilder withClause = this.applyCtes(sb, this.baseQuery, participatingQueries);
        Map<String, String> addedCtes = this.applyExtendedSql(sb, false, this.isEmbedded, withClause, tableToDelete, this.returningColumns, this.includedModificationStates);
        participatingQueries.add(this.baseQuery);
        participatingQueries.add(this.exampleQuery);
        participatingQueries.add(this.deleteExampleQuery);
        boolean hasCtes = withClause != null && withClause.length() != 0 || addedCtes != null && !addedCtes.isEmpty();
        this.query = hasCtes && this.returningAttributeBindingMap.isEmpty() && !this.dbmsDialect.usesExecuteUpdateWhenWithClauseInModificationQuery() ? this.exampleQuery : this.deleteExampleQuery;
        this.sql = sb.toString();
        this.participatingQueries = participatingQueries;
        this.addedCtes = addedCtes;
        this.dirty = false;
    }
}

