/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.impl.dialect.DB2DbmsLimitHandler;
import com.blazebit.persistence.impl.dialect.DefaultDbmsDialect;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.DbmsLimitHandler;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.DeleteJoinStyle;
import com.blazebit.persistence.spi.OrderByElement;
import com.blazebit.persistence.spi.UpdateJoinStyle;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DB2DbmsDialect
extends DefaultDbmsDialect {
    public DB2DbmsDialect() {
        super(DB2DbmsDialect.getSqlTypes());
    }

    public DB2DbmsDialect(Map<Class<?>, String> childSqlTypes) {
        super(childSqlTypes);
    }

    protected static Map<Class<?>, String> getSqlTypes() {
        HashMap types = new HashMap();
        types.put(String.class, "varchar(2048)");
        return types;
    }

    @Override
    public boolean supportsAnsiRowValueConstructor() {
        return false;
    }

    @Override
    public String getWithClause(boolean recursive) {
        return "with";
    }

    @Override
    public DeleteJoinStyle getDeleteJoinStyle() {
        return DeleteJoinStyle.MERGE;
    }

    @Override
    public UpdateJoinStyle getUpdateJoinStyle() {
        return UpdateJoinStyle.MERGE;
    }

    @Override
    public boolean supportsComplexJoinOn() {
        return false;
    }

    @Override
    public boolean supportsJoinsInRecursiveCte() {
        return false;
    }

    @Override
    public boolean supportsReturningColumns() {
        return true;
    }

    @Override
    public boolean supportsModificationQueryInWithClause() {
        return true;
    }

    @Override
    public boolean usesExecuteUpdateWhenWithClauseInModificationQuery() {
        return false;
    }

    @Override
    public boolean supportsIntersect(boolean all) {
        return true;
    }

    @Override
    public boolean supportsExcept(boolean all) {
        return true;
    }

    @Override
    protected boolean supportsPartitionInRowNumberOver() {
        return true;
    }

    @Override
    public boolean supportsArbitraryLengthMultiset() {
        return true;
    }

    @Override
    public Map<String, String> appendExtendedSql(StringBuilder sqlSb, DbmsStatementType statementType, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String limit, String offset, String dmlAffectedTable, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        boolean needsReturningWrapper;
        boolean addParenthesis;
        boolean requiresOld = includedModificationStates != null && includedModificationStates.containsKey(DbmsModificationState.OLD);
        boolean bl = addParenthesis = isSubquery && sqlSb.length() > 0 && sqlSb.charAt(0) != '(';
        if (requiresOld) {
            LinkedHashMap<String, String> dbmsModificationStateQueries = new LinkedHashMap<String, String>();
            StringBuilder sb = new StringBuilder(sqlSb.length() + 30);
            if (statementType == DbmsStatementType.INSERT) {
                StringBuilder newValuesSb = new StringBuilder();
                String newValuesTableName = includedModificationStates.get(DbmsModificationState.OLD) + "_new";
                newValuesSb.append("select * from final table (");
                newValuesSb.append((CharSequence)sqlSb);
                newValuesSb.append(")");
                dbmsModificationStateQueries.put(newValuesTableName, newValuesSb.toString());
                int startIndex = SqlUtils.INTO_FINDER.indexIn(sqlSb, 0, sqlSb.length()) + "into ".length();
                int endIndex = sqlSb.indexOf(" ", startIndex);
                endIndex = DB2DbmsDialect.indexOfOrEnd(sqlSb, '(', startIndex, endIndex);
                String table = sqlSb.substring(startIndex, endIndex);
                sb.append("select * from ");
                sb.append(table);
                sb.append(" except ");
                sb.append("select * from ");
                sb.append(newValuesTableName);
            } else {
                sb.append("select * from old table (");
                sb.append((CharSequence)sqlSb);
                sb.append(")");
            }
            sqlSb.setLength(0);
            if (addParenthesis) {
                sqlSb.append('(');
            }
            sqlSb.append("select ");
            for (int i = 0; i < returningColumns.length; ++i) {
                if (i != 0) {
                    sqlSb.append(',');
                }
                sqlSb.append(returningColumns[i]);
            }
            sqlSb.append(" from ");
            sqlSb.append(includedModificationStates.get(DbmsModificationState.OLD));
            dbmsModificationStateQueries.put(includedModificationStates.get(DbmsModificationState.OLD), sb.toString());
            if (addParenthesis) {
                sqlSb.append(')');
            }
            return dbmsModificationStateQueries;
        }
        boolean bl2 = needsReturningWrapper = statementType != DbmsStatementType.SELECT && (isEmbedded || returningColumns != null);
        if (needsReturningWrapper || withClause != null && statementType != DbmsStatementType.SELECT) {
            if (addParenthesis) {
                sqlSb.insert(0, '(');
            }
            if (limit != null) {
                this.appendLimit(sqlSb, isSubquery, limit, offset);
            }
            String[] columns = returningColumns == null ? new String[]{"count(*)"} : returningColumns;
            if (needsReturningWrapper) {
                this.applyQueryReturning(sqlSb, statementType, withClause, columns);
            } else {
                this.applyQueryReturning(sqlSb, statementType, withClause, columns);
            }
            if (addParenthesis) {
                sqlSb.append(')');
            }
            return null;
        }
        if (addParenthesis) {
            sqlSb.insert(0, '(');
        }
        if (withClause != null) {
            sqlSb.insert(SqlUtils.SELECT_FINDER.indexIn(sqlSb, 0, sqlSb.length()), withClause);
        }
        if (limit != null) {
            this.appendLimit(sqlSb, isSubquery, limit, offset);
        }
        if (addParenthesis) {
            sqlSb.append(')');
        }
        return null;
    }

    @Override
    public DbmsLimitHandler createLimitHandler() {
        if (this.isCompatibilityVectorMYS()) {
            return super.createLimitHandler();
        }
        return new DB2DbmsLimitHandler();
    }

    protected boolean isCompatibilityVectorMYS() {
        return false;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public void appendOrderByElement(StringBuilder sqlSb, OrderByElement element, String[] aliases) {
        if (!element.isNullable() || element.isNullsFirst() && !element.isAscending() || !element.isNullsFirst() && element.isAscending()) {
            super.appendOrderByElement(sqlSb, element, aliases);
        } else {
            this.appendEmulatedOrderByElementWithNulls(sqlSb, element, aliases);
        }
    }

    private void applyQueryReturning(StringBuilder sqlSb, DbmsStatementType statementType, StringBuilder withClause, String[] returningColumns) {
        int initial = withClause != null ? withClause.length() : 0;
        StringBuilder sb = new StringBuilder(initial + 25 + returningColumns.length * 20);
        if (withClause != null) {
            sb.append((CharSequence)withClause);
        }
        sb.append("select ");
        for (int i = 0; i < returningColumns.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(returningColumns[i]);
            sb.append(" as ret_col_");
            sb.append(i);
        }
        sb.append(" from ");
        if (statementType == DbmsStatementType.DELETE) {
            sb.append("old");
        } else {
            sb.append("final");
        }
        sb.append(" table (");
        sqlSb.insert(0, sb);
        sqlSb.append(')');
    }

    private static int indexOfOrEnd(StringBuilder sb, char needle, int startIndex, int endIndex) {
        while (startIndex < endIndex) {
            if (sb.charAt(startIndex) == needle) {
                return startIndex;
            }
            ++startIndex;
        }
        return endIndex;
    }
}

