/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.WindowBuilder;
import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.WindowBuilderImpl;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import com.blazebit.persistence.parser.expression.WindowFrameExclusionType;
import com.blazebit.persistence.parser.expression.WindowFramePositionType;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WindowManager<T>
extends AbstractManager<ExpressionModifier> {
    private final Map<String, WindowDefinition> windows = new LinkedHashMap<String, WindowDefinition>(0);
    private QueryContext queryContext;
    private WindowBuilder<T> windowBuilder;

    public WindowManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory) {
        super(queryGenerator, parameterManager, subqueryInitFactory);
    }

    @Override
    public void apply(ExpressionModifierVisitor<? super ExpressionModifier> visitor) {
    }

    public WindowDefinition resolve(WindowDefinition windowDefinition) {
        if (windowDefinition.getWindowName() == null) {
            return windowDefinition;
        }
        WindowDefinition baseWindowDefinition = this.windows.get(windowDefinition.getWindowName());
        if (baseWindowDefinition == null) {
            throw new IllegalArgumentException("There is no window named '" + windowDefinition.getWindowName() + "' registered!");
        }
        if (!(baseWindowDefinition.getFrameMode() == null || windowDefinition.getPartitionExpressions().isEmpty() && windowDefinition.getOrderByExpressions().isEmpty() && windowDefinition.getFrameMode() == null)) {
            throw new IllegalArgumentException("The base window '" + windowDefinition.getWindowName() + "' is not allowed to specify a frame clause when being reused!");
        }
        if (!windowDefinition.getPartitionExpressions().isEmpty()) {
            throw new IllegalArgumentException("A window referencing the base window '" + windowDefinition.getWindowName() + "' isn't allowed to specify it's own PARTITION BY clause!");
        }
        if (!windowDefinition.getOrderByExpressions().isEmpty() && !baseWindowDefinition.getOrderByExpressions().isEmpty()) {
            throw new IllegalArgumentException("A window referencing the base window '" + windowDefinition.getWindowName() + "' isn't allowed to specify it's own ORDER BY clause because the base window already has an ORDER BY clause!");
        }
        List partitionExpressions = baseWindowDefinition.getPartitionExpressions();
        List orderByExpressions = baseWindowDefinition.getOrderByExpressions();
        if (orderByExpressions.isEmpty()) {
            orderByExpressions = windowDefinition.getOrderByExpressions();
        }
        WindowDefinition frameClause = windowDefinition.getFrameMode() == null ? baseWindowDefinition : windowDefinition;
        return new WindowDefinition(null, partitionExpressions, orderByExpressions, windowDefinition.getFilterPredicate(), frameClause.getFrameMode(), frameClause.getFrameStartType(), frameClause.getFrameStartExpression(), frameClause.getFrameEndType(), frameClause.getFrameEndExpression(), frameClause.getFrameExclusionType());
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.WINDOW;
    }

    void applyFrom(WindowManager<?> windowManager, ExpressionCopyContext copyContext) {
        for (Map.Entry<String, WindowDefinition> entry : windowManager.windows.entrySet()) {
            WindowDefinition windowDefinition = entry.getValue();
            int size = windowDefinition.getPartitionExpressions().size();
            ArrayList<Expression> partitionExpressions = new ArrayList<Expression>(size);
            List expressions = windowDefinition.getPartitionExpressions();
            for (int i = 0; i < size; ++i) {
                Expression expr = ((Expression)expressions.get(i)).copy(copyContext);
                partitionExpressions.add(expr);
                this.parameterManager.collectParameterRegistrations(expr, ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
            }
            size = windowDefinition.getOrderByExpressions().size();
            ArrayList<OrderByItem> orderByExpressions = new ArrayList<OrderByItem>(size);
            for (int i = 0; i < size; ++i) {
                OrderByItem orderByItem = ((OrderByItem)windowDefinition.getOrderByExpressions().get(i)).copy(copyContext);
                orderByExpressions.add(orderByItem);
                this.parameterManager.collectParameterRegistrations(orderByItem.getExpression(), ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
            }
            Predicate filterPredicate = null;
            if (windowDefinition.getFilterPredicate() != null) {
                filterPredicate = windowDefinition.getFilterPredicate().copy(copyContext);
                this.parameterManager.collectParameterRegistrations((Expression)filterPredicate, ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
            }
            Expression frameStartExpression = null;
            if (windowDefinition.getFrameStartExpression() != null) {
                frameStartExpression = windowDefinition.getFrameStartExpression().copy(copyContext);
                this.parameterManager.collectParameterRegistrations(frameStartExpression, ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
            }
            Expression frameEndExpression = null;
            if (windowDefinition.getFrameEndExpression() != null) {
                frameEndExpression = windowDefinition.getFrameEndExpression().copy(copyContext);
                this.parameterManager.collectParameterRegistrations(frameEndExpression, ClauseType.WINDOW, this.subqueryInitFactory.getQueryBuilder());
            }
            this.windows.put(entry.getKey(), new WindowDefinition(entry.getKey(), partitionExpressions, orderByExpressions, filterPredicate, windowDefinition.getFrameMode(), windowDefinition.getFrameStartType(), frameStartExpression, windowDefinition.getFrameEndType(), frameEndExpression, windowDefinition.getFrameExclusionType()));
        }
    }

    QueryContext getQueryContext() {
        return this.queryContext;
    }

    public Map<String, WindowDefinition> getWindows() {
        return this.windows;
    }

    public void onBuilderEnded(String name, WindowDefinition windowDefinition) {
        this.windows.put(name, windowDefinition);
        this.windowBuilder = null;
    }

    void verifyBuilderEnded() {
        if (this.windowBuilder != null) {
            throw new BuilderChainingException("A window builder was not ended properly.");
        }
    }

    WindowBuilder<T> window(String name, T result) {
        this.windowBuilder = new WindowBuilderImpl<T>(this.queryGenerator, this.parameterManager, this.subqueryInitFactory, this.subqueryInitFactory.getQueryBuilder().expressionFactory, this, result, name);
        return this.windowBuilder;
    }

    public void buildWindow(StringBuilder sb) {
        if (this.windows.isEmpty()) {
            return;
        }
        sb.append(" WINDOW ");
        this.queryGenerator.setClauseType(ClauseType.WINDOW);
        this.queryGenerator.setQueryBuffer(sb);
        for (Map.Entry<String, WindowDefinition> entry : this.windows.entrySet()) {
            sb.append(entry.getKey()).append(" AS (");
            WindowDefinition windowDefinition = entry.getValue();
            boolean needsSpace = false;
            if (windowDefinition.getWindowName() != null) {
                sb.append(windowDefinition.getWindowName());
                needsSpace = true;
            }
            if (!windowDefinition.getPartitionExpressions().isEmpty()) {
                if (needsSpace) {
                    sb.append(' ');
                }
                needsSpace = true;
                sb.append("PARTITION BY ");
                for (Expression partitionExpression : windowDefinition.getPartitionExpressions()) {
                    this.queryGenerator.generate(partitionExpression);
                    sb.append(", ");
                }
                sb.setLength(sb.length() - 2);
            }
            if (!windowDefinition.getOrderByExpressions().isEmpty()) {
                if (needsSpace) {
                    sb.append(' ');
                }
                needsSpace = true;
                sb.append("ORDER BY ");
                for (OrderByItem orderByExpression : windowDefinition.getOrderByExpressions()) {
                    this.queryGenerator.generate(orderByExpression.getExpression());
                    if (orderByExpression.isAscending()) {
                        sb.append(" ASC ");
                    } else {
                        sb.append(" DESC ");
                    }
                    if (orderByExpression.isNullFirst()) {
                        sb.append("NULLS FIRST, ");
                        continue;
                    }
                    sb.append("NULLS LAST, ");
                }
                sb.setLength(sb.length() - 2);
            }
            if (windowDefinition.getFrameMode() != null) {
                if (needsSpace) {
                    sb.append(' ');
                }
                sb.append(windowDefinition.getFrameMode().name());
                if (windowDefinition.getFrameEndType() != null) {
                    sb.append(" BETWEEN");
                }
                if (windowDefinition.getFrameStartExpression() != null) {
                    sb.append(' ');
                    this.queryGenerator.generate(windowDefinition.getFrameStartExpression());
                }
                sb.append(this.getFrameType(windowDefinition.getFrameStartType()));
                if (windowDefinition.getFrameEndType() != null) {
                    sb.append(" AND");
                    if (windowDefinition.getFrameEndExpression() != null) {
                        sb.append(' ');
                        this.queryGenerator.generate(windowDefinition.getFrameEndExpression());
                    }
                    sb.append(this.getFrameType(windowDefinition.getFrameEndType()));
                }
                if (windowDefinition.getFrameExclusionType() != null) {
                    sb.append(this.getFrameExclusionType(windowDefinition.getFrameExclusionType()));
                }
            }
            sb.append("), ");
        }
        sb.setLength(sb.length() - 2);
        this.queryGenerator.setClauseType(null);
    }

    protected String getFrameExclusionType(WindowFrameExclusionType frameExclusionType) {
        switch (frameExclusionType) {
            case EXCLUDE_CURRENT_ROW: {
                return " EXCLUDE CURRENT ROW";
            }
            case EXCLUDE_GROUP: {
                return " EXCLUDE GROUP";
            }
            case EXCLUDE_NO_OTHERS: {
                return " EXCLUDE NO OTHERS";
            }
            case EXCLUDE_TIES: {
                return " EXCLUDE TIES";
            }
        }
        throw new IllegalArgumentException("No branch for " + frameExclusionType);
    }

    protected String getFrameType(WindowFramePositionType frameStartType) {
        switch (frameStartType) {
            case CURRENT_ROW: {
                return " CURRENT ROW";
            }
            case BOUNDED_FOLLOWING: {
                return " FOLLOWING";
            }
            case BOUNDED_PRECEDING: {
                return " PRECEDING";
            }
            case UNBOUNDED_FOLLOWING: {
                return " UNBOUNDED FOLLOWING";
            }
            case UNBOUNDED_PRECEDING: {
                return " UNBOUNDED PRECEDING";
            }
        }
        throw new IllegalArgumentException("No branch for " + frameStartType);
    }
}

