/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.spi.OrderByElement;

public class DefaultOrderByElement
implements OrderByElement {
    private final String name;
    private final int position;
    private final boolean ascending;
    private final boolean nullable;
    private final boolean nullsFirst;

    public DefaultOrderByElement(String name, int position, boolean ascending, boolean nullable, boolean nullsFirst) {
        this.name = name;
        this.position = position;
        this.ascending = ascending;
        this.nullable = nullable;
        this.nullsFirst = nullsFirst;
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isNullsFirst() {
        return this.nullsFirst;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20);
        sb.append(this.position);
        if (this.ascending) {
            sb.append(" ASC");
        } else {
            sb.append(" DESC");
        }
        if (this.nullable) {
            if (this.nullsFirst) {
                sb.append(" NULLS FIRST");
            } else {
                sb.append(" NULLS LAST");
            }
        }
        return sb.toString();
    }

    public static OrderByElement fromString(String string, int startIndex, int endIndex) {
        int spaceIndex = string.indexOf(32, startIndex);
        int pos = Integer.parseInt(string.substring(startIndex, spaceIndex));
        boolean asc = string.charAt(spaceIndex + 1) == 'A';
        int lastSpaceIndex = string.lastIndexOf(32, endIndex);
        if (spaceIndex == lastSpaceIndex) {
            return new DefaultOrderByElement(null, pos, asc, false, false);
        }
        boolean nullFirst = string.charAt(lastSpaceIndex + 1) == 'F';
        return new DefaultOrderByElement(null, pos, asc, true, nullFirst);
    }
}

