/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.text;

import com.blazebit.text.AbstractFormat;
import com.blazebit.text.ParserContext;
import java.io.Serializable;
import java.lang.reflect.Method;

public class YearFormat
extends AbstractFormat {
    private static final long serialVersionUID = 1L;
    private static final Class<?> YEAR_CLASS;
    private static final Method PARSE_METHOD;

    public YearFormat() {
        super(YEAR_CLASS);
    }

    @Override
    public Serializable parse(String value, ParserContext context) {
        try {
            return (Serializable)PARSE_METHOD.invoke(null, value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static {
        try {
            YEAR_CLASS = Class.forName("java.time.Year");
            PARSE_METHOD = YEAR_CLASS.getMethod("parse", CharSequence.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

