/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.text;

import com.blazebit.text.AbstractFormat;
import com.blazebit.text.ParserContext;
import java.io.Serializable;
import java.lang.reflect.Method;

public class DurationFormat
extends AbstractFormat {
    private static final long serialVersionUID = 1L;
    private static final Class<?> DURATION_CLASS;
    private static final Method PARSE_METHOD;

    public DurationFormat() {
        super(DURATION_CLASS);
    }

    @Override
    public Serializable parse(String value, ParserContext context) {
        try {
            return (Serializable)PARSE_METHOD.invoke(null, value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static {
        try {
            DURATION_CLASS = Class.forName("java.time.Duration");
            PARSE_METHOD = DURATION_CLASS.getMethod("parse", CharSequence.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

