/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.reflection;

import com.blazebit.reflection.ExpressionUtils;
import com.blazebit.reflection.LazyGetterMethod;
import com.blazebit.reflection.PropertyPathExpression;
import java.lang.reflect.InvocationTargetException;

public class LazySetterMethod {
    private final Object target;
    private final Object value;
    private final PropertyPathExpression<Object, Object> expression;

    public LazySetterMethod(Object target, String fieldNames, Object value) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        this.target = target;
        this.value = value;
        this.expression = ExpressionUtils.getExpression(target.getClass(), fieldNames);
    }

    public LazySetterMethod(Object target, String fieldNames, LazyGetterMethod value) {
        this(target, fieldNames, (Object)value);
    }

    public void invoke() throws InvocationTargetException, IllegalAccessException {
        Object valueToPass = this.value;
        if (valueToPass != null && valueToPass instanceof LazyGetterMethod) {
            valueToPass = ((LazyGetterMethod)valueToPass).invoke();
        }
        this.expression.setValue(this.target, valueToPass);
    }
}

