/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.comparator;

import com.blazebit.comparator.BaseComparator;
import java.text.Collator;
import java.util.Locale;

public class StringComparator
extends BaseComparator<Object> {
    private final Collator collator;

    public StringComparator(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null !!!");
        }
        this.collator = Collator.getInstance(locale);
    }

    public StringComparator() {
        this(Locale.getDefault());
    }

    @Override
    public int compare(Object object1, Object object2) {
        try {
            Integer result = this.compareNullObjects(object1, object2);
            if (result == null) {
                result = this.collator.compare(object1 instanceof String ? (String)object1 : object1.toString(), object2 instanceof String ? (String)object2 : object2.toString());
            }
            return result;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Could not compare !!! object1: " + object1 + " / object2: " + object2, e);
        }
    }
}

