/*
 * Decompiled with CFR 0.152.
 */
package com.blade.patchca;

import com.blade.kit.StringKit;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.http.wrapper.Session;
import com.blade.patchca.Patchca;
import com.blade.patchca.PatchcaException;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.patchca.color.ColorFactory;
import org.patchca.filter.FilterFactory;
import org.patchca.filter.predefined.DiffuseRippleFilterFactory;
import org.patchca.service.ConfigurableCaptchaService;
import org.patchca.utils.encoder.EncoderHelper;
import org.patchca.word.RandomWordFactory;
import org.patchca.word.WordFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPatchca
implements Patchca {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPatchca.class);
    private ConfigurableCaptchaService cs = new ConfigurableCaptchaService();
    private static Random random = new Random();
    private RandomWordFactory wf;

    public DefaultPatchca() {
        this(new ColorFactory(){

            @Override
            public Color getColor(int x) {
                int[] c = new int[3];
                int i = random.nextInt(c.length);
                for (int fi = 0; fi < c.length; ++fi) {
                    c[fi] = fi == i ? random.nextInt(71) : random.nextInt(256);
                }
                return new Color(c[0], c[1], c[2]);
            }
        });
    }

    public DefaultPatchca(ColorFactory colorFactory) {
        this.cs.setColorFactory(colorFactory);
        this.wf = new RandomWordFactory();
        this.wf.setCharacters("23456789abcdefghigkmnpqrstuvwxyzABCDEFGHIGKLMNPQRSTUVWXYZ");
        this.wf.setMinLength(4);
        this.wf.setMaxLength(6);
        this.cs.setWordFactory(this.wf);
        this.cs.setFilterFactory(new DiffuseRippleFilterFactory());
    }

    @Override
    public Patchca length(int lenth) {
        this.wf.setMaxLength(lenth);
        this.wf.setMinLength(lenth);
        this.cs.setWordFactory(this.wf);
        return this;
    }

    @Override
    public Patchca length(int min, int max) {
        this.wf.setMinLength(min);
        this.wf.setMaxLength(max);
        this.cs.setWordFactory(this.wf);
        return this;
    }

    @Override
    public Patchca size(int width, int height) {
        this.cs.setWidth(width);
        this.cs.setHeight(height);
        return this;
    }

    @Override
    public Patchca color(ColorFactory colorFactory) {
        this.cs.setColorFactory(colorFactory);
        return this;
    }

    @Override
    public Patchca word(WordFactory wordFactory) {
        this.cs.setWordFactory(wordFactory);
        return this;
    }

    @Override
    public Patchca filter(FilterFactory filterFactory) {
        this.cs.setFilterFactory(filterFactory);
        return this;
    }

    @Override
    public void render(Request request, Response response) throws PatchcaException {
        this.render(request, response, "patchca");
    }

    @Override
    public void render(Request request, Response response, String patchca) throws PatchcaException {
        try {
            Session session = request.session();
            this.setResponseHeaders(response);
            OutputStream out = response.outputStream();
            String token = EncoderHelper.getChallangeAndWriteImage(this.cs, "png", out);
            session.attribute(patchca, (Object)token);
            out.flush();
            out.close();
            LOGGER.debug("current sessionid = [{}], token = [{}]", (Object)session.id(), (Object)token);
        }
        catch (IOException e) {
            throw new PatchcaException(e);
        }
    }

    private void setResponseHeaders(Response response) {
        response.contentType("image/png");
        response.header("Cache-Control", "no-cache, no-store");
        response.header("Pragma", "no-cache");
        long time = System.currentTimeMillis();
        response.header("Last-Modified", time + "");
        response.header("Date", time + "");
        response.header("Expires", time + "");
    }

    @Override
    public boolean validation(String patchca, Response response) {
        return this.validation(patchca, "png", response);
    }

    @Override
    public boolean validation(String patchca, String imgType, Response response) {
        try {
            String token = EncoderHelper.getChallangeAndWriteImage(this.cs, imgType, response.outputStream());
            if (StringKit.isBlank((String)patchca)) {
                return false;
            }
            return token.equalsIgnoreCase(patchca);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String token(String imgType, Response response) throws PatchcaException {
        try {
            return EncoderHelper.getChallangeAndWriteImage(this.cs, imgType, response.outputStream());
        }
        catch (IOException e) {
            throw new PatchcaException(e);
        }
    }

    @Override
    public String token(Response response) throws PatchcaException {
        try {
            String token = EncoderHelper.getChallangeAndWriteImage(this.cs, "png", response.outputStream());
            return token;
        }
        catch (IOException e) {
            throw new PatchcaException(e);
        }
    }

    @Override
    public File create(String imgPath, String imgType) throws PatchcaException {
        try {
            FileOutputStream fos = new FileOutputStream(imgPath);
            EncoderHelper.getChallangeAndWriteImage(this.cs, imgType, fos);
            fos.close();
            return new File(imgPath);
        }
        catch (FileNotFoundException e) {
            throw new PatchcaException(e);
        }
        catch (IOException e) {
            throw new PatchcaException(e);
        }
    }
}

