/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import weibo4j.http.Response;
import weibo4j.model.StatusWapper;
import weibo4j.model.User;
import weibo4j.model.Visible;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;

public class Status
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = -8795691786466526420L;
    private JSONObject json;
    private Date createdAt;
    private Long id;
    private String mid;
    private String idstr;
    private String text;
    private String source;
    private boolean favorited;
    private boolean truncated;
    private String inReplyToStatusId;
    private String inReplyToUserId;
    private String inReplyToScreenName;
    private String thumbnailPic;
    private String bmiddlePic;
    private String originalPic;
    private User user = null;
    private Status retweetedStatus;
    private int repostsCount;
    private int commentsCount;
    private int attitudesCount;
    private int mlevel;
    private Visible visible;

    public Status() {
    }

    public Status(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.constructJson(json);
    }

    private void constructJson(JSONObject json) throws WeiboException {
        try {
            this.json = json;
            this.createdAt = Status.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.id = json.getLong("id");
            this.mid = json.getString("mid");
            this.idstr = json.getString("idstr");
            this.text = json.getString("text");
            this.source = json.getString("source");
            this.favorited = Status.getBoolean("favorited", json);
            this.truncated = Status.getBoolean("truncated", json);
            this.inReplyToStatusId = json.getString("in_reply_to_status_id");
            this.inReplyToUserId = json.getString("in_reply_to_user_id");
            this.inReplyToScreenName = json.getString("in_reply_to_screen_name");
            this.thumbnailPic = json.optString("thumbnail_pic");
            this.bmiddlePic = json.optString("bmiddle_pic");
            this.originalPic = json.optString("original_pic");
            if (!json.isNull("user")) {
                this.user = new User(json.getJSONObject("user"));
            }
            if (!json.isNull("retweeted_status")) {
                this.retweetedStatus = new Status(json.getJSONObject("retweeted_status"));
            }
            this.repostsCount = json.getInt("reposts_count");
            this.commentsCount = json.getInt("comments_count");
            this.attitudesCount = json.getInt("attitudes_count");
            this.mlevel = json.getInt("mlevel");
            if (!json.isNull("visible")) {
                this.visible = new Visible(json.getJSONObject("visible"));
            }
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), (Exception)((Object)je));
        }
    }

    public Status(JSONObject json) throws WeiboException, JSONException {
        this.constructJson(json);
    }

    public Status(String str) throws WeiboException, JSONException {
        JSONObject json = new JSONObject(str);
        this.constructJson(json);
    }

    public static StatusWapper constructWapperStatus(Response res) throws WeiboException {
        JSONObject jsonStatus = res.asJSONObject();
        JSONArray statuses = null;
        try {
            if (!jsonStatus.isNull("statuses")) {
                statuses = jsonStatus.getJSONArray("statuses");
            }
            if (!jsonStatus.isNull("reposts")) {
                statuses = jsonStatus.getJSONArray("reposts");
            }
            int size = statuses.length();
            ArrayList<Status> status = new ArrayList<Status>(size);
            for (int i = 0; i < size; ++i) {
                status.add(new Status(statuses.getJSONObject(i)));
            }
            long previousCursor = jsonStatus.getLong("previous_curosr");
            long nextCursor = jsonStatus.getLong("next_cursor");
            long totalNumber = jsonStatus.getLong("total_number");
            String hasvisible = jsonStatus.getString("hasvisible");
            return new StatusWapper(status, previousCursor, nextCursor, totalNumber, hasvisible);
        }
        catch (JSONException jsone) {
            throw new WeiboException((Exception)((Object)jsone));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Status other = (Status)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.json.toString();
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMid() {
        return this.mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public String getIdstr() {
        return this.idstr;
    }

    public void setIdstr(String idstr) {
        this.idstr = idstr;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean isFavorited() {
        return this.favorited;
    }

    public void setFavorited(boolean favorited) {
        this.favorited = favorited;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public void setTruncated(boolean truncated) {
        this.truncated = truncated;
    }

    public String getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public void setInReplyToStatusId(String inReplyToStatusId) {
        this.inReplyToStatusId = inReplyToStatusId;
    }

    public String getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public void setInReplyToUserId(String inReplyToUserId) {
        this.inReplyToUserId = inReplyToUserId;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public void setInReplyToScreenName(String inReplyToScreenName) {
        this.inReplyToScreenName = inReplyToScreenName;
    }

    public String getThumbnailPic() {
        return this.thumbnailPic;
    }

    public void setThumbnailPic(String thumbnailPic) {
        this.thumbnailPic = thumbnailPic;
    }

    public String getBmiddlePic() {
        return this.bmiddlePic;
    }

    public void setBmiddlePic(String bmiddlePic) {
        this.bmiddlePic = bmiddlePic;
    }

    public String getOriginalPic() {
        return this.originalPic;
    }

    public void setOriginalPic(String originalPic) {
        this.originalPic = originalPic;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Status getRetweetedStatus() {
        return this.retweetedStatus;
    }

    public void setRetweetedStatus(Status retweetedStatus) {
        this.retweetedStatus = retweetedStatus;
    }

    public int getRepostsCount() {
        return this.repostsCount;
    }

    public void setRepostsCount(int repostsCount) {
        this.repostsCount = repostsCount;
    }

    public int getCommentsCount() {
        return this.commentsCount;
    }

    public void setCommentsCount(int commentsCount) {
        this.commentsCount = commentsCount;
    }

    public int getAttitudesCount() {
        return this.attitudesCount;
    }

    public void setAttitudesCount(int attitudesCount) {
        this.attitudesCount = attitudesCount;
    }

    public int getMlevel() {
        return this.mlevel;
    }

    public void setMlevel(int mlevel) {
        this.mlevel = mlevel;
    }

    public Visible getVisible() {
        return this.visible;
    }

    public void setVisible(Visible visible) {
        this.visible = visible;
    }
}

