/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import weibo4j.http.Response;
import weibo4j.model.Status;
import weibo4j.model.UserWapper;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;

public class User
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = -332738032648843482L;
    private String id;
    private String screenName;
    private String name;
    private int province;
    private int city;
    private String location;
    private String description;
    private String url;
    private String profileImageUrl;
    private String userDomain;
    private String gender;
    private int followersCount;
    private int friendsCount;
    private int statusesCount;
    private int favouritesCount;
    private Date createdAt;
    private boolean following;
    private boolean verified;
    private int verifiedType;
    private boolean allowAllActMsg;
    private boolean allowAllComment;
    private boolean followMe;
    private String avatarLarge;
    private int onlineStatus;
    private Status status = null;
    private int biFollowersCount;
    private String remark;
    private String lang;
    private String verifiedReason;
    private String weihao;
    private String statusId;

    public String getVerified_reason() {
        return this.verifiedReason;
    }

    public void setVerified_reason(String verifiedReason) {
        this.verifiedReason = verifiedReason;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProvince(int province) {
        this.province = province;
    }

    public void setCity(int city) {
        this.city = city;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setProfileImageUrl(String profileImageUrl) {
        this.profileImageUrl = profileImageUrl;
    }

    public void setUserDomain(String userDomain) {
        this.userDomain = userDomain;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setFollowersCount(int followersCount) {
        this.followersCount = followersCount;
    }

    public void setFriendsCount(int friendsCount) {
        this.friendsCount = friendsCount;
    }

    public void setStatusesCount(int statusesCount) {
        this.statusesCount = statusesCount;
    }

    public void setFavouritesCount(int favouritesCount) {
        this.favouritesCount = favouritesCount;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setFollowing(boolean following) {
        this.following = following;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public void setVerifiedType(int verifiedType) {
        this.verifiedType = verifiedType;
    }

    public void setAllowAllActMsg(boolean allowAllActMsg) {
        this.allowAllActMsg = allowAllActMsg;
    }

    public void setAllowAllComment(boolean allowAllComment) {
        this.allowAllComment = allowAllComment;
    }

    public void setFollowMe(boolean followMe) {
        this.followMe = followMe;
    }

    public void setAvatarLarge(String avatarLarge) {
        this.avatarLarge = avatarLarge;
    }

    public void setOnlineStatus(int onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setBiFollowersCount(int biFollowersCount) {
        this.biFollowersCount = biFollowersCount;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getWeihao() {
        return this.weihao;
    }

    public void setWeihao(String weihao) {
        this.weihao = weihao;
    }

    public String getVerifiedReason() {
        return this.verifiedReason;
    }

    public void setVerifiedReason(String verifiedReason) {
        this.verifiedReason = verifiedReason;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProfileImageUrl() {
        return this.profileImageUrl;
    }

    public int getVerifiedType() {
        return this.verifiedType;
    }

    public boolean isAllowAllActMsg() {
        return this.allowAllActMsg;
    }

    public boolean isAllowAllComment() {
        return this.allowAllComment;
    }

    public boolean isFollowMe() {
        return this.followMe;
    }

    public String getAvatarLarge() {
        return this.avatarLarge;
    }

    public int getOnlineStatus() {
        return this.onlineStatus;
    }

    public int getBiFollowersCount() {
        return this.biFollowersCount;
    }

    public User(JSONObject json) throws WeiboException {
        this.init(json);
    }

    private void init(JSONObject json) throws WeiboException {
        if (json != null) {
            try {
                this.id = json.getString("id");
                this.screenName = json.getString("screen_name");
                this.name = json.getString("name");
                this.province = json.getInt("province");
                this.city = json.getInt("city");
                this.location = json.getString("location");
                this.description = json.getString("description");
                this.url = json.getString("url");
                this.profileImageUrl = json.getString("profile_image_url");
                this.userDomain = json.getString("domain");
                this.gender = json.getString("gender");
                this.followersCount = json.getInt("followers_count");
                this.friendsCount = json.getInt("friends_count");
                this.favouritesCount = json.getInt("favourites_count");
                this.statusesCount = json.getInt("statuses_count");
                this.createdAt = User.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
                this.following = User.getBoolean("following", json);
                this.verified = User.getBoolean("verified", json);
                this.verifiedType = json.getInt("verified_type");
                this.verifiedReason = json.getString("verified_reason");
                this.allowAllActMsg = json.getBoolean("allow_all_act_msg");
                this.allowAllComment = json.getBoolean("allow_all_comment");
                this.followMe = json.getBoolean("follow_me");
                this.avatarLarge = json.getString("avatar_large");
                this.onlineStatus = json.getInt("online_status");
                this.statusId = json.getString("status_id");
                this.biFollowersCount = json.getInt("bi_followers_count");
                if (!json.getString("remark").isEmpty()) {
                    this.remark = json.getString("remark");
                }
                this.lang = json.getString("lang");
                this.weihao = json.getString("weihao");
                if (!json.isNull("status")) {
                    this.status = new Status(json.getJSONObject("status"));
                }
            }
            catch (JSONException jsone) {
                throw new WeiboException(jsone.getMessage() + ":" + json.toString(), (Exception)((Object)jsone));
            }
        }
    }

    public static String[] constructIds(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONObject().getJSONArray("ids");
            String temp = list.toString().substring(1, list.toString().length() - 1);
            String[] ids = temp.split(",");
            return ids;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone.getMessage() + ":" + jsone.toString(), (Exception)((Object)jsone));
        }
    }

    public static UserWapper constructWapperUsers(Response res) throws WeiboException {
        JSONObject jsonUsers = res.asJSONObject();
        try {
            JSONArray user = jsonUsers.getJSONArray("users");
            int size = user.length();
            ArrayList<User> users = new ArrayList<User>(size);
            for (int i = 0; i < size; ++i) {
                users.add(new User(user.getJSONObject(i)));
            }
            long previousCursor = jsonUsers.getLong("previous_curosr");
            long nextCursor = jsonUsers.getLong("next_cursor");
            long totalNumber = jsonUsers.getLong("total_number");
            String hasvisible = jsonUsers.getString("hasvisible");
            return new UserWapper(users, previousCursor, nextCursor, totalNumber, hasvisible);
        }
        catch (JSONException jsone) {
            throw new WeiboException((Exception)((Object)jsone));
        }
    }

    static List<User> constructResult(Response res) throws WeiboException {
        JSONArray list = res.asJSONArray();
        try {
            int size = list.length();
            ArrayList<User> users = new ArrayList<User>(size);
            for (int i = 0; i < size; ++i) {
                users.add(new User(list.getJSONObject(i)));
            }
            return users;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public String getName() {
        return this.name;
    }

    public int getProvince() {
        return this.province;
    }

    public int getCity() {
        return this.city;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getProfileImageURL() {
        try {
            return new URL(this.profileImageUrl);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public String getUserDomain() {
        return this.userDomain;
    }

    public String getGender() {
        return this.gender;
    }

    public int getFollowersCount() {
        return this.followersCount;
    }

    public int getFriendsCount() {
        return this.friendsCount;
    }

    public int getStatusesCount() {
        return this.statusesCount;
    }

    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public boolean isFollowing() {
        return this.following;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public int getverifiedType() {
        return this.verifiedType;
    }

    public boolean isallowAllActMsg() {
        return this.allowAllActMsg;
    }

    public boolean isallowAllComment() {
        return this.allowAllComment;
    }

    public boolean isfollowMe() {
        return this.followMe;
    }

    public String getavatarLarge() {
        return this.avatarLarge;
    }

    public int getonlineStatus() {
        return this.onlineStatus;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getbiFollowersCount() {
        return this.biFollowersCount;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getLang() {
        return this.lang;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "User [id=" + this.id + ", screenName=" + this.screenName + ", name=" + this.name + ", province=" + this.province + ", city=" + this.city + ", location=" + this.location + ", description=" + this.description + ", url=" + this.url + ", profileImageUrl=" + this.profileImageUrl + ", userDomain=" + this.userDomain + ", gender=" + this.gender + ", followersCount=" + this.followersCount + ", friendsCount=" + this.friendsCount + ", statusesCount=" + this.statusesCount + ", favouritesCount=" + this.favouritesCount + ", createdAt=" + this.createdAt + ", following=" + this.following + ", verified=" + this.verified + ", verifiedType=" + this.verifiedType + ", allowAllActMsg=" + this.allowAllActMsg + ", allowAllComment=" + this.allowAllComment + ", followMe=" + this.followMe + ", avatarLarge=" + this.avatarLarge + ", onlineStatus=" + this.onlineStatus + ", status=" + this.status + ", biFollowersCount=" + this.biFollowersCount + ", remark=" + this.remark + ", lang=" + this.lang + ", verifiedReason=" + this.verifiedReason + ", weihao=" + this.weihao + ", statusId=" + this.statusId + "]";
    }
}

