/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import weibo4j.http.Response;
import weibo4j.model.CommentWapper;
import weibo4j.model.Status;
import weibo4j.model.User;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;

public class Comment
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 1272011191310628589L;
    private Date createdAt;
    private long id;
    private String mid;
    private String idstr;
    private String text;
    private String source;
    private Comment replycomment = null;
    private User user = null;
    private Status status = null;

    public Comment(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.id = json.getLong("id");
            this.mid = json.getString("mid");
            this.idstr = json.getString("idstr");
            this.text = json.getString("text");
            this.source = json.getString("source");
            this.createdAt = Comment.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            if (!json.isNull("user")) {
                this.user = new User(json.getJSONObject("user"));
            }
            if (!json.isNull("status")) {
                this.status = new Status(json.getJSONObject("status"));
            }
            if (!json.isNull("reply_comment")) {
                this.replycomment = new Comment(json.getJSONObject("reply_comment"));
            }
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), (Exception)((Object)je));
        }
    }

    public Comment(JSONObject json) throws WeiboException, JSONException {
        this.id = json.getLong("id");
        this.mid = json.getString("mid");
        this.idstr = json.getString("idstr");
        this.text = json.getString("text");
        this.source = json.getString("source");
        this.createdAt = Comment.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        if (!json.isNull("user")) {
            this.user = new User(json.getJSONObject("user"));
        }
        if (!json.isNull("status")) {
            this.status = new Status(json.getJSONObject("status"));
        }
        if (!json.isNull("reply_comment")) {
            this.replycomment = new Comment(json.getJSONObject("reply_comment"));
        }
    }

    public Comment(String str) throws WeiboException, JSONException {
        JSONObject json = new JSONObject(str);
        this.id = json.getLong("id");
        this.mid = json.getString("mid");
        this.idstr = json.getString("idstr");
        this.text = json.getString("text");
        this.source = json.getString("source");
        this.createdAt = Comment.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        if (!json.isNull("user")) {
            this.user = new User(json.getJSONObject("user"));
        }
        if (!json.isNull("status")) {
            this.status = new Status(json.getJSONObject("status"));
        }
        if (!json.isNull("reply_comment")) {
            this.replycomment = new Comment(json.getJSONObject("reply_comment"));
        }
    }

    public static CommentWapper constructWapperComments(Response res) throws WeiboException {
        JSONObject json = res.asJSONObject();
        try {
            JSONArray comments = json.getJSONArray("comments");
            int size = comments.length();
            ArrayList<Comment> comment = new ArrayList<Comment>(size);
            for (int i = 0; i < size; ++i) {
                comment.add(new Comment(comments.getJSONObject(i)));
            }
            long previousCursor = json.getLong("previous_curosr");
            long nextCursor = json.getLong("next_cursor");
            long totalNumber = json.getLong("total_number");
            String hasvisible = json.getString("hasvisible");
            return new CommentWapper(comment, previousCursor, nextCursor, totalNumber, hasvisible);
        }
        catch (JSONException jsone) {
            throw new WeiboException((Exception)((Object)jsone));
        }
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public long getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public Comment getReplycomment() {
        return this.replycomment;
    }

    public User getUser() {
        return this.user;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMid() {
        return this.mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public String getIdstr() {
        return this.idstr;
    }

    public void setIdstr(String idstr) {
        this.idstr = idstr;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setReplycomment(Comment replycomment) {
        this.replycomment = replycomment;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Comment other = (Comment)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "Comment [createdAt=" + this.createdAt + ", id=" + this.id + ", mid=" + this.mid + ", idstr=" + this.idstr + ", text=" + this.text + ", source=" + this.source + ", replycomment=" + this.replycomment + ", user=" + this.user + ", status=" + this.status + "]";
    }
}

