/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import weibo4j.Weibo;
import weibo4j.model.Paging;
import weibo4j.model.PostParameter;
import weibo4j.model.Tag;
import weibo4j.model.TagWapper;
import weibo4j.model.WeiboException;
import weibo4j.util.WeiboConfig;

public class Tags
extends Weibo {
    private static final long serialVersionUID = 7047254100483792467L;

    public List<Tag> getTags(String uid) throws WeiboException {
        return Tag.constructTags(this.client.get(WeiboConfig.getValue("baseURL") + "tags.json", new PostParameter[]{new PostParameter("uid", uid)}));
    }

    public List<Tag> getTags(String uid, Paging page) throws WeiboException {
        return Tag.constructTags(this.client.get(WeiboConfig.getValue("baseURL") + "tags.json", new PostParameter[]{new PostParameter("uid", uid)}, page));
    }

    public TagWapper getTagsBatch(String uids) throws WeiboException {
        return Tag.constructTagWapper(this.client.get(WeiboConfig.getValue("baseURL") + "tags/tags_batch.json", new PostParameter[]{new PostParameter("uids", uids)}));
    }

    public List<Tag> getTagsSuggestions() throws WeiboException {
        return Tag.constructTags(this.client.get(WeiboConfig.getValue("baseURL") + "tags/suggestions.json"));
    }

    public JSONArray createTags(String tags) throws WeiboException {
        return this.client.post(WeiboConfig.getValue("baseURL") + "tags/create.json", new PostParameter[]{new PostParameter("tags", tags)}).asJSONArray();
    }

    public JSONObject destoryTag(Integer tag_id) throws WeiboException {
        return this.client.post(WeiboConfig.getValue("baseURL") + "tags/destroy.json", new PostParameter[]{new PostParameter("tag_id", tag_id.toString())}).asJSONObject();
    }

    public List<Tag> destroyTagsBatch(String ids) throws WeiboException {
        return Tag.constructTags(this.client.post(WeiboConfig.getValue("baseURL") + "tags/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}));
    }
}

