/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.service.impl;

import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.enums.SqlMethod;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.SqlHelper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.MapUtils;
import com.baomidou.mybatisplus.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ServiceImpl<M extends BaseMapper<T>, T>
implements IService<T> {
    private static final Log logger = LogFactory.getLog(ServiceImpl.class);
    @Autowired
    protected M baseMapper;

    protected static boolean retBool(Integer result) {
        return SqlHelper.retBool(result);
    }

    protected Class<T> currentModleClass() {
        return ReflectionKit.getSuperClassGenricType(this.getClass(), 1);
    }

    protected SqlSession sqlSessionBatch() {
        return SqlHelper.sqlSessionBatch(this.currentModleClass());
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.table(this.currentModleClass()).getSqlStatement(sqlMethod.getMethod());
    }

    @Override
    @Transactional
    public boolean insert(T entity) {
        return ServiceImpl.retBool(this.baseMapper.insert(entity));
    }

    @Override
    @Transactional
    public boolean insertAllColumn(T entity) {
        return ServiceImpl.retBool(this.baseMapper.insertAllColumn(entity));
    }

    @Override
    @Transactional
    public boolean insertBatch(List<T> entityList) {
        return this.insertBatch(entityList, 30);
    }

    @Override
    @Transactional
    public boolean insertBatch(List<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = entityList.size();
            String sqlStatement = this.sqlStatement(SqlMethod.INSERT_ONE);
            for (int i = 0; i < size; ++i) {
                batchSqlSession.insert(sqlStatement, entityList.get(i));
                if (i < 1 || i % batchSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Exception e) {
            logger.error("Error: Cannot execute insertBatch Method. Cause:" + e);
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean insertOrUpdate(T entity) {
        if (null != entity) {
            Class<?> cls = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            if (null != tableInfo && StringUtils.isNotEmpty(tableInfo.getKeyProperty())) {
                Object idVal = ReflectionKit.getMethodValue(cls, entity, tableInfo.getKeyProperty());
                if (StringUtils.checkValNull(idVal)) {
                    return this.insert(entity);
                }
                return this.updateById(entity) || this.insert(entity);
            }
            throw new MybatisPlusException("Error:  Can not execute. Could not find @TableId.");
        }
        return false;
    }

    @Override
    @Transactional
    public boolean insertOrUpdateBatch(List<T> entityList) {
        return this.insertOrUpdateBatch(entityList, 30);
    }

    @Override
    @Transactional
    public boolean insertOrUpdateBatch(List<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = entityList.size();
            for (int i = 0; i < size; ++i) {
                this.insertOrUpdate(entityList.get(i));
                if (i < 1 || i % batchSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Exception e) {
            logger.error("Error: Cannot execute insertOrUpdateBatch Method. Cause:" + e);
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean deleteById(Serializable id) {
        return ServiceImpl.retBool(this.baseMapper.deleteById(id));
    }

    @Override
    @Transactional
    public boolean deleteByMap(Map<String, Object> columnMap) {
        if (MapUtils.isEmpty(columnMap)) {
            throw new MybatisPlusException("deleteByMap columnMap is empty.");
        }
        return ServiceImpl.retBool(this.baseMapper.deleteByMap(columnMap));
    }

    @Override
    @Transactional
    public boolean delete(Wrapper<T> wrapper) {
        return ServiceImpl.retBool(this.baseMapper.delete(wrapper));
    }

    @Override
    @Transactional
    public boolean deleteBatchIds(List<? extends Serializable> idList) {
        return ServiceImpl.retBool(this.baseMapper.deleteBatchIds(idList));
    }

    @Override
    @Transactional
    public boolean updateById(T entity) {
        return ServiceImpl.retBool(this.baseMapper.updateById(entity));
    }

    @Override
    @Transactional
    public boolean updateAllColumnById(T entity) {
        return ServiceImpl.retBool(this.baseMapper.updateAllColumnById(entity));
    }

    @Override
    @Transactional
    public boolean update(T entity, Wrapper<T> wrapper) {
        return ServiceImpl.retBool(this.baseMapper.update(entity, wrapper));
    }

    @Override
    @Transactional
    public boolean updateBatchById(List<T> entityList) {
        return this.updateBatchById(entityList, 30);
    }

    @Override
    @Transactional
    public boolean updateBatchById(List<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = entityList.size();
            String sqlStatement = this.sqlStatement(SqlMethod.UPDATE_BY_ID);
            for (int i = 0; i < size; ++i) {
                batchSqlSession.update(sqlStatement, entityList.get(i));
                if (i < 1 || i % batchSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Exception e) {
            logger.error("Error: Cannot execute insertBatch Method. Cause:" + e);
            return false;
        }
        return true;
    }

    @Override
    public T selectById(Serializable id) {
        return this.baseMapper.selectById(id);
    }

    @Override
    public List<T> selectBatchIds(List<? extends Serializable> idList) {
        return this.baseMapper.selectBatchIds(idList);
    }

    @Override
    public List<T> selectByMap(Map<String, Object> columnMap) {
        return this.baseMapper.selectByMap(columnMap);
    }

    @Override
    public T selectOne(Wrapper<T> wrapper) {
        return SqlHelper.getObject(this.baseMapper.selectList(wrapper));
    }

    @Override
    public Map<String, Object> selectMap(Wrapper<T> wrapper) {
        return SqlHelper.getObject(this.baseMapper.selectMaps(wrapper));
    }

    @Override
    public Object selectObj(Wrapper<T> wrapper) {
        return SqlHelper.getObject(this.baseMapper.selectObjs(wrapper));
    }

    @Override
    public int selectCount(Wrapper<T> wrapper) {
        return SqlHelper.retCount(this.baseMapper.selectCount(wrapper));
    }

    @Override
    public List<T> selectList(Wrapper<T> wrapper) {
        return this.baseMapper.selectList(wrapper);
    }

    @Override
    public Page<T> selectPage(Page<T> page) {
        return this.selectPage(page, Condition.EMPTY);
    }

    @Override
    public List<Map<String, Object>> selectMaps(Wrapper<T> wrapper) {
        return this.baseMapper.selectMaps(wrapper);
    }

    @Override
    public List<Object> selectObjs(Wrapper<T> wrapper) {
        return this.baseMapper.selectObjs(wrapper);
    }

    @Override
    public Page<Map<String, Object>> selectMapsPage(Page page, Wrapper<T> wrapper) {
        SqlHelper.fillWrapper(page, wrapper);
        page.setRecords(this.baseMapper.selectMapsPage(page, wrapper));
        return page;
    }

    @Override
    public Page<T> selectPage(Page<T> page, Wrapper<T> wrapper) {
        SqlHelper.fillWrapper(page, wrapper);
        page.setRecords(this.baseMapper.selectPage(page, wrapper));
        return page;
    }
}

