/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.mapper.SqlHelper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.transaction.annotation.Transactional;

public class SqlRunner {
    public static final String INSERT = "com.baomidou.mybatisplus.mapper.SqlRunner.Insert";
    public static final String DELETE = "com.baomidou.mybatisplus.mapper.SqlRunner.Delete";
    public static final String UPDATE = "com.baomidou.mybatisplus.mapper.SqlRunner.Update";
    public static final String SELECT_LIST = "com.baomidou.mybatisplus.mapper.SqlRunner.SelectList";
    public static final String SELECT_OBJS = "com.baomidou.mybatisplus.mapper.SqlRunner.SelectObjs";
    public static final String COUNT = "com.baomidou.mybatisplus.mapper.SqlRunner.Count";
    public static final String SQLScript = "${sql}";
    public static final String SQL = "sql";
    public static final SqlRunner DEFAULT = new SqlRunner();
    public static SqlSessionFactory FACTORY;
    private SqlSessionFactory sqlSessionFactory;
    private Class<?> clazz;

    public SqlRunner() {
        this.sqlSessionFactory = FACTORY;
    }

    public SqlRunner(Class<?> clazz) {
        this.clazz = clazz;
    }

    public static SqlRunner db() {
        if (SqlRunner.DEFAULT.sqlSessionFactory == null) {
            SqlRunner.DEFAULT.sqlSessionFactory = FACTORY;
        }
        return DEFAULT;
    }

    public static SqlRunner db(Class<?> clazz) {
        return new SqlRunner(clazz);
    }

    @Transactional
    public boolean insert(String sql, Object ... args) {
        try (SqlSession session = this.sqlSession();){
            boolean bl = SqlHelper.retBool(session.insert(INSERT, this.sqlMap(sql, args)));
            return bl;
        }
    }

    @Transactional
    public boolean delete(String sql, Object ... args) {
        try (SqlSession session = this.sqlSession();){
            boolean bl = SqlHelper.retBool(session.delete(DELETE, this.sqlMap(sql, args)));
            return bl;
        }
    }

    private Map<String, String> sqlMap(String sql, Object ... args) {
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        sqlMap.put(SQL, StringUtils.sqlArgsFill(sql, args));
        return sqlMap;
    }

    @Transactional
    public boolean update(String sql, Object ... args) {
        try (SqlSession session = this.sqlSession();){
            boolean bl = SqlHelper.retBool(session.update(UPDATE, this.sqlMap(sql, args)));
            return bl;
        }
    }

    public List<Map<String, Object>> selectList(String sql, Object ... args) {
        try (SqlSession session = this.sqlSession();){
            List list = session.selectList(SELECT_LIST, this.sqlMap(sql, args));
            return list;
        }
    }

    public List<Object> selectObjs(String sql, Object ... args) {
        try (SqlSession session = this.sqlSession();){
            List list = session.selectList(SELECT_OBJS, this.sqlMap(sql, args));
            return list;
        }
    }

    public Object selectObj(String sql, Object ... args) {
        return SqlHelper.getObject(this.selectObjs(sql, args));
    }

    public int selectCount(String sql, Object ... args) {
        try (SqlSession session = this.sqlSession();){
            int n = SqlHelper.retCount((Integer)session.selectOne(COUNT, this.sqlMap(sql, args)));
            return n;
        }
    }

    public Map<String, Object> selectOne(String sql, Object ... args) {
        return SqlHelper.getObject(this.selectList(sql, args));
    }

    public Page<Map<String, Object>> selectPage(Page page, String sql, Object ... args) {
        if (null == page) {
            return null;
        }
        try (SqlSession session = this.sqlSession();){
            page.setRecords(session.selectList(SELECT_LIST, this.sqlMap(sql, args), (RowBounds)page));
            Page page2 = page;
            return page2;
        }
    }

    private SqlSession sqlSession() {
        return this.clazz != null ? SqlHelper.sqlSession(this.clazz) : GlobalConfigUtils.getSqlSession(FACTORY.getConfiguration());
    }
}

