/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.jsqlparser.enums.ExpressionAppendMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;

public abstract class BaseMultiTableInnerInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private ExpressionAppendMode expressionAppendMode = ExpressionAppendMode.LAST;

    protected void processSelectBody(Select selectBody, String whereSegment) {
        SetOperationList operationList;
        List selectBodyList;
        if (selectBody == null) {
            return;
        }
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody, whereSegment);
        } else if (selectBody instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)selectBody;
            this.processSelectBody(parenthesedSelect.getSelect(), whereSegment);
        } else if (selectBody instanceof SetOperationList && CollectionUtils.isNotEmpty((Collection)(selectBodyList = (operationList = (SetOperationList)selectBody).getSelects()))) {
            selectBodyList.forEach(body -> this.processSelectBody((Select)body, whereSegment));
        }
    }

    protected Expression andExpression(Table table, Expression where, String whereSegment) {
        Expression expression = this.buildTableExpression(table, where, whereSegment);
        if (expression == null) {
            return where;
        }
        if (where != null) {
            if (where instanceof OrExpression) {
                return this.appendExpression((Expression)new Parenthesis(where), expression);
            }
            return this.appendExpression(where, expression);
        }
        return expression;
    }

    protected Expression appendExpression(Expression currentExpression, Expression injectExpression) {
        if (ExpressionAppendMode.LAST == this.expressionAppendMode || this.expressionAppendMode == null) {
            return new AndExpression(currentExpression, injectExpression);
        }
        return new AndExpression(injectExpression, currentExpression);
    }

    protected void processPlainSelect(PlainSelect plainSelect, String whereSegment) {
        List selectItems = plainSelect.getSelectItems();
        if (CollectionUtils.isNotEmpty((Collection)selectItems)) {
            selectItems.forEach(selectItem -> this.processSelectItem((SelectItem)selectItem, whereSegment));
        }
        Expression where = plainSelect.getWhere();
        this.processWhereSubSelect(where, whereSegment);
        FromItem fromItem = plainSelect.getFromItem();
        List<Table> list = this.processFromItem(fromItem, whereSegment);
        ArrayList<Table> mainTables = new ArrayList<Table>(list);
        List joins = plainSelect.getJoins();
        if (CollectionUtils.isNotEmpty((Collection)joins)) {
            this.processJoins(mainTables, joins, whereSegment);
        }
        if (CollectionUtils.isNotEmpty(mainTables)) {
            plainSelect.setWhere(this.builderExpression(where, mainTables, whereSegment));
        }
    }

    private List<Table> processFromItem(FromItem fromItem, String whereSegment) {
        ArrayList<Table> mainTables = new ArrayList<Table>();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            mainTables.add(fromTable);
        } else if (fromItem instanceof ParenthesedFromItem) {
            List<Table> tables = this.processSubJoin((ParenthesedFromItem)fromItem, whereSegment);
            mainTables.addAll(tables);
        } else {
            this.processOtherFromItem(fromItem, whereSegment);
        }
        return mainTables;
    }

    protected void processWhereSubSelect(Expression where, String whereSegment) {
        if (where == null) {
            return;
        }
        if (where instanceof FromItem) {
            this.processOtherFromItem((FromItem)where, whereSegment);
            return;
        }
        if (where.toString().indexOf("SELECT") > 0) {
            if (where instanceof BinaryExpression) {
                BinaryExpression expression = (BinaryExpression)where;
                this.processWhereSubSelect(expression.getLeftExpression(), whereSegment);
                this.processWhereSubSelect(expression.getRightExpression(), whereSegment);
            } else if (where instanceof InExpression) {
                InExpression expression = (InExpression)where;
                Expression inExpression = expression.getRightExpression();
                if (inExpression instanceof Select) {
                    this.processSelectBody((Select)inExpression, whereSegment);
                }
            } else if (where instanceof ExistsExpression) {
                ExistsExpression expression = (ExistsExpression)where;
                this.processWhereSubSelect(expression.getRightExpression(), whereSegment);
            } else if (where instanceof NotExpression) {
                NotExpression expression = (NotExpression)where;
                this.processWhereSubSelect(expression.getExpression(), whereSegment);
            } else if (where instanceof Parenthesis) {
                Parenthesis expression = (Parenthesis)where;
                this.processWhereSubSelect(expression.getExpression(), whereSegment);
            }
        }
    }

    protected void processSelectItem(SelectItem selectItem, String whereSegment) {
        Expression expression = selectItem.getExpression();
        if (expression instanceof Select) {
            this.processSelectBody((Select)expression, whereSegment);
        } else if (expression instanceof Function) {
            this.processFunction((Function)expression, whereSegment);
        } else if (expression instanceof ExistsExpression) {
            ExistsExpression existsExpression = (ExistsExpression)expression;
            this.processSelectBody((Select)existsExpression.getRightExpression(), whereSegment);
        }
    }

    protected void processFunction(Function function, String whereSegment) {
        ExpressionList parameters = function.getParameters();
        if (parameters != null) {
            parameters.forEach(expression -> {
                if (expression instanceof Select) {
                    this.processSelectBody((Select)expression, whereSegment);
                } else if (expression instanceof Function) {
                    this.processFunction((Function)expression, whereSegment);
                } else if (expression instanceof EqualsTo) {
                    if (((EqualsTo)expression).getLeftExpression() instanceof Select) {
                        this.processSelectBody((Select)((EqualsTo)expression).getLeftExpression(), whereSegment);
                    }
                    if (((EqualsTo)expression).getRightExpression() instanceof Select) {
                        this.processSelectBody((Select)((EqualsTo)expression).getRightExpression(), whereSegment);
                    }
                }
            });
        }
    }

    protected void processOtherFromItem(FromItem fromItem, String whereSegment) {
        while (fromItem instanceof ParenthesedFromItem) {
            fromItem = ((ParenthesedFromItem)fromItem).getFromItem();
        }
        if (fromItem instanceof ParenthesedSelect) {
            Select subSelect = (Select)fromItem;
            this.processSelectBody(subSelect, whereSegment);
        }
    }

    private List<Table> processSubJoin(ParenthesedFromItem subJoin, String whereSegment) {
        while (subJoin.getJoins() == null && subJoin.getFromItem() instanceof ParenthesedFromItem) {
            subJoin = (ParenthesedFromItem)subJoin.getFromItem();
        }
        List<Table> tableList = this.processFromItem(subJoin.getFromItem(), whereSegment);
        ArrayList<Table> mainTables = new ArrayList<Table>(tableList);
        if (subJoin.getJoins() != null) {
            this.processJoins(mainTables, subJoin.getJoins(), whereSegment);
        }
        return mainTables;
    }

    private List<Table> processJoins(List<Table> mainTables, List<Join> joins, String whereSegment) {
        Table mainTable = null;
        Table leftTable = null;
        if (mainTables.size() == 1) {
            leftTable = mainTable = mainTables.get(0);
        }
        LinkedList<List<Table>> onTableDeque = new LinkedList<List<Table>>();
        for (Join join : joins) {
            FromItem joinItem = join.getRightItem();
            List<Object> joinTables = null;
            if (joinItem instanceof Table) {
                joinTables = new ArrayList<Table>();
                joinTables.add((Table)joinItem);
            } else if (joinItem instanceof ParenthesedFromItem) {
                joinTables = this.processSubJoin((ParenthesedFromItem)joinItem, whereSegment);
            }
            if (joinTables != null && !joinTables.isEmpty()) {
                LinkedList<Expression> onExpressions;
                Collection originOnExpressions;
                if (join.isSimple()) {
                    mainTables.addAll(joinTables);
                    continue;
                }
                Table joinTable = (Table)joinTables.get(0);
                List<Table> onTables = null;
                if (join.isRight()) {
                    mainTable = joinTable;
                    mainTables.clear();
                    if (leftTable != null) {
                        onTables = Collections.singletonList(leftTable);
                    }
                } else if (join.isInner()) {
                    onTables = mainTable == null ? Collections.singletonList(joinTable) : Arrays.asList(mainTable, joinTable);
                    mainTable = null;
                    mainTables.clear();
                } else {
                    onTables = Collections.singletonList(joinTable);
                }
                if (mainTable != null && !mainTables.contains(mainTable)) {
                    mainTables.add(mainTable);
                }
                if ((originOnExpressions = join.getOnExpressions()).size() == 1 && onTables != null) {
                    onExpressions = new LinkedList<Expression>();
                    onExpressions.add(this.builderExpression((Expression)originOnExpressions.iterator().next(), onTables, whereSegment));
                    join.setOnExpressions(onExpressions);
                    leftTable = mainTable == null ? joinTable : mainTable;
                    continue;
                }
                onTableDeque.push(onTables);
                if (originOnExpressions.size() > 1) {
                    onExpressions = new LinkedList();
                    for (Expression originOnExpression : originOnExpressions) {
                        List currentTableList = (List)onTableDeque.poll();
                        if (CollectionUtils.isEmpty((Collection)currentTableList)) {
                            onExpressions.add(originOnExpression);
                            continue;
                        }
                        onExpressions.add(this.builderExpression(originOnExpression, currentTableList, whereSegment));
                    }
                    join.setOnExpressions(onExpressions);
                }
                leftTable = joinTable;
                continue;
            }
            this.processOtherFromItem(joinItem, whereSegment);
            leftTable = null;
        }
        return mainTables;
    }

    protected Expression builderExpression(Expression currentExpression, List<Table> tables, String whereSegment) {
        if (CollectionUtils.isEmpty(tables)) {
            return currentExpression;
        }
        List expressions = tables.stream().map(item -> this.buildTableExpression((Table)item, currentExpression, whereSegment)).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(expressions)) {
            return currentExpression;
        }
        Expression injectExpression = (Expression)expressions.get(0);
        if (expressions.size() > 1) {
            for (int i = 1; i < expressions.size(); ++i) {
                injectExpression = new AndExpression(injectExpression, (Expression)expressions.get(i));
            }
        }
        if (currentExpression == null) {
            return injectExpression;
        }
        if (currentExpression instanceof OrExpression) {
            return this.appendExpression((Expression)new Parenthesis(currentExpression), injectExpression);
        }
        return this.appendExpression(currentExpression, injectExpression);
    }

    public abstract Expression buildTableExpression(Table var1, Expression var2, String var3);

    public ExpressionAppendMode getExpressionAppendMode() {
        return this.expressionAppendMode;
    }

    public void setExpressionAppendMode(ExpressionAppendMode expressionAppendMode) {
        this.expressionAppendMode = expressionAppendMode;
    }

    public String toString() {
        return "BaseMultiTableInnerInterceptor(super=" + super.toString() + ", expressionAppendMode=" + this.getExpressionAppendMode() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseMultiTableInnerInterceptor)) {
            return false;
        }
        BaseMultiTableInnerInterceptor other = (BaseMultiTableInnerInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExpressionAppendMode this$expressionAppendMode = this.getExpressionAppendMode();
        ExpressionAppendMode other$expressionAppendMode = other.getExpressionAppendMode();
        return !(this$expressionAppendMode == null ? other$expressionAppendMode != null : !this$expressionAppendMode.equals(other$expressionAppendMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseMultiTableInnerInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ExpressionAppendMode $expressionAppendMode = this.getExpressionAppendMode();
        result = result * 59 + ($expressionAppendMode == null ? 43 : $expressionAppendMode.hashCode());
        return result;
    }
}

