/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;
import java.util.HashSet;
import java.util.Set;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.util.TablesNamesFinder;

public class DynamicTableNameHandler
extends TablesNamesFinder {
    private final String originSql;
    private final TableNameHandler tableNameHandler;
    private final Set<Table> set = new HashSet<Table>();

    public DynamicTableNameHandler(String originSql, TableNameHandler tableNameHandler) {
        this.originSql = originSql;
        this.tableNameHandler = tableNameHandler;
        this.init(false);
    }

    public void visit(CreateIndex createIndex) {
        super.visit(createIndex.getTable());
    }

    public void visit(Drop drop) {
        String type;
        if (StringUtils.isNotBlank((CharSequence)drop.getType()) && "TABLE".equals(type = drop.getType().toUpperCase())) {
            super.visit(drop);
        }
    }

    public void visit(CreateView createView) {
        super.visit(createView.getSelect());
    }

    protected String extractTableName(Table table) {
        String tableName;
        String originalTableName = table.getName();
        if (table.getASTNode() == null) {
            return originalTableName;
        }
        if (this.set.add(table) && StringUtils.isNotBlank((CharSequence)(tableName = this.tableNameHandler.dynamicTableName(this.originSql, originalTableName)))) {
            table.setName(tableName);
            return tableName;
        }
        return originalTableName;
    }
}

