/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AnnotationAttributes {
    private String displayName;
    private final Set<String> importPackages = new HashSet<String>();

    public AnnotationAttributes() {
    }

    public AnnotationAttributes(@NotNull Class<?> annotationClass) {
        this.displayName = "@" + annotationClass.getSimpleName();
        this.importPackages.add(annotationClass.getName());
    }

    public AnnotationAttributes(@NotNull Class<?> annotationClass, @NotNull String displayName, String ... extraPkg) {
        this.displayName = displayName;
        this.importPackages.add(annotationClass.getName());
        if (extraPkg != null && extraPkg.length > 0) {
            this.importPackages.addAll(Arrays.asList(extraPkg));
        }
    }

    public AnnotationAttributes(@NotNull String displayName, String ... importPackages) {
        this.displayName = displayName;
        this.importPackages.addAll(Arrays.asList(importPackages));
    }

    public void addImportPackage(@NotNull String importPackage) {
        this.importPackages.add(importPackage);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set<String> getImportPackages() {
        return this.importPackages;
    }

    public String toString() {
        return "AnnotationAttributes(displayName=" + this.getDisplayName() + ", importPackages=" + this.getImportPackages() + ")";
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

