/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.engine;

import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.TemplateLoadWay;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jetbrains.annotations.NotNull;

public class VelocityTemplateEngine
extends AbstractTemplateEngine {
    private VelocityEngine velocityEngine;

    public VelocityTemplateEngine() {
        try {
            Class.forName("org.apache.velocity.util.DuckType");
        }
        catch (ClassNotFoundException e) {
            this.LOGGER.warn("Velocity 1.x is outdated, please upgrade to 2.x or later.");
        }
    }

    @Override
    @NotNull
    public VelocityTemplateEngine init(@NotNull ConfigBuilder configBuilder) {
        if (null == this.velocityEngine) {
            Properties p = new Properties();
            p.setProperty("UTF-8", ConstVal.UTF8);
            p.setProperty("resource.default_encoding", ConstVal.UTF8);
            if (configBuilder.getTemplateLoadWay().isFile()) {
                p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
                p.setProperty("resource.loader.file.path", "");
                p.setProperty("file.resource.loader.unicode", "true");
            } else {
                p.setProperty("resource.loader", TemplateLoadWay.STRING.getValue());
            }
            this.velocityEngine = new VelocityEngine(p);
        }
        return this;
    }

    @Override
    public String writer(@NotNull Map<String, Object> objectMap, @NotNull String templateName, @NotNull String templateString) throws Exception {
        StringWriter writer = new StringWriter();
        this.velocityEngine.evaluate((Context)new VelocityContext(objectMap), (Writer)writer, templateName, templateString);
        return writer.toString();
    }

    @Override
    public void writer(@NotNull Map<String, Object> objectMap, @NotNull String templatePath, @NotNull File outputFile) throws Exception {
        Template template = this.velocityEngine.getTemplate(templatePath, ConstVal.UTF8);
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fos, ConstVal.UTF8);
             BufferedWriter writer = new BufferedWriter(ow);){
            template.merge((Context)new VelocityContext(objectMap), (Writer)writer);
        }
        this.LOGGER.debug("\u6a21\u677f:{};  \u6587\u4ef6:{}", (Object)templatePath, (Object)outputFile);
    }

    @Override
    @NotNull
    public String templateFilePath(@NotNull String filePath) {
        String dotVm = ".vm";
        return filePath.endsWith(".vm") ? filePath : filePath + ".vm";
    }
}

