/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.generator.config.IConfigBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class InjectionConfig {
    private BiConsumer<TableInfo, Map<String, Object>> beforeOutputFileBiConsumer;
    private Map<String, Object> customMap = new HashMap<String, Object>();
    private Map<String, String> customFile = new HashMap<String, String>();

    @NotNull
    public void beforeOutputFile(TableInfo tableInfo, Map<String, Object> objectMap) {
        if (!this.customMap.isEmpty()) {
            objectMap.putAll(this.customMap);
        }
        if (null != this.beforeOutputFileBiConsumer) {
            this.beforeOutputFileBiConsumer.accept(tableInfo, objectMap);
        }
    }

    @NotNull
    public Map<String, Object> getCustomMap() {
        return this.customMap;
    }

    @NotNull
    public Map<String, String> getCustomFile() {
        return this.customFile;
    }

    public static class Builder
    implements IConfigBuilder<InjectionConfig> {
        private final InjectionConfig injectionConfig = new InjectionConfig();

        public Builder beforeOutputFile(@NotNull BiConsumer<TableInfo, Map<String, Object>> biConsumer) {
            this.injectionConfig.beforeOutputFileBiConsumer = biConsumer;
            return this;
        }

        public Builder customMap(@NotNull Map<String, Object> customMap) {
            this.injectionConfig.customMap = customMap;
            return this;
        }

        public Builder customFile(@NotNull Map<String, String> customFile) {
            this.injectionConfig.customFile = customFile;
            return this;
        }

        @Override
        public InjectionConfig build() {
            return this.injectionConfig;
        }
    }
}

