/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.engine;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.FileType;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractTemplateEngine.class);
    private ConfigBuilder configBuilder;

    public AbstractTemplateEngine init(ConfigBuilder configBuilder) {
        this.configBuilder = configBuilder;
        return this;
    }

    public AbstractTemplateEngine batchOutput() {
        try {
            List<TableInfo> tableInfoList = this.getConfigBuilder().getTableInfoList();
            for (TableInfo tableInfo : tableInfoList) {
                String controllerFile;
                String implFile;
                String serviceFile;
                String xmlFile;
                String mapperFile;
                String entityFile;
                String entityName;
                Map<String, Object> objectMap = this.getObjectMap(tableInfo);
                Map<String, String> pathInfo = this.getConfigBuilder().getPathInfo();
                TemplateConfig template = this.getConfigBuilder().getTemplate();
                InjectionConfig injectionConfig = this.getConfigBuilder().getInjectionConfig();
                if (null != injectionConfig) {
                    injectionConfig.initTableMap(tableInfo);
                    objectMap.put("cfg", injectionConfig.getMap());
                    List<FileOutConfig> focList = injectionConfig.getFileOutConfigList();
                    if (CollectionUtils.isNotEmpty(focList)) {
                        for (FileOutConfig foc : focList) {
                            if (!this.isCreate(FileType.OTHER, foc.outputFile(tableInfo))) continue;
                            this.writerFile(objectMap, foc.getTemplatePath(), foc.outputFile(tableInfo));
                        }
                    }
                }
                if (null != (entityName = tableInfo.getEntityName()) && null != pathInfo.get("entity_path") && this.isCreate(FileType.ENTITY, entityFile = String.format(pathInfo.get("entity_path") + File.separator + "%s" + this.suffixJavaOrKt(), entityName))) {
                    this.writerFile(objectMap, this.templateFilePath(template.getEntity(this.getConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
                }
                if (null != tableInfo.getMapperName() && null != pathInfo.get("mapper_path") && this.isCreate(FileType.MAPPER, mapperFile = String.format(pathInfo.get("mapper_path") + File.separator + tableInfo.getMapperName() + this.suffixJavaOrKt(), entityName))) {
                    this.writerFile(objectMap, this.templateFilePath(template.getMapper()), mapperFile);
                }
                if (null != tableInfo.getXmlName() && null != pathInfo.get("xml_path") && this.isCreate(FileType.XML, xmlFile = String.format(pathInfo.get("xml_path") + File.separator + tableInfo.getXmlName() + ".xml", entityName))) {
                    this.writerFile(objectMap, this.templateFilePath(template.getXml()), xmlFile);
                }
                if (null != tableInfo.getServiceName() && null != pathInfo.get("service_path") && this.isCreate(FileType.SERVICE, serviceFile = String.format(pathInfo.get("service_path") + File.separator + tableInfo.getServiceName() + this.suffixJavaOrKt(), entityName))) {
                    this.writerFile(objectMap, this.templateFilePath(template.getService()), serviceFile);
                }
                if (null != tableInfo.getServiceImplName() && null != pathInfo.get("service_impl_path") && this.isCreate(FileType.SERVICE_IMPL, implFile = String.format(pathInfo.get("service_impl_path") + File.separator + tableInfo.getServiceImplName() + this.suffixJavaOrKt(), entityName))) {
                    this.writerFile(objectMap, this.templateFilePath(template.getServiceImpl()), implFile);
                }
                if (null == tableInfo.getControllerName() || null == pathInfo.get("controller_path") || !this.isCreate(FileType.CONTROLLER, controllerFile = String.format(pathInfo.get("controller_path") + File.separator + tableInfo.getControllerName() + this.suffixJavaOrKt(), entityName))) continue;
                this.writerFile(objectMap, this.templateFilePath(template.getController()), controllerFile);
            }
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
        }
        return this;
    }

    protected void writerFile(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)templatePath)) {
            this.writer(objectMap, templatePath, outputFile);
        }
    }

    public abstract void writer(Map<String, Object> var1, String var2, String var3) throws Exception;

    public AbstractTemplateEngine mkdirs() {
        this.getConfigBuilder().getPathInfo().forEach((key, value) -> {
            boolean result;
            File dir = new File((String)value);
            if (!dir.exists() && (result = dir.mkdirs())) {
                logger.debug("\u521b\u5efa\u76ee\u5f55\uff1a [" + value + "]");
            }
        });
        return this;
    }

    public void open() {
        String outDir = this.getConfigBuilder().getGlobalConfig().getOutputDir();
        if (this.getConfigBuilder().getGlobalConfig().isOpen() && StringUtils.isNotBlank((CharSequence)outDir)) {
            try {
                String osName = System.getProperty("os.name");
                if (osName != null) {
                    if (osName.contains("Mac")) {
                        Runtime.getRuntime().exec("open " + outDir);
                    } else if (osName.contains("Windows")) {
                        Runtime.getRuntime().exec("cmd /c start " + outDir);
                    } else {
                        logger.debug("\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55:" + outDir);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, Object> getObjectMap(TableInfo tableInfo) {
        HashMap objectMap;
        ConfigBuilder config = this.getConfigBuilder();
        if (config.getStrategyConfig().isControllerMappingHyphenStyle()) {
            objectMap = CollectionUtils.newHashMapWithExpectedSize((int)33);
            objectMap.put("controllerMappingHyphenStyle", config.getStrategyConfig().isControllerMappingHyphenStyle());
            objectMap.put("controllerMappingHyphen", StringUtils.camelToHyphen((String)tableInfo.getEntityPath()));
        } else {
            objectMap = CollectionUtils.newHashMapWithExpectedSize((int)31);
        }
        objectMap.put("restControllerStyle", config.getStrategyConfig().isRestControllerStyle());
        objectMap.put("config", config);
        objectMap.put("package", config.getPackageInfo());
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("idType", globalConfig.getIdType() == null ? null : globalConfig.getIdType().toString());
        objectMap.put("logicDeleteFieldName", config.getStrategyConfig().getLogicDeleteFieldName());
        objectMap.put("versionFieldName", config.getStrategyConfig().getVersionFieldName());
        objectMap.put("activeRecord", globalConfig.isActiveRecord());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("swagger2", globalConfig.isSwagger2());
        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        objectMap.put("table", tableInfo);
        objectMap.put("enableCache", globalConfig.isEnableCache());
        objectMap.put("baseResultMap", globalConfig.isBaseResultMap());
        objectMap.put("baseColumnList", globalConfig.isBaseColumnList());
        objectMap.put("entity", tableInfo.getEntityName());
        objectMap.put("entitySerialVersionUID", config.getStrategyConfig().isEntitySerialVersionUID());
        objectMap.put("entityColumnConstant", config.getStrategyConfig().isEntityColumnConstant());
        objectMap.put("entityBuilderModel", config.getStrategyConfig().isEntityBuilderModel());
        objectMap.put("chainModel", config.getStrategyConfig().isChainModel());
        objectMap.put("entityLombokModel", config.getStrategyConfig().isEntityLombokModel());
        objectMap.put("entityBooleanColumnRemoveIsPrefix", config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix());
        objectMap.put("superEntityClass", this.getSuperClassName(config.getSuperEntityClass()));
        objectMap.put("superMapperClassPackage", config.getSuperMapperClass());
        objectMap.put("superMapperClass", this.getSuperClassName(config.getSuperMapperClass()));
        objectMap.put("superServiceClassPackage", config.getSuperServiceClass());
        objectMap.put("superServiceClass", this.getSuperClassName(config.getSuperServiceClass()));
        objectMap.put("superServiceImplClassPackage", config.getSuperServiceImplClass());
        objectMap.put("superServiceImplClass", this.getSuperClassName(config.getSuperServiceImplClass()));
        objectMap.put("superControllerClassPackage", this.verifyClassPacket(config.getSuperControllerClass()));
        objectMap.put("superControllerClass", this.getSuperClassName(config.getSuperControllerClass()));
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    private String verifyClassPacket(String classPacket) {
        return StringUtils.isBlank((CharSequence)classPacket) ? null : classPacket;
    }

    private String getSuperClassName(String classPath) {
        if (StringUtils.isBlank((CharSequence)classPath)) {
            return null;
        }
        return classPath.substring(classPath.lastIndexOf(".") + 1);
    }

    public abstract String templateFilePath(String var1);

    protected boolean isCreate(FileType fileType, String filePath) {
        ConfigBuilder cb = this.getConfigBuilder();
        InjectionConfig ic = cb.getInjectionConfig();
        if (null != ic && null != ic.getFileCreate()) {
            return ic.getFileCreate().isCreate(cb, fileType, filePath);
        }
        File file = new File(filePath);
        boolean exist = file.exists();
        if (!exist) {
            file.getParentFile().mkdirs();
        }
        return !exist || this.getConfigBuilder().getGlobalConfig().isFileOverride();
    }

    protected String suffixJavaOrKt() {
        return this.getConfigBuilder().getGlobalConfig().isKotlin() ? ".kt" : ".java";
    }

    public ConfigBuilder getConfigBuilder() {
        return this.configBuilder;
    }

    public AbstractTemplateEngine setConfigBuilder(ConfigBuilder configBuilder) {
        this.configBuilder = configBuilder;
        return this;
    }
}

