/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.baomidou.mybatisplus.generator.config.IKeyWordsHandler;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.TypeConverts;
import com.baomidou.mybatisplus.generator.config.querys.DbQueryRegistry;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Optional;

public class DataSourceConfig {
    private IDbQuery dbQuery;
    private DbType dbType;
    private String schemaName;
    private ITypeConvert typeConvert;
    private IKeyWordsHandler keyWordsHandler;
    private String url;
    private String driverName;
    private String username;
    private String password;

    public IDbQuery getDbQuery() {
        if (null == this.dbQuery) {
            DbType dbType = this.getDbType();
            DbQueryRegistry dbQueryRegistry = new DbQueryRegistry();
            this.dbQuery = Optional.ofNullable(dbQueryRegistry.getDbQuery(dbType)).orElseGet(() -> dbQueryRegistry.getDbQuery(DbType.MYSQL));
        }
        return this.dbQuery;
    }

    public DbType getDbType() {
        if (null == this.dbType) {
            this.dbType = this.getDbType(this.driverName);
            if (null == this.dbType) {
                this.dbType = this.getDbType(this.url.toLowerCase());
                if (null == this.dbType) {
                    throw ExceptionUtils.mpe((String)"Unknown type of database!", (Object[])new Object[0]);
                }
            }
        }
        return this.dbType;
    }

    private DbType getDbType(String str) {
        if (str.contains("mysql")) {
            return DbType.MYSQL;
        }
        if (str.contains("oracle")) {
            return DbType.ORACLE;
        }
        if (str.contains("postgresql")) {
            return DbType.POSTGRE_SQL;
        }
        if (str.contains("sqlserver")) {
            return DbType.SQL_SERVER;
        }
        if (str.contains("db2")) {
            return DbType.DB2;
        }
        if (str.contains("mariadb")) {
            return DbType.MARIADB;
        }
        if (str.contains("sqlite")) {
            return DbType.SQLITE;
        }
        if (str.contains("h2")) {
            return DbType.H2;
        }
        if (str.contains("kingbase") || str.contains("kingbase8")) {
            return DbType.KINGBASE_ES;
        }
        if (str.contains("dm")) {
            return DbType.DM;
        }
        if (str.contains("zenith")) {
            return DbType.GAUSS;
        }
        if (str.contains("oscar")) {
            return DbType.OSCAR;
        }
        if (str.contains("firebird")) {
            return DbType.FIREBIRD;
        }
        return DbType.OTHER;
    }

    public ITypeConvert getTypeConvert() {
        if (null == this.typeConvert) {
            DbType dbType = this.getDbType();
            this.typeConvert = TypeConverts.getTypeConvert(dbType);
            if (null == this.typeConvert) {
                this.typeConvert = MySqlTypeConvert.INSTANCE;
            }
        }
        return this.typeConvert;
    }

    public Connection getConn() {
        Connection conn;
        try {
            Class.forName(this.driverName);
            conn = DriverManager.getConnection(this.url, this.username, this.password);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
        return conn;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public IKeyWordsHandler getKeyWordsHandler() {
        return this.keyWordsHandler;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public DataSourceConfig setDbQuery(IDbQuery dbQuery) {
        this.dbQuery = dbQuery;
        return this;
    }

    public DataSourceConfig setDbType(DbType dbType) {
        this.dbType = dbType;
        return this;
    }

    public DataSourceConfig setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public DataSourceConfig setTypeConvert(ITypeConvert typeConvert) {
        this.typeConvert = typeConvert;
        return this;
    }

    public DataSourceConfig setKeyWordsHandler(IKeyWordsHandler keyWordsHandler) {
        this.keyWordsHandler = keyWordsHandler;
        return this;
    }

    public DataSourceConfig setUrl(String url) {
        this.url = url;
        return this;
    }

    public DataSourceConfig setDriverName(String driverName) {
        this.driverName = driverName;
        return this;
    }

    public DataSourceConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public DataSourceConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceConfig)) {
            return false;
        }
        DataSourceConfig other = (DataSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IDbQuery this$dbQuery = this.getDbQuery();
        IDbQuery other$dbQuery = other.getDbQuery();
        if (this$dbQuery == null ? other$dbQuery != null : !this$dbQuery.equals(other$dbQuery)) {
            return false;
        }
        DbType this$dbType = this.getDbType();
        DbType other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        ITypeConvert this$typeConvert = this.getTypeConvert();
        ITypeConvert other$typeConvert = other.getTypeConvert();
        if (this$typeConvert == null ? other$typeConvert != null : !this$typeConvert.equals(other$typeConvert)) {
            return false;
        }
        IKeyWordsHandler this$keyWordsHandler = this.getKeyWordsHandler();
        IKeyWordsHandler other$keyWordsHandler = other.getKeyWordsHandler();
        if (this$keyWordsHandler == null ? other$keyWordsHandler != null : !this$keyWordsHandler.equals(other$keyWordsHandler)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$driverName = this.getDriverName();
        String other$driverName = other.getDriverName();
        if (this$driverName == null ? other$driverName != null : !this$driverName.equals(other$driverName)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IDbQuery $dbQuery = this.getDbQuery();
        result = result * 59 + ($dbQuery == null ? 43 : $dbQuery.hashCode());
        DbType $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : $dbType.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        ITypeConvert $typeConvert = this.getTypeConvert();
        result = result * 59 + ($typeConvert == null ? 43 : $typeConvert.hashCode());
        IKeyWordsHandler $keyWordsHandler = this.getKeyWordsHandler();
        result = result * 59 + ($keyWordsHandler == null ? 43 : $keyWordsHandler.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $driverName = this.getDriverName();
        result = result * 59 + ($driverName == null ? 43 : $driverName.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "DataSourceConfig(dbQuery=" + this.getDbQuery() + ", dbType=" + this.getDbType() + ", schemaName=" + this.getSchemaName() + ", typeConvert=" + this.getTypeConvert() + ", keyWordsHandler=" + this.getKeyWordsHandler() + ", url=" + this.getUrl() + ", driverName=" + this.getDriverName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }
}

