/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.converts;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.DB2TypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.DmTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.KingbaseESTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.OracleTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.PostgreSqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.SqlServerTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.SqliteTypeConvert;
import java.util.EnumMap;
import java.util.Map;

public class TypeConvertRegistry {
    private final Map<DbType, ITypeConvert> type_convert_enum_map = new EnumMap<DbType, ITypeConvert>(DbType.class);

    public TypeConvertRegistry() {
        this.type_convert_enum_map.put(DbType.ORACLE, new OracleTypeConvert());
        this.type_convert_enum_map.put(DbType.SQL_SERVER, new SqlServerTypeConvert());
        this.type_convert_enum_map.put(DbType.POSTGRE_SQL, new PostgreSqlTypeConvert());
        this.type_convert_enum_map.put(DbType.DB2, new DB2TypeConvert());
        this.type_convert_enum_map.put(DbType.SQLITE, new SqliteTypeConvert());
        this.type_convert_enum_map.put(DbType.DM, new DmTypeConvert());
        this.type_convert_enum_map.put(DbType.MARIADB, new MySqlTypeConvert());
        this.type_convert_enum_map.put(DbType.KINGBASE_ES, new KingbaseESTypeConvert());
        this.type_convert_enum_map.put(DbType.MYSQL, new MySqlTypeConvert());
    }

    public ITypeConvert getTypeConvert(DbType dbType) {
        return this.type_convert_enum_map.get(dbType);
    }
}

