/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.rules;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.Arrays;

public enum NamingStrategy {
    no_change,
    underline_to_camel;


    public static String underlineToCamel(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return "";
        }
        String tempName = name;
        if (StringUtils.isCapitalMode((String)name) || StringUtils.isMixedMode((String)name)) {
            tempName = name.toLowerCase();
        }
        StringBuilder result = new StringBuilder();
        String[] camels = tempName.split("_");
        Arrays.stream(camels).filter(camel -> !StringUtils.isEmpty((CharSequence)camel)).forEach(camel -> {
            if (result.length() == 0) {
                result.append((String)camel);
            } else {
                result.append(NamingStrategy.capitalFirst(camel));
            }
        });
        return result.toString();
    }

    public static String removePrefix(String name, String ... prefix) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return "";
        }
        if (null != prefix) {
            return Arrays.stream(prefix).filter(pf -> name.toLowerCase().matches("^" + pf.toLowerCase() + ".*")).findFirst().map(pf -> name.substring(pf.length())).orElse(name);
        }
        return name;
    }

    public static boolean isPrefixContained(String name, String ... prefix) {
        if (null == prefix || StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        return Arrays.stream(prefix).anyMatch(pf -> name.toLowerCase().matches("^" + pf.toLowerCase() + ".*"));
    }

    public static String removePrefixAndCamel(String name, String[] tablePrefix) {
        return NamingStrategy.underlineToCamel(NamingStrategy.removePrefix(name, tablePrefix));
    }

    public static String capitalFirst(String name) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }
}

