/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.sql.Connection;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;

public class BlockAttackInnerInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    @Override
    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler handler = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = handler.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            if (InterceptorIgnoreHelper.willIgnoreBlockAttack((String)ms.getId())) {
                return;
            }
            BoundSql boundSql = handler.boundSql();
            this.parserMulti(boundSql.getSql(), null);
        }
    }

    @Override
    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        this.checkWhere(delete.getTable().getName(), delete.getWhere(), "Prohibition of full table deletion");
    }

    @Override
    protected void processUpdate(Update update, int index, String sql, Object obj) {
        this.checkWhere(update.getTable().getName(), update.getWhere(), "Prohibition of table update operation");
    }

    protected void checkWhere(String tableName, Expression where, String ex) {
        Assert.isFalse((boolean)this.fullMatch(where, this.getTableLogicField(tableName)), (String)ex, (Object[])new Object[0]);
    }

    private boolean fullMatch(Expression where, String logicField) {
        if (where == null) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)logicField)) {
            BinaryExpression binaryExpression;
            if (where instanceof BinaryExpression && (StringUtils.equals((CharSequence)(binaryExpression = (BinaryExpression)where).getLeftExpression().toString(), (CharSequence)logicField) || StringUtils.equals((CharSequence)binaryExpression.getRightExpression().toString(), (CharSequence)logicField))) {
                return true;
            }
            if (where instanceof IsNullExpression && StringUtils.equals((CharSequence)(binaryExpression = (IsNullExpression)where).getLeftExpression().toString(), (CharSequence)logicField)) {
                return true;
            }
        }
        if (where instanceof EqualsTo) {
            EqualsTo equalsTo = (EqualsTo)where;
            return StringUtils.equals((CharSequence)equalsTo.getLeftExpression().toString(), (CharSequence)equalsTo.getRightExpression().toString());
        }
        if (where instanceof NotEqualsTo) {
            NotEqualsTo notEqualsTo = (NotEqualsTo)where;
            return !StringUtils.equals((CharSequence)notEqualsTo.getLeftExpression().toString(), (CharSequence)notEqualsTo.getRightExpression().toString());
        }
        if (where instanceof OrExpression) {
            OrExpression orExpression = (OrExpression)where;
            return this.fullMatch(orExpression.getLeftExpression(), logicField) || this.fullMatch(orExpression.getRightExpression(), logicField);
        }
        if (where instanceof AndExpression) {
            AndExpression andExpression = (AndExpression)where;
            return this.fullMatch(andExpression.getLeftExpression(), logicField) && this.fullMatch(andExpression.getRightExpression(), logicField);
        }
        if (where instanceof ParenthesedExpressionList) {
            ParenthesedExpressionList parenthesis = (ParenthesedExpressionList)where;
            return this.fullMatch((Expression)parenthesis.get(0), logicField);
        }
        return false;
    }

    private String getTableLogicField(String tableName) {
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return "";
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        if (tableInfo == null || !tableInfo.isWithLogicDelete() || tableInfo.getLogicDeleteFieldInfo() == null) {
            return "";
        }
        return tableInfo.getLogicDeleteFieldInfo().getColumn();
    }
}

